<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Kursabschnittsbeginn StructType
 * @subpackage Structs
 */
class Kursabschnittsbeginn extends AbstractStructBase
{
    /**
     * The kursdurchfuehrung
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\KursVerlauf
     */
    public $kursdurchfuehrung;
    /**
     * The aktuellerKursabschnitt
     * Meta information extracted from the WSDL
     * - documentation: Angaben zum aktuell begonnen Kursabschnitt.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Abschnitt
     */
    public $aktuellerKursabschnitt;
    /**
     * The kursleiter
     * Meta information extracted from the WSDL
     * - documentation: Liste der Lehrkräfte, die diesen Kurs bzw. Kursabschnitt unterrichten. Eine erfolgreiche Meldung erfordert, dass mindestens eine Lehrkraft mit der notwendigen Zulassung identifizierbar ist.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\LehrkraftIdentifikation[]
     */
    public $kursleiter;
    /**
     * The gesamteAnzahlTN
     * Meta information extracted from the WSDL
     * - documentation: Gesamtzahl der Teilnehmer des Kurses inklusive der nicht durch das BAMF geförderten Teilnehmer. Muss mindestens so groß wie die Zahl der in der Teilnehmerliste gemeldeten geförderten Teilnehmer sein.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $gesamteAnzahlTN;
    /**
     * The kursortAenderungen
     * Meta information extracted from the WSDL
     * - documentation: Angaben zu bereits erfolgten Änderungen des Kursorts in diesem Kursabschnitt.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KursortAenderung[]
     */
    public $kursortAenderungen;
    /**
     * The lehrmittel
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\LehrmittelIdentifikation[]
     */
    public $lehrmittel;
    /**
     * The vorzeitigesKursende
     * Meta information extracted from the WSDL
     * - documentation: Codeliste 816. Wird genutzt um zu melden, dass deraktuelle Kursabschnitt voraussichtlich der letzte Kursabschnitt sein wird bzw. tatsächlich der letzte war.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vorzeitigesKursende;
    /**
     * The exkursion
     * Meta information extracted from the WSDL
     * - documentation: Alle Exkursionen des Kursabschnitts und alle bereits zukünftig geplanten Exkursionen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Exkursion[]
     */
    public $exkursion;
    /**
     * Constructor method for Kursabschnittsbeginn
     * @uses Kursabschnittsbeginn::setKursdurchfuehrung()
     * @uses Kursabschnittsbeginn::setAktuellerKursabschnitt()
     * @uses Kursabschnittsbeginn::setKursleiter()
     * @uses Kursabschnittsbeginn::setGesamteAnzahlTN()
     * @uses Kursabschnittsbeginn::setKursortAenderungen()
     * @uses Kursabschnittsbeginn::setLehrmittel()
     * @uses Kursabschnittsbeginn::setVorzeitigesKursende()
     * @uses Kursabschnittsbeginn::setExkursion()
     * @param \StructType\KursVerlauf $kursdurchfuehrung
     * @param \StructType\Abschnitt $aktuellerKursabschnitt
     * @param \StructType\LehrkraftIdentifikation[] $kursleiter
     * @param int $gesamteAnzahlTN
     * @param \StructType\KursortAenderung[] $kursortAenderungen
     * @param \StructType\LehrmittelIdentifikation[] $lehrmittel
     * @param string $vorzeitigesKursende
     * @param \StructType\Exkursion[] $exkursion
     */
    public function __construct(\StructType\KursVerlauf $kursdurchfuehrung = null, \StructType\Abschnitt $aktuellerKursabschnitt = null, array $kursleiter = array(), $gesamteAnzahlTN = null, array $kursortAenderungen = array(), array $lehrmittel = array(), $vorzeitigesKursende = null, array $exkursion = array())
    {
        $this
            ->setKursdurchfuehrung($kursdurchfuehrung)
            ->setAktuellerKursabschnitt($aktuellerKursabschnitt)
            ->setKursleiter($kursleiter)
            ->setGesamteAnzahlTN($gesamteAnzahlTN)
            ->setKursortAenderungen($kursortAenderungen)
            ->setLehrmittel($lehrmittel)
            ->setVorzeitigesKursende($vorzeitigesKursende)
            ->setExkursion($exkursion);
    }
    /**
     * Get kursdurchfuehrung value
     * @return \StructType\KursVerlauf
     */
    public function getKursdurchfuehrung()
    {
        return $this->kursdurchfuehrung;
    }
    /**
     * Set kursdurchfuehrung value
     * @param \StructType\KursVerlauf $kursdurchfuehrung
     * @return \StructType\Kursabschnittsbeginn
     */
    public function setKursdurchfuehrung(\StructType\KursVerlauf $kursdurchfuehrung = null)
    {
        $this->kursdurchfuehrung = $kursdurchfuehrung;
        return $this;
    }
    /**
     * Get aktuellerKursabschnitt value
     * @return \StructType\Abschnitt
     */
    public function getAktuellerKursabschnitt()
    {
        return $this->aktuellerKursabschnitt;
    }
    /**
     * Set aktuellerKursabschnitt value
     * @param \StructType\Abschnitt $aktuellerKursabschnitt
     * @return \StructType\Kursabschnittsbeginn
     */
    public function setAktuellerKursabschnitt(\StructType\Abschnitt $aktuellerKursabschnitt = null)
    {
        $this->aktuellerKursabschnitt = $aktuellerKursabschnitt;
        return $this;
    }
    /**
     * Get kursleiter value
     * @return \StructType\LehrkraftIdentifikation[]
     */
    public function getKursleiter()
    {
        return $this->kursleiter;
    }
    /**
     * This method is responsible for validating the values passed to the setKursleiter method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKursleiter method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKursleiterForArrayConstraintsFromSetKursleiter(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kursabschnittsbeginnKursleiterItem) {
            // validation for constraint: itemType
            if (!$kursabschnittsbeginnKursleiterItem instanceof \StructType\LehrkraftIdentifikation) {
                $invalidValues[] = is_object($kursabschnittsbeginnKursleiterItem) ? get_class($kursabschnittsbeginnKursleiterItem) : sprintf('%s(%s)', gettype($kursabschnittsbeginnKursleiterItem), var_export($kursabschnittsbeginnKursleiterItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kursleiter property can only contain items of type \StructType\LehrkraftIdentifikation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kursleiter value
     * @throws \InvalidArgumentException
     * @param \StructType\LehrkraftIdentifikation[] $kursleiter
     * @return \StructType\Kursabschnittsbeginn
     */
    public function setKursleiter(array $kursleiter = array())
    {
        // validation for constraint: array
        if ('' !== ($kursleiterArrayErrorMessage = self::validateKursleiterForArrayConstraintsFromSetKursleiter($kursleiter))) {
            throw new \InvalidArgumentException($kursleiterArrayErrorMessage, __LINE__);
        }
        $this->kursleiter = $kursleiter;
        return $this;
    }
    /**
     * Add item to kursleiter value
     * @throws \InvalidArgumentException
     * @param \StructType\LehrkraftIdentifikation $item
     * @return \StructType\Kursabschnittsbeginn
     */
    public function addToKursleiter(\StructType\LehrkraftIdentifikation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LehrkraftIdentifikation) {
            throw new \InvalidArgumentException(sprintf('The kursleiter property can only contain items of type \StructType\LehrkraftIdentifikation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kursleiter[] = $item;
        return $this;
    }
    /**
     * Get gesamteAnzahlTN value
     * @return int
     */
    public function getGesamteAnzahlTN()
    {
        return $this->gesamteAnzahlTN;
    }
    /**
     * Set gesamteAnzahlTN value
     * @param int $gesamteAnzahlTN
     * @return \StructType\Kursabschnittsbeginn
     */
    public function setGesamteAnzahlTN($gesamteAnzahlTN = null)
    {
        // validation for constraint: int
        if (!is_null($gesamteAnzahlTN) && !(is_int($gesamteAnzahlTN) || ctype_digit($gesamteAnzahlTN))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($gesamteAnzahlTN, true), gettype($gesamteAnzahlTN)), __LINE__);
        }
        $this->gesamteAnzahlTN = $gesamteAnzahlTN;
        return $this;
    }
    /**
     * Get kursortAenderungen value
     * @return \StructType\KursortAenderung[]|null
     */
    public function getKursortAenderungen()
    {
        return $this->kursortAenderungen;
    }
    /**
     * This method is responsible for validating the values passed to the setKursortAenderungen method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKursortAenderungen method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKursortAenderungenForArrayConstraintsFromSetKursortAenderungen(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kursabschnittsbeginnKursortAenderungenItem) {
            // validation for constraint: itemType
            if (!$kursabschnittsbeginnKursortAenderungenItem instanceof \StructType\KursortAenderung) {
                $invalidValues[] = is_object($kursabschnittsbeginnKursortAenderungenItem) ? get_class($kursabschnittsbeginnKursortAenderungenItem) : sprintf('%s(%s)', gettype($kursabschnittsbeginnKursortAenderungenItem), var_export($kursabschnittsbeginnKursortAenderungenItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kursortAenderungen property can only contain items of type \StructType\KursortAenderung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kursortAenderungen value
     * @throws \InvalidArgumentException
     * @param \StructType\KursortAenderung[] $kursortAenderungen
     * @return \StructType\Kursabschnittsbeginn
     */
    public function setKursortAenderungen(array $kursortAenderungen = array())
    {
        // validation for constraint: array
        if ('' !== ($kursortAenderungenArrayErrorMessage = self::validateKursortAenderungenForArrayConstraintsFromSetKursortAenderungen($kursortAenderungen))) {
            throw new \InvalidArgumentException($kursortAenderungenArrayErrorMessage, __LINE__);
        }
        $this->kursortAenderungen = $kursortAenderungen;
        return $this;
    }
    /**
     * Add item to kursortAenderungen value
     * @throws \InvalidArgumentException
     * @param \StructType\KursortAenderung $item
     * @return \StructType\Kursabschnittsbeginn
     */
    public function addToKursortAenderungen(\StructType\KursortAenderung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KursortAenderung) {
            throw new \InvalidArgumentException(sprintf('The kursortAenderungen property can only contain items of type \StructType\KursortAenderung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kursortAenderungen[] = $item;
        return $this;
    }
    /**
     * Get lehrmittel value
     * @return \StructType\LehrmittelIdentifikation[]|null
     */
    public function getLehrmittel()
    {
        return $this->lehrmittel;
    }
    /**
     * This method is responsible for validating the values passed to the setLehrmittel method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLehrmittel method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLehrmittelForArrayConstraintsFromSetLehrmittel(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kursabschnittsbeginnLehrmittelItem) {
            // validation for constraint: itemType
            if (!$kursabschnittsbeginnLehrmittelItem instanceof \StructType\LehrmittelIdentifikation) {
                $invalidValues[] = is_object($kursabschnittsbeginnLehrmittelItem) ? get_class($kursabschnittsbeginnLehrmittelItem) : sprintf('%s(%s)', gettype($kursabschnittsbeginnLehrmittelItem), var_export($kursabschnittsbeginnLehrmittelItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The lehrmittel property can only contain items of type \StructType\LehrmittelIdentifikation, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set lehrmittel value
     * @throws \InvalidArgumentException
     * @param \StructType\LehrmittelIdentifikation[] $lehrmittel
     * @return \StructType\Kursabschnittsbeginn
     */
    public function setLehrmittel(array $lehrmittel = array())
    {
        // validation for constraint: array
        if ('' !== ($lehrmittelArrayErrorMessage = self::validateLehrmittelForArrayConstraintsFromSetLehrmittel($lehrmittel))) {
            throw new \InvalidArgumentException($lehrmittelArrayErrorMessage, __LINE__);
        }
        $this->lehrmittel = $lehrmittel;
        return $this;
    }
    /**
     * Add item to lehrmittel value
     * @throws \InvalidArgumentException
     * @param \StructType\LehrmittelIdentifikation $item
     * @return \StructType\Kursabschnittsbeginn
     */
    public function addToLehrmittel(\StructType\LehrmittelIdentifikation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LehrmittelIdentifikation) {
            throw new \InvalidArgumentException(sprintf('The lehrmittel property can only contain items of type \StructType\LehrmittelIdentifikation, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->lehrmittel[] = $item;
        return $this;
    }
    /**
     * Get vorzeitigesKursende value
     * @return string|null
     */
    public function getVorzeitigesKursende()
    {
        return $this->vorzeitigesKursende;
    }
    /**
     * Set vorzeitigesKursende value
     * @param string $vorzeitigesKursende
     * @return \StructType\Kursabschnittsbeginn
     */
    public function setVorzeitigesKursende($vorzeitigesKursende = null)
    {
        // validation for constraint: string
        if (!is_null($vorzeitigesKursende) && !is_string($vorzeitigesKursende)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorzeitigesKursende, true), gettype($vorzeitigesKursende)), __LINE__);
        }
        $this->vorzeitigesKursende = $vorzeitigesKursende;
        return $this;
    }
    /**
     * Get exkursion value
     * @return \StructType\Exkursion[]|null
     */
    public function getExkursion()
    {
        return $this->exkursion;
    }
    /**
     * This method is responsible for validating the values passed to the setExkursion method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExkursion method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExkursionForArrayConstraintsFromSetExkursion(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kursabschnittsbeginnExkursionItem) {
            // validation for constraint: itemType
            if (!$kursabschnittsbeginnExkursionItem instanceof \StructType\Exkursion) {
                $invalidValues[] = is_object($kursabschnittsbeginnExkursionItem) ? get_class($kursabschnittsbeginnExkursionItem) : sprintf('%s(%s)', gettype($kursabschnittsbeginnExkursionItem), var_export($kursabschnittsbeginnExkursionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The exkursion property can only contain items of type \StructType\Exkursion, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set exkursion value
     * @throws \InvalidArgumentException
     * @param \StructType\Exkursion[] $exkursion
     * @return \StructType\Kursabschnittsbeginn
     */
    public function setExkursion(array $exkursion = array())
    {
        // validation for constraint: array
        if ('' !== ($exkursionArrayErrorMessage = self::validateExkursionForArrayConstraintsFromSetExkursion($exkursion))) {
            throw new \InvalidArgumentException($exkursionArrayErrorMessage, __LINE__);
        }
        $this->exkursion = $exkursion;
        return $this;
    }
    /**
     * Add item to exkursion value
     * @throws \InvalidArgumentException
     * @param \StructType\Exkursion $item
     * @return \StructType\Kursabschnittsbeginn
     */
    public function addToExkursion(\StructType\Exkursion $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Exkursion) {
            throw new \InvalidArgumentException(sprintf('The exkursion property can only contain items of type \StructType\Exkursion, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->exkursion[] = $item;
        return $this;
    }
}
