<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KursGesamt StructType
 * @subpackage Structs
 */
class KursGesamt extends AbstractStructBase
{
    /**
     * The traeger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\KurstraegerIdentifikation
     */
    public $traeger;
    /**
     * The kursart
     * Meta information extracted from the WSDL
     * - documentation: Codeliste 802.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kursart;
    /**
     * The zusatzangabe
     * Meta information extracted from the WSDL
     * - documentation: Falls zutreffend, ein oder mehrere zusätzliche Merkmale aus der Codeliste 812. Die für jedes Merkmal individuell geltenden Regelungen sind einzuhalten.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $zusatzangabe;
    /**
     * Constructor method for KursGesamt
     * @uses KursGesamt::setTraeger()
     * @uses KursGesamt::setKursart()
     * @uses KursGesamt::setZusatzangabe()
     * @param \StructType\KurstraegerIdentifikation $traeger
     * @param string $kursart
     * @param string[] $zusatzangabe
     */
    public function __construct(\StructType\KurstraegerIdentifikation $traeger = null, $kursart = null, array $zusatzangabe = array())
    {
        $this
            ->setTraeger($traeger)
            ->setKursart($kursart)
            ->setZusatzangabe($zusatzangabe);
    }
    /**
     * Get traeger value
     * @return \StructType\KurstraegerIdentifikation
     */
    public function getTraeger()
    {
        return $this->traeger;
    }
    /**
     * Set traeger value
     * @param \StructType\KurstraegerIdentifikation $traeger
     * @return \StructType\KursGesamt
     */
    public function setTraeger(\StructType\KurstraegerIdentifikation $traeger = null)
    {
        $this->traeger = $traeger;
        return $this;
    }
    /**
     * Get kursart value
     * @return string
     */
    public function getKursart()
    {
        return $this->kursart;
    }
    /**
     * Set kursart value
     * @param string $kursart
     * @return \StructType\KursGesamt
     */
    public function setKursart($kursart = null)
    {
        // validation for constraint: string
        if (!is_null($kursart) && !is_string($kursart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kursart, true), gettype($kursart)), __LINE__);
        }
        $this->kursart = $kursart;
        return $this;
    }
    /**
     * Get zusatzangabe value
     * @return string[]|null
     */
    public function getZusatzangabe()
    {
        return $this->zusatzangabe;
    }
    /**
     * This method is responsible for validating the values passed to the setZusatzangabe method
     * This method is willingly generated in order to preserve the one-line inline validation within the setZusatzangabe method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateZusatzangabeForArrayConstraintsFromSetZusatzangabe(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kursGesamtZusatzangabeItem) {
            // validation for constraint: itemType
            if (!is_string($kursGesamtZusatzangabeItem)) {
                $invalidValues[] = is_object($kursGesamtZusatzangabeItem) ? get_class($kursGesamtZusatzangabeItem) : sprintf('%s(%s)', gettype($kursGesamtZusatzangabeItem), var_export($kursGesamtZusatzangabeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The zusatzangabe property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set zusatzangabe value
     * @throws \InvalidArgumentException
     * @param string[] $zusatzangabe
     * @return \StructType\KursGesamt
     */
    public function setZusatzangabe(array $zusatzangabe = array())
    {
        // validation for constraint: array
        if ('' !== ($zusatzangabeArrayErrorMessage = self::validateZusatzangabeForArrayConstraintsFromSetZusatzangabe($zusatzangabe))) {
            throw new \InvalidArgumentException($zusatzangabeArrayErrorMessage, __LINE__);
        }
        $this->zusatzangabe = $zusatzangabe;
        return $this;
    }
    /**
     * Add item to zusatzangabe value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\KursGesamt
     */
    public function addToZusatzangabe($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The zusatzangabe property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->zusatzangabe[] = $item;
        return $this;
    }
}
