<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Kurs ServiceType
 * @subpackage Services
 */
class Kurs extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named kursAuskunftAnfordern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\KursAuskunft_kursAuskunftAnfordernElement $parameters
     * @return \StructType\KursAuskunft_kursAuskunftAnfordernResponseElement|bool
     */
    public function kursAuskunftAnfordern(\StructType\KursAuskunft_kursAuskunftAnfordernElement $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->kursAuskunftAnfordern($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\KursAuskunft_kursAuskunftAnfordernResponseElement
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
