<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transaktionsdaten StructType
 * @subpackage Structs
 */
class Transaktionsdaten extends AbstractStructBase
{
    /**
     * The kennung
     * Meta information extracted from the WSDL
     * - documentation: Die Transaktionskennung identifiziert einen Dienstaufruf eindeutig. Sie hat keinerlei fachliche Relevanz oder inhaltliche Beziehung zu dem eigentlichen Dienstaufruf.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kennung;
    /**
     * The meldung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Meldung[]
     */
    public $meldung;
    /**
     * Constructor method for Transaktionsdaten
     * @uses Transaktionsdaten::setKennung()
     * @uses Transaktionsdaten::setMeldung()
     * @param string $kennung
     * @param \StructType\Meldung[] $meldung
     */
    public function __construct($kennung = null, array $meldung = array())
    {
        $this
            ->setKennung($kennung)
            ->setMeldung($meldung);
    }
    /**
     * Get kennung value
     * @return string
     */
    public function getKennung()
    {
        return $this->kennung;
    }
    /**
     * Set kennung value
     * @param string $kennung
     * @return \StructType\Transaktionsdaten
     */
    public function setKennung($kennung = null)
    {
        // validation for constraint: string
        if (!is_null($kennung) && !is_string($kennung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kennung, true), gettype($kennung)), __LINE__);
        }
        $this->kennung = $kennung;
        return $this;
    }
    /**
     * Get meldung value
     * @return \StructType\Meldung[]|null
     */
    public function getMeldung()
    {
        return $this->meldung;
    }
    /**
     * This method is responsible for validating the values passed to the setMeldung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMeldung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMeldungForArrayConstraintsFromSetMeldung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $transaktionsdatenMeldungItem) {
            // validation for constraint: itemType
            if (!$transaktionsdatenMeldungItem instanceof \StructType\Meldung) {
                $invalidValues[] = is_object($transaktionsdatenMeldungItem) ? get_class($transaktionsdatenMeldungItem) : sprintf('%s(%s)', gettype($transaktionsdatenMeldungItem), var_export($transaktionsdatenMeldungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The meldung property can only contain items of type \StructType\Meldung, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set meldung value
     * @throws \InvalidArgumentException
     * @param \StructType\Meldung[] $meldung
     * @return \StructType\Transaktionsdaten
     */
    public function setMeldung(array $meldung = array())
    {
        // validation for constraint: array
        if ('' !== ($meldungArrayErrorMessage = self::validateMeldungForArrayConstraintsFromSetMeldung($meldung))) {
            throw new \InvalidArgumentException($meldungArrayErrorMessage, __LINE__);
        }
        $this->meldung = $meldung;
        return $this;
    }
    /**
     * Add item to meldung value
     * @throws \InvalidArgumentException
     * @param \StructType\Meldung $item
     * @return \StructType\Transaktionsdaten
     */
    public function addToMeldung(\StructType\Meldung $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Meldung) {
            throw new \InvalidArgumentException(sprintf('The meldung property can only contain items of type \StructType\Meldung, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->meldung[] = $item;
        return $this;
    }
}
