<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KursortIdentifikation StructType
 * @subpackage Structs
 */
class KursortIdentifikation extends AbstractStructBase
{
    /**
     * The kennung
     * Meta information extracted from the WSDL
     * - documentation: Die vom BAMF vergebene Kennung des Kursorts. Diese wurde im Papierverfahren bisher nicht explizit übermittelt und wird daher separat als Liste bereitgestellt.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kennung;
    /**
     * Constructor method for KursortIdentifikation
     * @uses KursortIdentifikation::setKennung()
     * @param string $kennung
     */
    public function __construct($kennung = null)
    {
        $this
            ->setKennung($kennung);
    }
    /**
     * Get kennung value
     * @return string
     */
    public function getKennung()
    {
        return $this->kennung;
    }
    /**
     * Set kennung value
     * @param string $kennung
     * @return \StructType\KursortIdentifikation
     */
    public function setKennung($kennung = null)
    {
        // validation for constraint: string
        if (!is_null($kennung) && !is_string($kennung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kennung, true), gettype($kennung)), __LINE__);
        }
        $this->kennung = $kennung;
        return $this;
    }
}
