<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KursAuskunftOutputMessage StructType
 * @subpackage Structs
 */
class KursAuskunftOutputMessage extends AbstractStructBase
{
    /**
     * The transaktionsdaten
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Transaktionsdaten
     */
    public $transaktionsdaten;
    /**
     * The kursplanung
     * Meta information extracted from the WSDL
     * - documentation: Die aktuellen Daten der Kursplanung, falls zu der gesuchten Kurskennung eine (noch nicht durch Kursbeginn abgelöste) Kursplanung erfasst ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Kursplanung
     */
    public $kursplanung;
    /**
     * The kursabschnittsbeginn
     * Meta information extracted from the WSDL
     * - documentation: Die Daten des letzten gemeldeten Kursabschnitts, falls zu der gesuchten Kurskennung ein bereits begonnener Kurs erfasst ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Kursabschnittsbeginn
     */
    public $kursabschnittsbeginn;
    /**
     * The kursDaten
     * Meta information extracted from the WSDL
     * - documentation: Allgemeine nicht änderbare Angaben zu einem bereits begonnenen Kurs.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\KursGesamtAuskunft
     */
    public $kursDaten;
    /**
     * Constructor method for KursAuskunftOutputMessage
     * @uses KursAuskunftOutputMessage::setTransaktionsdaten()
     * @uses KursAuskunftOutputMessage::setKursplanung()
     * @uses KursAuskunftOutputMessage::setKursabschnittsbeginn()
     * @uses KursAuskunftOutputMessage::setKursDaten()
     * @param \StructType\Transaktionsdaten $transaktionsdaten
     * @param \StructType\Kursplanung $kursplanung
     * @param \StructType\Kursabschnittsbeginn $kursabschnittsbeginn
     * @param \StructType\KursGesamtAuskunft $kursDaten
     */
    public function __construct(\StructType\Transaktionsdaten $transaktionsdaten = null, \StructType\Kursplanung $kursplanung = null, \StructType\Kursabschnittsbeginn $kursabschnittsbeginn = null, \StructType\KursGesamtAuskunft $kursDaten = null)
    {
        $this
            ->setTransaktionsdaten($transaktionsdaten)
            ->setKursplanung($kursplanung)
            ->setKursabschnittsbeginn($kursabschnittsbeginn)
            ->setKursDaten($kursDaten);
    }
    /**
     * Get transaktionsdaten value
     * @return \StructType\Transaktionsdaten
     */
    public function getTransaktionsdaten()
    {
        return $this->transaktionsdaten;
    }
    /**
     * Set transaktionsdaten value
     * @param \StructType\Transaktionsdaten $transaktionsdaten
     * @return \StructType\KursAuskunftOutputMessage
     */
    public function setTransaktionsdaten(\StructType\Transaktionsdaten $transaktionsdaten = null)
    {
        $this->transaktionsdaten = $transaktionsdaten;
        return $this;
    }
    /**
     * Get kursplanung value
     * @return \StructType\Kursplanung|null
     */
    public function getKursplanung()
    {
        return $this->kursplanung;
    }
    /**
     * Set kursplanung value
     * @param \StructType\Kursplanung $kursplanung
     * @return \StructType\KursAuskunftOutputMessage
     */
    public function setKursplanung(\StructType\Kursplanung $kursplanung = null)
    {
        $this->kursplanung = $kursplanung;
        return $this;
    }
    /**
     * Get kursabschnittsbeginn value
     * @return \StructType\Kursabschnittsbeginn|null
     */
    public function getKursabschnittsbeginn()
    {
        return $this->kursabschnittsbeginn;
    }
    /**
     * Set kursabschnittsbeginn value
     * @param \StructType\Kursabschnittsbeginn $kursabschnittsbeginn
     * @return \StructType\KursAuskunftOutputMessage
     */
    public function setKursabschnittsbeginn(\StructType\Kursabschnittsbeginn $kursabschnittsbeginn = null)
    {
        $this->kursabschnittsbeginn = $kursabschnittsbeginn;
        return $this;
    }
    /**
     * Get kursDaten value
     * @return \StructType\KursGesamtAuskunft|null
     */
    public function getKursDaten()
    {
        return $this->kursDaten;
    }
    /**
     * Set kursDaten value
     * @param \StructType\KursGesamtAuskunft $kursDaten
     * @return \StructType\KursAuskunftOutputMessage
     */
    public function setKursDaten(\StructType\KursGesamtAuskunft $kursDaten = null)
    {
        $this->kursDaten = $kursDaten;
        return $this;
    }
}
