<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TraegeranmeldungErstverfahrenAuskunft StructType
 * @subpackage Structs
 */
class TraegeranmeldungErstverfahrenAuskunft extends AbstractStructBase
{
    /**
     * The traeger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\KurstraegerAuskunft
     */
    public $traeger;
    /**
     * The anmeldedatum
     * Meta information extracted from the WSDL
     * - documentation: Das Datum der Anmeldung.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $anmeldedatum;
    /**
     * The bildungsstand
     * Meta information extracted from the WSDL
     * - documentation: Werte sind die ISCED-Level 1, 2, 3A, 3B, 4A, 5A, 5B, 6 oder 9 (=unbekannt).
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $bildungsstand;
    /**
     * The schreibkundigkeit
     * Meta information extracted from the WSDL
     * - documentation: Codeliste 801.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $schreibkundigkeit;
    /**
     * The einstufungstestVerzichtbar
     * Meta information extracted from the WSDL
     * - documentation: Falls nur Teilnahme am Sprachtest, Orientierungskurs oder Orientierungskurstest beabsichtigt ist, braucht kein Einstufungstest durchgeführt werden. Für diese Teilnehmer ist kein Sprachkursabschnitt abrechenbar.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $einstufungstestVerzichtbar;
    /**
     * The einstufungstestZentralisiert
     * Meta information extracted from the WSDL
     * - documentation: Spezifiziert, ob der Einstufungstest zentralisiert im Rahmen des Zusteuerungsverfahrens durchgeführt wurde.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $einstufungstestZentralisiert;
    /**
     * The anzahlSchuljahre
     * Meta information extracted from the WSDL
     * - documentation: Nur bei Bildungsstand 1.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $anzahlSchuljahre;
    /**
     * The einstufungstestdaten
     * Meta information extracted from the WSDL
     * - documentation: Die Detaildaten zum Einstufungstest entfallen genau dann, wenn EinstufungstestVerzichtbar wahr ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\EinstufungstestAuskunft
     */
    public $einstufungstestdaten;
    /**
     * Constructor method for TraegeranmeldungErstverfahrenAuskunft
     * @uses TraegeranmeldungErstverfahrenAuskunft::setTraeger()
     * @uses TraegeranmeldungErstverfahrenAuskunft::setAnmeldedatum()
     * @uses TraegeranmeldungErstverfahrenAuskunft::setBildungsstand()
     * @uses TraegeranmeldungErstverfahrenAuskunft::setSchreibkundigkeit()
     * @uses TraegeranmeldungErstverfahrenAuskunft::setEinstufungstestVerzichtbar()
     * @uses TraegeranmeldungErstverfahrenAuskunft::setEinstufungstestZentralisiert()
     * @uses TraegeranmeldungErstverfahrenAuskunft::setAnzahlSchuljahre()
     * @uses TraegeranmeldungErstverfahrenAuskunft::setEinstufungstestdaten()
     * @param \StructType\KurstraegerAuskunft $traeger
     * @param string $anmeldedatum
     * @param string $bildungsstand
     * @param string $schreibkundigkeit
     * @param bool $einstufungstestVerzichtbar
     * @param bool $einstufungstestZentralisiert
     * @param int $anzahlSchuljahre
     * @param \StructType\EinstufungstestAuskunft $einstufungstestdaten
     */
    public function __construct(\StructType\KurstraegerAuskunft $traeger = null, $anmeldedatum = null, $bildungsstand = null, $schreibkundigkeit = null, $einstufungstestVerzichtbar = null, $einstufungstestZentralisiert = null, $anzahlSchuljahre = null, \StructType\EinstufungstestAuskunft $einstufungstestdaten = null)
    {
        $this
            ->setTraeger($traeger)
            ->setAnmeldedatum($anmeldedatum)
            ->setBildungsstand($bildungsstand)
            ->setSchreibkundigkeit($schreibkundigkeit)
            ->setEinstufungstestVerzichtbar($einstufungstestVerzichtbar)
            ->setEinstufungstestZentralisiert($einstufungstestZentralisiert)
            ->setAnzahlSchuljahre($anzahlSchuljahre)
            ->setEinstufungstestdaten($einstufungstestdaten);
    }
    /**
     * Get traeger value
     * @return \StructType\KurstraegerAuskunft
     */
    public function getTraeger()
    {
        return $this->traeger;
    }
    /**
     * Set traeger value
     * @param \StructType\KurstraegerAuskunft $traeger
     * @return \StructType\TraegeranmeldungErstverfahrenAuskunft
     */
    public function setTraeger(\StructType\KurstraegerAuskunft $traeger = null)
    {
        $this->traeger = $traeger;
        return $this;
    }
    /**
     * Get anmeldedatum value
     * @return string
     */
    public function getAnmeldedatum()
    {
        return $this->anmeldedatum;
    }
    /**
     * Set anmeldedatum value
     * @param string $anmeldedatum
     * @return \StructType\TraegeranmeldungErstverfahrenAuskunft
     */
    public function setAnmeldedatum($anmeldedatum = null)
    {
        // validation for constraint: string
        if (!is_null($anmeldedatum) && !is_string($anmeldedatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($anmeldedatum, true), gettype($anmeldedatum)), __LINE__);
        }
        $this->anmeldedatum = $anmeldedatum;
        return $this;
    }
    /**
     * Get bildungsstand value
     * @return string
     */
    public function getBildungsstand()
    {
        return $this->bildungsstand;
    }
    /**
     * Set bildungsstand value
     * @param string $bildungsstand
     * @return \StructType\TraegeranmeldungErstverfahrenAuskunft
     */
    public function setBildungsstand($bildungsstand = null)
    {
        // validation for constraint: string
        if (!is_null($bildungsstand) && !is_string($bildungsstand)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bildungsstand, true), gettype($bildungsstand)), __LINE__);
        }
        $this->bildungsstand = $bildungsstand;
        return $this;
    }
    /**
     * Get schreibkundigkeit value
     * @return string
     */
    public function getSchreibkundigkeit()
    {
        return $this->schreibkundigkeit;
    }
    /**
     * Set schreibkundigkeit value
     * @param string $schreibkundigkeit
     * @return \StructType\TraegeranmeldungErstverfahrenAuskunft
     */
    public function setSchreibkundigkeit($schreibkundigkeit = null)
    {
        // validation for constraint: string
        if (!is_null($schreibkundigkeit) && !is_string($schreibkundigkeit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schreibkundigkeit, true), gettype($schreibkundigkeit)), __LINE__);
        }
        $this->schreibkundigkeit = $schreibkundigkeit;
        return $this;
    }
    /**
     * Get einstufungstestVerzichtbar value
     * @return bool
     */
    public function getEinstufungstestVerzichtbar()
    {
        return $this->einstufungstestVerzichtbar;
    }
    /**
     * Set einstufungstestVerzichtbar value
     * @param bool $einstufungstestVerzichtbar
     * @return \StructType\TraegeranmeldungErstverfahrenAuskunft
     */
    public function setEinstufungstestVerzichtbar($einstufungstestVerzichtbar = null)
    {
        // validation for constraint: boolean
        if (!is_null($einstufungstestVerzichtbar) && !is_bool($einstufungstestVerzichtbar)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($einstufungstestVerzichtbar, true), gettype($einstufungstestVerzichtbar)), __LINE__);
        }
        $this->einstufungstestVerzichtbar = $einstufungstestVerzichtbar;
        return $this;
    }
    /**
     * Get einstufungstestZentralisiert value
     * @return bool
     */
    public function getEinstufungstestZentralisiert()
    {
        return $this->einstufungstestZentralisiert;
    }
    /**
     * Set einstufungstestZentralisiert value
     * @param bool $einstufungstestZentralisiert
     * @return \StructType\TraegeranmeldungErstverfahrenAuskunft
     */
    public function setEinstufungstestZentralisiert($einstufungstestZentralisiert = null)
    {
        // validation for constraint: boolean
        if (!is_null($einstufungstestZentralisiert) && !is_bool($einstufungstestZentralisiert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($einstufungstestZentralisiert, true), gettype($einstufungstestZentralisiert)), __LINE__);
        }
        $this->einstufungstestZentralisiert = $einstufungstestZentralisiert;
        return $this;
    }
    /**
     * Get anzahlSchuljahre value
     * @return int|null
     */
    public function getAnzahlSchuljahre()
    {
        return $this->anzahlSchuljahre;
    }
    /**
     * Set anzahlSchuljahre value
     * @param int $anzahlSchuljahre
     * @return \StructType\TraegeranmeldungErstverfahrenAuskunft
     */
    public function setAnzahlSchuljahre($anzahlSchuljahre = null)
    {
        // validation for constraint: int
        if (!is_null($anzahlSchuljahre) && !(is_int($anzahlSchuljahre) || ctype_digit($anzahlSchuljahre))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($anzahlSchuljahre, true), gettype($anzahlSchuljahre)), __LINE__);
        }
        $this->anzahlSchuljahre = $anzahlSchuljahre;
        return $this;
    }
    /**
     * Get einstufungstestdaten value
     * @return \StructType\EinstufungstestAuskunft|null
     */
    public function getEinstufungstestdaten()
    {
        return $this->einstufungstestdaten;
    }
    /**
     * Set einstufungstestdaten value
     * @param \StructType\EinstufungstestAuskunft $einstufungstestdaten
     * @return \StructType\TraegeranmeldungErstverfahrenAuskunft
     */
    public function setEinstufungstestdaten(\StructType\EinstufungstestAuskunft $einstufungstestdaten = null)
    {
        $this->einstufungstestdaten = $einstufungstestdaten;
        return $this;
    }
}
