<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TeilnehmerAuskunftDaten StructType
 * @subpackage Structs
 */
class TeilnehmerAuskunftDaten extends AbstractStructBase
{
    /**
     * The teilnehmerdaten
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PersonendatenAuskunft
     */
    public $teilnehmerdaten;
    /**
     * The teilnahmeberechtigung
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TeilnahmeberechtigungAuskunft[]
     */
    public $teilnahmeberechtigung;
    /**
     * The traegeranmeldungErstverfahren
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TraegeranmeldungErstverfahrenAuskunft
     */
    public $traegeranmeldungErstverfahren;
    /**
     * The traegeranmeldungWiederholerVerfahren
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TraegeranmeldungWiederholerverfahrenAuskunft
     */
    public $traegeranmeldungWiederholerVerfahren;
    /**
     * The teilnahme
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TeilnahmeAuskunft
     */
    public $teilnahme;
    /**
     * The abschluss
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AbschlussAuskunft
     */
    public $abschluss;
    /**
     * The verpflichtungAustellendeStelle
     * Meta information extracted from the WSDL
     * - documentation: Falls die Person aktuell zur Teilnahme am Integrationskurs verpflichtet ist, werden hier die Angaben zur Behörde, die den aktuell gültigen Verpflichtungsschein ausgestellt hat, übermittelt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BehoerdeAuskunft
     */
    public $verpflichtungAustellendeStelle;
    /**
     * The weitereVerpflichtendeStelle
     * Meta information extracted from the WSDL
     * - documentation: Ggf. weitere Stellen, die die Person (z.B. per Eingliederungsvereinbarung) zur Teilnahme am Integrationskurs verpflichtet haben (ohne einen entsprechenden Verpflichtungsschein austellen zu können, da die Person bereits durch eine
     * andere Stelle verpflichtet wurde).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BehoerdeAuskunft[]
     */
    public $weitereVerpflichtendeStelle;
    /**
     * Constructor method for TeilnehmerAuskunftDaten
     * @uses TeilnehmerAuskunftDaten::setTeilnehmerdaten()
     * @uses TeilnehmerAuskunftDaten::setTeilnahmeberechtigung()
     * @uses TeilnehmerAuskunftDaten::setTraegeranmeldungErstverfahren()
     * @uses TeilnehmerAuskunftDaten::setTraegeranmeldungWiederholerVerfahren()
     * @uses TeilnehmerAuskunftDaten::setTeilnahme()
     * @uses TeilnehmerAuskunftDaten::setAbschluss()
     * @uses TeilnehmerAuskunftDaten::setVerpflichtungAustellendeStelle()
     * @uses TeilnehmerAuskunftDaten::setWeitereVerpflichtendeStelle()
     * @param \StructType\PersonendatenAuskunft $teilnehmerdaten
     * @param \StructType\TeilnahmeberechtigungAuskunft[] $teilnahmeberechtigung
     * @param \StructType\TraegeranmeldungErstverfahrenAuskunft $traegeranmeldungErstverfahren
     * @param \StructType\TraegeranmeldungWiederholerverfahrenAuskunft $traegeranmeldungWiederholerVerfahren
     * @param \StructType\TeilnahmeAuskunft $teilnahme
     * @param \StructType\AbschlussAuskunft $abschluss
     * @param \StructType\BehoerdeAuskunft $verpflichtungAustellendeStelle
     * @param \StructType\BehoerdeAuskunft[] $weitereVerpflichtendeStelle
     */
    public function __construct(\StructType\PersonendatenAuskunft $teilnehmerdaten = null, array $teilnahmeberechtigung = array(), \StructType\TraegeranmeldungErstverfahrenAuskunft $traegeranmeldungErstverfahren = null, \StructType\TraegeranmeldungWiederholerverfahrenAuskunft $traegeranmeldungWiederholerVerfahren = null, \StructType\TeilnahmeAuskunft $teilnahme = null, \StructType\AbschlussAuskunft $abschluss = null, \StructType\BehoerdeAuskunft $verpflichtungAustellendeStelle = null, array $weitereVerpflichtendeStelle = array())
    {
        $this
            ->setTeilnehmerdaten($teilnehmerdaten)
            ->setTeilnahmeberechtigung($teilnahmeberechtigung)
            ->setTraegeranmeldungErstverfahren($traegeranmeldungErstverfahren)
            ->setTraegeranmeldungWiederholerVerfahren($traegeranmeldungWiederholerVerfahren)
            ->setTeilnahme($teilnahme)
            ->setAbschluss($abschluss)
            ->setVerpflichtungAustellendeStelle($verpflichtungAustellendeStelle)
            ->setWeitereVerpflichtendeStelle($weitereVerpflichtendeStelle);
    }
    /**
     * Get teilnehmerdaten value
     * @return \StructType\PersonendatenAuskunft|null
     */
    public function getTeilnehmerdaten()
    {
        return $this->teilnehmerdaten;
    }
    /**
     * Set teilnehmerdaten value
     * @param \StructType\PersonendatenAuskunft $teilnehmerdaten
     * @return \StructType\TeilnehmerAuskunftDaten
     */
    public function setTeilnehmerdaten(\StructType\PersonendatenAuskunft $teilnehmerdaten = null)
    {
        $this->teilnehmerdaten = $teilnehmerdaten;
        return $this;
    }
    /**
     * Get teilnahmeberechtigung value
     * @return \StructType\TeilnahmeberechtigungAuskunft[]|null
     */
    public function getTeilnahmeberechtigung()
    {
        return $this->teilnahmeberechtigung;
    }
    /**
     * This method is responsible for validating the values passed to the setTeilnahmeberechtigung method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTeilnahmeberechtigung method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTeilnahmeberechtigungForArrayConstraintsFromSetTeilnahmeberechtigung(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $teilnehmerAuskunftDatenTeilnahmeberechtigungItem) {
            // validation for constraint: itemType
            if (!$teilnehmerAuskunftDatenTeilnahmeberechtigungItem instanceof \StructType\TeilnahmeberechtigungAuskunft) {
                $invalidValues[] = is_object($teilnehmerAuskunftDatenTeilnahmeberechtigungItem) ? get_class($teilnehmerAuskunftDatenTeilnahmeberechtigungItem) : sprintf('%s(%s)', gettype($teilnehmerAuskunftDatenTeilnahmeberechtigungItem), var_export($teilnehmerAuskunftDatenTeilnahmeberechtigungItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The teilnahmeberechtigung property can only contain items of type \StructType\TeilnahmeberechtigungAuskunft, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set teilnahmeberechtigung value
     * @throws \InvalidArgumentException
     * @param \StructType\TeilnahmeberechtigungAuskunft[] $teilnahmeberechtigung
     * @return \StructType\TeilnehmerAuskunftDaten
     */
    public function setTeilnahmeberechtigung(array $teilnahmeberechtigung = array())
    {
        // validation for constraint: array
        if ('' !== ($teilnahmeberechtigungArrayErrorMessage = self::validateTeilnahmeberechtigungForArrayConstraintsFromSetTeilnahmeberechtigung($teilnahmeberechtigung))) {
            throw new \InvalidArgumentException($teilnahmeberechtigungArrayErrorMessage, __LINE__);
        }
        $this->teilnahmeberechtigung = $teilnahmeberechtigung;
        return $this;
    }
    /**
     * Add item to teilnahmeberechtigung value
     * @throws \InvalidArgumentException
     * @param \StructType\TeilnahmeberechtigungAuskunft $item
     * @return \StructType\TeilnehmerAuskunftDaten
     */
    public function addToTeilnahmeberechtigung(\StructType\TeilnahmeberechtigungAuskunft $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TeilnahmeberechtigungAuskunft) {
            throw new \InvalidArgumentException(sprintf('The teilnahmeberechtigung property can only contain items of type \StructType\TeilnahmeberechtigungAuskunft, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->teilnahmeberechtigung[] = $item;
        return $this;
    }
    /**
     * Get traegeranmeldungErstverfahren value
     * @return \StructType\TraegeranmeldungErstverfahrenAuskunft|null
     */
    public function getTraegeranmeldungErstverfahren()
    {
        return $this->traegeranmeldungErstverfahren;
    }
    /**
     * Set traegeranmeldungErstverfahren value
     * @param \StructType\TraegeranmeldungErstverfahrenAuskunft $traegeranmeldungErstverfahren
     * @return \StructType\TeilnehmerAuskunftDaten
     */
    public function setTraegeranmeldungErstverfahren(\StructType\TraegeranmeldungErstverfahrenAuskunft $traegeranmeldungErstverfahren = null)
    {
        $this->traegeranmeldungErstverfahren = $traegeranmeldungErstverfahren;
        return $this;
    }
    /**
     * Get traegeranmeldungWiederholerVerfahren value
     * @return \StructType\TraegeranmeldungWiederholerverfahrenAuskunft|null
     */
    public function getTraegeranmeldungWiederholerVerfahren()
    {
        return $this->traegeranmeldungWiederholerVerfahren;
    }
    /**
     * Set traegeranmeldungWiederholerVerfahren value
     * @param \StructType\TraegeranmeldungWiederholerverfahrenAuskunft $traegeranmeldungWiederholerVerfahren
     * @return \StructType\TeilnehmerAuskunftDaten
     */
    public function setTraegeranmeldungWiederholerVerfahren(\StructType\TraegeranmeldungWiederholerverfahrenAuskunft $traegeranmeldungWiederholerVerfahren = null)
    {
        $this->traegeranmeldungWiederholerVerfahren = $traegeranmeldungWiederholerVerfahren;
        return $this;
    }
    /**
     * Get teilnahme value
     * @return \StructType\TeilnahmeAuskunft|null
     */
    public function getTeilnahme()
    {
        return $this->teilnahme;
    }
    /**
     * Set teilnahme value
     * @param \StructType\TeilnahmeAuskunft $teilnahme
     * @return \StructType\TeilnehmerAuskunftDaten
     */
    public function setTeilnahme(\StructType\TeilnahmeAuskunft $teilnahme = null)
    {
        $this->teilnahme = $teilnahme;
        return $this;
    }
    /**
     * Get abschluss value
     * @return \StructType\AbschlussAuskunft|null
     */
    public function getAbschluss()
    {
        return $this->abschluss;
    }
    /**
     * Set abschluss value
     * @param \StructType\AbschlussAuskunft $abschluss
     * @return \StructType\TeilnehmerAuskunftDaten
     */
    public function setAbschluss(\StructType\AbschlussAuskunft $abschluss = null)
    {
        $this->abschluss = $abschluss;
        return $this;
    }
    /**
     * Get verpflichtungAustellendeStelle value
     * @return \StructType\BehoerdeAuskunft|null
     */
    public function getVerpflichtungAustellendeStelle()
    {
        return $this->verpflichtungAustellendeStelle;
    }
    /**
     * Set verpflichtungAustellendeStelle value
     * @param \StructType\BehoerdeAuskunft $verpflichtungAustellendeStelle
     * @return \StructType\TeilnehmerAuskunftDaten
     */
    public function setVerpflichtungAustellendeStelle(\StructType\BehoerdeAuskunft $verpflichtungAustellendeStelle = null)
    {
        $this->verpflichtungAustellendeStelle = $verpflichtungAustellendeStelle;
        return $this;
    }
    /**
     * Get weitereVerpflichtendeStelle value
     * @return \StructType\BehoerdeAuskunft[]|null
     */
    public function getWeitereVerpflichtendeStelle()
    {
        return $this->weitereVerpflichtendeStelle;
    }
    /**
     * This method is responsible for validating the values passed to the setWeitereVerpflichtendeStelle method
     * This method is willingly generated in order to preserve the one-line inline validation within the setWeitereVerpflichtendeStelle method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateWeitereVerpflichtendeStelleForArrayConstraintsFromSetWeitereVerpflichtendeStelle(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $teilnehmerAuskunftDatenWeitereVerpflichtendeStelleItem) {
            // validation for constraint: itemType
            if (!$teilnehmerAuskunftDatenWeitereVerpflichtendeStelleItem instanceof \StructType\BehoerdeAuskunft) {
                $invalidValues[] = is_object($teilnehmerAuskunftDatenWeitereVerpflichtendeStelleItem) ? get_class($teilnehmerAuskunftDatenWeitereVerpflichtendeStelleItem) : sprintf('%s(%s)', gettype($teilnehmerAuskunftDatenWeitereVerpflichtendeStelleItem), var_export($teilnehmerAuskunftDatenWeitereVerpflichtendeStelleItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The weitereVerpflichtendeStelle property can only contain items of type \StructType\BehoerdeAuskunft, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set weitereVerpflichtendeStelle value
     * @throws \InvalidArgumentException
     * @param \StructType\BehoerdeAuskunft[] $weitereVerpflichtendeStelle
     * @return \StructType\TeilnehmerAuskunftDaten
     */
    public function setWeitereVerpflichtendeStelle(array $weitereVerpflichtendeStelle = array())
    {
        // validation for constraint: array
        if ('' !== ($weitereVerpflichtendeStelleArrayErrorMessage = self::validateWeitereVerpflichtendeStelleForArrayConstraintsFromSetWeitereVerpflichtendeStelle($weitereVerpflichtendeStelle))) {
            throw new \InvalidArgumentException($weitereVerpflichtendeStelleArrayErrorMessage, __LINE__);
        }
        $this->weitereVerpflichtendeStelle = $weitereVerpflichtendeStelle;
        return $this;
    }
    /**
     * Add item to weitereVerpflichtendeStelle value
     * @throws \InvalidArgumentException
     * @param \StructType\BehoerdeAuskunft $item
     * @return \StructType\TeilnehmerAuskunftDaten
     */
    public function addToWeitereVerpflichtendeStelle(\StructType\BehoerdeAuskunft $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BehoerdeAuskunft) {
            throw new \InvalidArgumentException(sprintf('The weitereVerpflichtendeStelle property can only contain items of type \StructType\BehoerdeAuskunft, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->weitereVerpflichtendeStelle[] = $item;
        return $this;
    }
}
