<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TeilnahmeberechtigungAuskunft StructType
 * @subpackage Structs
 */
class TeilnahmeberechtigungAuskunft extends AbstractStructBase
{
    /**
     * The bamfAktenzeichen
     * Meta information extracted from the WSDL
     * - documentation: Eindeutige BAMF-Kennziffer für diese Teilnahmeberechtigung. Bei vom BAMF ausgestellten Berechtigungen bzw. bei am Online-Verfahren teilnehmenden Behörden ist diese auch auf dem berechtigungsschein vermerkt.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $bamfAktenzeichen;
    /**
     * The art
     * Meta information extracted from the WSDL
     * - documentation: Codeliste 806. Entstammt dem Berechtigungsschein.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $art;
    /**
     * The bestaetigungVom
     * Meta information extracted from the WSDL
     * - documentation: Der Beginn des Gültigkeitszeitraums der Berechtigung. Diese Angabe entstammt dem Berechtigungsschein.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $bestaetigungVom;
    /**
     * The giltUnbefristet
     * Meta information extracted from the WSDL
     * - documentation: Wahr, wenn diese Berechtigung zeitlich unbefristet zur Teilnahme gültig ist. Dies ist der Fall, wenn die Berechtigung grundsätzlich unbefristet gültig ist oder bereits eine Anmeldung auf diese (oder eine frühere) Berechtigung
     * erfolgt ist und nicht aus anderen Gründen beendet wurde (s. Stornierungsdatum).
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $giltUnbefristet;
    /**
     * The ausstellendeBehoerde
     * Meta information extracted from the WSDL
     * - documentation: Bezeichnung der ausstellenden Behörde. Diese Angabe entstammt dem Berechtigungsschein.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\BehoerdeAuskunft
     */
    public $ausstellendeBehoerde;
    /**
     * The berechtigungBis
     * Meta information extracted from the WSDL
     * - documentation: Das Ende des Gültigkeitszeitraums der Berechtigung für die Anmeldung beim Träger. Keine Angabe, wenn die Berechtigung ab Erteilung unbefristet gültig ist. Diese Angabe entstammt dem Berechtigungsschein. Ab der Anmeldung bei einem
     * Träger ist jede Berechtigung zunächst unbefristet für den Kursbesuch gültig (s. Feld GiltUnbefristet).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $berechtigungBis;
    /**
     * The stornierungsdatum
     * Meta information extracted from the WSDL
     * - documentation: Das Datum der Stornierung, falls die Berechtigung explizit beendet wurde (z.B. wegen einer jüngeren Verpflichtung). Dieses Feld ist nicht gesetzt, wenn die Berechtigung ungenutzt ausgelaufen ist.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $stornierungsdatum;
    /**
     * The berechtigungNurOKurs
     * Meta information extracted from the WSDL
     * - documentation: Wahr, falls die Berechtigung nur für die Teilnahme am Orientierungskurs gilt. Sprachkursabschnitte können auf eine solche Berechtigung nicht abgerechnet werden. Diese Angabe entstammt dem Berechtigungsschein.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $berechtigungNurOKurs;
    /**
     * The verpflichtungNurSprachkurs
     * Meta information extracted from the WSDL
     * - documentation: Wahr, falls die Verpflichtung sich nur auf die Teilnahme am Sprachkurs bezieht. Die Berechtigung zur Teilnahme am Orientierungskurs bleibt bestehen. Diese Angabe entstammt dem Berechtigungsschein.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $verpflichtungNurSprachkurs;
    /**
     * The automatischeKostenbefreiung
     * Meta information extracted from the WSDL
     * - documentation: Wahr, falls die Berechtigung explizit (z.B. § 104 Abs. 5 AufenthG) oder implizit (z.B. TGS-Verpflichtung) eine kostenlose Kursteilnahme ermöglicht. Diese Angabe entstammt dem Berechtigungsschein. Nicht gesetzt, wenn eine
     * Kostenbefreiung explizit durch den Teilnehmer beim BAMF beantragt werden muss.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $automatischeKostenbefreiung;
    /**
     * The externesAktenzeichen
     * Meta information extracted from the WSDL
     * - documentation: Das von der austellenden Behörde vergebene und auf dem Berechtigungsschein aufgedruckte Aktenzeichen, falls die Berechtigung im Papierverfahren ohne BAMF-Kennziffer von ABH, TGS oder BVA ausgestellt wurde. In Ausnahmefällen kann
     * auch bei im Online-Verfahren ausgestellten Berechtigungen ein externes Aktenzeichen vorliegen, aber im Regelfall gibt es dann nur das BAMF-Aktenzeichen. Diese Angabe entstammt dem Berechtigungsschein.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $externesAktenzeichen;
    /**
     * Constructor method for TeilnahmeberechtigungAuskunft
     * @uses TeilnahmeberechtigungAuskunft::setBamfAktenzeichen()
     * @uses TeilnahmeberechtigungAuskunft::setArt()
     * @uses TeilnahmeberechtigungAuskunft::setBestaetigungVom()
     * @uses TeilnahmeberechtigungAuskunft::setGiltUnbefristet()
     * @uses TeilnahmeberechtigungAuskunft::setAusstellendeBehoerde()
     * @uses TeilnahmeberechtigungAuskunft::setBerechtigungBis()
     * @uses TeilnahmeberechtigungAuskunft::setStornierungsdatum()
     * @uses TeilnahmeberechtigungAuskunft::setBerechtigungNurOKurs()
     * @uses TeilnahmeberechtigungAuskunft::setVerpflichtungNurSprachkurs()
     * @uses TeilnahmeberechtigungAuskunft::setAutomatischeKostenbefreiung()
     * @uses TeilnahmeberechtigungAuskunft::setExternesAktenzeichen()
     * @param string $bamfAktenzeichen
     * @param string $art
     * @param string $bestaetigungVom
     * @param bool $giltUnbefristet
     * @param \StructType\BehoerdeAuskunft $ausstellendeBehoerde
     * @param string $berechtigungBis
     * @param string $stornierungsdatum
     * @param bool $berechtigungNurOKurs
     * @param bool $verpflichtungNurSprachkurs
     * @param bool $automatischeKostenbefreiung
     * @param string $externesAktenzeichen
     */
    public function __construct($bamfAktenzeichen = null, $art = null, $bestaetigungVom = null, $giltUnbefristet = null, \StructType\BehoerdeAuskunft $ausstellendeBehoerde = null, $berechtigungBis = null, $stornierungsdatum = null, $berechtigungNurOKurs = null, $verpflichtungNurSprachkurs = null, $automatischeKostenbefreiung = null, $externesAktenzeichen = null)
    {
        $this
            ->setBamfAktenzeichen($bamfAktenzeichen)
            ->setArt($art)
            ->setBestaetigungVom($bestaetigungVom)
            ->setGiltUnbefristet($giltUnbefristet)
            ->setAusstellendeBehoerde($ausstellendeBehoerde)
            ->setBerechtigungBis($berechtigungBis)
            ->setStornierungsdatum($stornierungsdatum)
            ->setBerechtigungNurOKurs($berechtigungNurOKurs)
            ->setVerpflichtungNurSprachkurs($verpflichtungNurSprachkurs)
            ->setAutomatischeKostenbefreiung($automatischeKostenbefreiung)
            ->setExternesAktenzeichen($externesAktenzeichen);
    }
    /**
     * Get bamfAktenzeichen value
     * @return string
     */
    public function getBamfAktenzeichen()
    {
        return $this->bamfAktenzeichen;
    }
    /**
     * Set bamfAktenzeichen value
     * @param string $bamfAktenzeichen
     * @return \StructType\TeilnahmeberechtigungAuskunft
     */
    public function setBamfAktenzeichen($bamfAktenzeichen = null)
    {
        // validation for constraint: string
        if (!is_null($bamfAktenzeichen) && !is_string($bamfAktenzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bamfAktenzeichen, true), gettype($bamfAktenzeichen)), __LINE__);
        }
        $this->bamfAktenzeichen = $bamfAktenzeichen;
        return $this;
    }
    /**
     * Get art value
     * @return string
     */
    public function getArt()
    {
        return $this->art;
    }
    /**
     * Set art value
     * @param string $art
     * @return \StructType\TeilnahmeberechtigungAuskunft
     */
    public function setArt($art = null)
    {
        // validation for constraint: string
        if (!is_null($art) && !is_string($art)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($art, true), gettype($art)), __LINE__);
        }
        $this->art = $art;
        return $this;
    }
    /**
     * Get bestaetigungVom value
     * @return string
     */
    public function getBestaetigungVom()
    {
        return $this->bestaetigungVom;
    }
    /**
     * Set bestaetigungVom value
     * @param string $bestaetigungVom
     * @return \StructType\TeilnahmeberechtigungAuskunft
     */
    public function setBestaetigungVom($bestaetigungVom = null)
    {
        // validation for constraint: string
        if (!is_null($bestaetigungVom) && !is_string($bestaetigungVom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bestaetigungVom, true), gettype($bestaetigungVom)), __LINE__);
        }
        $this->bestaetigungVom = $bestaetigungVom;
        return $this;
    }
    /**
     * Get giltUnbefristet value
     * @return bool
     */
    public function getGiltUnbefristet()
    {
        return $this->giltUnbefristet;
    }
    /**
     * Set giltUnbefristet value
     * @param bool $giltUnbefristet
     * @return \StructType\TeilnahmeberechtigungAuskunft
     */
    public function setGiltUnbefristet($giltUnbefristet = null)
    {
        // validation for constraint: boolean
        if (!is_null($giltUnbefristet) && !is_bool($giltUnbefristet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($giltUnbefristet, true), gettype($giltUnbefristet)), __LINE__);
        }
        $this->giltUnbefristet = $giltUnbefristet;
        return $this;
    }
    /**
     * Get ausstellendeBehoerde value
     * @return \StructType\BehoerdeAuskunft
     */
    public function getAusstellendeBehoerde()
    {
        return $this->ausstellendeBehoerde;
    }
    /**
     * Set ausstellendeBehoerde value
     * @param \StructType\BehoerdeAuskunft $ausstellendeBehoerde
     * @return \StructType\TeilnahmeberechtigungAuskunft
     */
    public function setAusstellendeBehoerde(\StructType\BehoerdeAuskunft $ausstellendeBehoerde = null)
    {
        $this->ausstellendeBehoerde = $ausstellendeBehoerde;
        return $this;
    }
    /**
     * Get berechtigungBis value
     * @return string|null
     */
    public function getBerechtigungBis()
    {
        return $this->berechtigungBis;
    }
    /**
     * Set berechtigungBis value
     * @param string $berechtigungBis
     * @return \StructType\TeilnahmeberechtigungAuskunft
     */
    public function setBerechtigungBis($berechtigungBis = null)
    {
        // validation for constraint: string
        if (!is_null($berechtigungBis) && !is_string($berechtigungBis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($berechtigungBis, true), gettype($berechtigungBis)), __LINE__);
        }
        $this->berechtigungBis = $berechtigungBis;
        return $this;
    }
    /**
     * Get stornierungsdatum value
     * @return string|null
     */
    public function getStornierungsdatum()
    {
        return $this->stornierungsdatum;
    }
    /**
     * Set stornierungsdatum value
     * @param string $stornierungsdatum
     * @return \StructType\TeilnahmeberechtigungAuskunft
     */
    public function setStornierungsdatum($stornierungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($stornierungsdatum) && !is_string($stornierungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stornierungsdatum, true), gettype($stornierungsdatum)), __LINE__);
        }
        $this->stornierungsdatum = $stornierungsdatum;
        return $this;
    }
    /**
     * Get berechtigungNurOKurs value
     * @return bool|null
     */
    public function getBerechtigungNurOKurs()
    {
        return $this->berechtigungNurOKurs;
    }
    /**
     * Set berechtigungNurOKurs value
     * @param bool $berechtigungNurOKurs
     * @return \StructType\TeilnahmeberechtigungAuskunft
     */
    public function setBerechtigungNurOKurs($berechtigungNurOKurs = null)
    {
        // validation for constraint: boolean
        if (!is_null($berechtigungNurOKurs) && !is_bool($berechtigungNurOKurs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($berechtigungNurOKurs, true), gettype($berechtigungNurOKurs)), __LINE__);
        }
        $this->berechtigungNurOKurs = $berechtigungNurOKurs;
        return $this;
    }
    /**
     * Get verpflichtungNurSprachkurs value
     * @return bool|null
     */
    public function getVerpflichtungNurSprachkurs()
    {
        return $this->verpflichtungNurSprachkurs;
    }
    /**
     * Set verpflichtungNurSprachkurs value
     * @param bool $verpflichtungNurSprachkurs
     * @return \StructType\TeilnahmeberechtigungAuskunft
     */
    public function setVerpflichtungNurSprachkurs($verpflichtungNurSprachkurs = null)
    {
        // validation for constraint: boolean
        if (!is_null($verpflichtungNurSprachkurs) && !is_bool($verpflichtungNurSprachkurs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($verpflichtungNurSprachkurs, true), gettype($verpflichtungNurSprachkurs)), __LINE__);
        }
        $this->verpflichtungNurSprachkurs = $verpflichtungNurSprachkurs;
        return $this;
    }
    /**
     * Get automatischeKostenbefreiung value
     * @return bool|null
     */
    public function getAutomatischeKostenbefreiung()
    {
        return $this->automatischeKostenbefreiung;
    }
    /**
     * Set automatischeKostenbefreiung value
     * @param bool $automatischeKostenbefreiung
     * @return \StructType\TeilnahmeberechtigungAuskunft
     */
    public function setAutomatischeKostenbefreiung($automatischeKostenbefreiung = null)
    {
        // validation for constraint: boolean
        if (!is_null($automatischeKostenbefreiung) && !is_bool($automatischeKostenbefreiung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($automatischeKostenbefreiung, true), gettype($automatischeKostenbefreiung)), __LINE__);
        }
        $this->automatischeKostenbefreiung = $automatischeKostenbefreiung;
        return $this;
    }
    /**
     * Get externesAktenzeichen value
     * @return string|null
     */
    public function getExternesAktenzeichen()
    {
        return $this->externesAktenzeichen;
    }
    /**
     * Set externesAktenzeichen value
     * @param string $externesAktenzeichen
     * @return \StructType\TeilnahmeberechtigungAuskunft
     */
    public function setExternesAktenzeichen($externesAktenzeichen = null)
    {
        // validation for constraint: string
        if (!is_null($externesAktenzeichen) && !is_string($externesAktenzeichen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externesAktenzeichen, true), gettype($externesAktenzeichen)), __LINE__);
        }
        $this->externesAktenzeichen = $externesAktenzeichen;
        return $this;
    }
}
