<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TeilnahmeAuskunft StructType
 * @subpackage Structs
 */
class TeilnahmeAuskunft extends AbstractStructBase
{
    /**
     * The kursbesuchHinweis
     * Meta information extracted from the WSDL
     * - documentation: Hinweis, dass die Daten den Kenntnisstand des Bundesamtes widerspiegeln, der aber in der Regel bei aktiven Teilnehmern nicht vollständig ist.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kursbesuchHinweis;
    /**
     * The kontingentInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\KontingentAuskunft
     */
    public $kontingentInfo;
    /**
     * The kursbesuch
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KursbesuchAuskunft[]
     */
    public $kursbesuch;
    /**
     * Constructor method for TeilnahmeAuskunft
     * @uses TeilnahmeAuskunft::setKursbesuchHinweis()
     * @uses TeilnahmeAuskunft::setKontingentInfo()
     * @uses TeilnahmeAuskunft::setKursbesuch()
     * @param string $kursbesuchHinweis
     * @param \StructType\KontingentAuskunft $kontingentInfo
     * @param \StructType\KursbesuchAuskunft[] $kursbesuch
     */
    public function __construct($kursbesuchHinweis = null, \StructType\KontingentAuskunft $kontingentInfo = null, array $kursbesuch = array())
    {
        $this
            ->setKursbesuchHinweis($kursbesuchHinweis)
            ->setKontingentInfo($kontingentInfo)
            ->setKursbesuch($kursbesuch);
    }
    /**
     * Get kursbesuchHinweis value
     * @return string
     */
    public function getKursbesuchHinweis()
    {
        return $this->kursbesuchHinweis;
    }
    /**
     * Set kursbesuchHinweis value
     * @param string $kursbesuchHinweis
     * @return \StructType\TeilnahmeAuskunft
     */
    public function setKursbesuchHinweis($kursbesuchHinweis = null)
    {
        // validation for constraint: string
        if (!is_null($kursbesuchHinweis) && !is_string($kursbesuchHinweis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kursbesuchHinweis, true), gettype($kursbesuchHinweis)), __LINE__);
        }
        $this->kursbesuchHinweis = $kursbesuchHinweis;
        return $this;
    }
    /**
     * Get kontingentInfo value
     * @return \StructType\KontingentAuskunft
     */
    public function getKontingentInfo()
    {
        return $this->kontingentInfo;
    }
    /**
     * Set kontingentInfo value
     * @param \StructType\KontingentAuskunft $kontingentInfo
     * @return \StructType\TeilnahmeAuskunft
     */
    public function setKontingentInfo(\StructType\KontingentAuskunft $kontingentInfo = null)
    {
        $this->kontingentInfo = $kontingentInfo;
        return $this;
    }
    /**
     * Get kursbesuch value
     * @return \StructType\KursbesuchAuskunft[]|null
     */
    public function getKursbesuch()
    {
        return $this->kursbesuch;
    }
    /**
     * This method is responsible for validating the values passed to the setKursbesuch method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKursbesuch method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKursbesuchForArrayConstraintsFromSetKursbesuch(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $teilnahmeAuskunftKursbesuchItem) {
            // validation for constraint: itemType
            if (!$teilnahmeAuskunftKursbesuchItem instanceof \StructType\KursbesuchAuskunft) {
                $invalidValues[] = is_object($teilnahmeAuskunftKursbesuchItem) ? get_class($teilnahmeAuskunftKursbesuchItem) : sprintf('%s(%s)', gettype($teilnahmeAuskunftKursbesuchItem), var_export($teilnahmeAuskunftKursbesuchItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kursbesuch property can only contain items of type \StructType\KursbesuchAuskunft, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kursbesuch value
     * @throws \InvalidArgumentException
     * @param \StructType\KursbesuchAuskunft[] $kursbesuch
     * @return \StructType\TeilnahmeAuskunft
     */
    public function setKursbesuch(array $kursbesuch = array())
    {
        // validation for constraint: array
        if ('' !== ($kursbesuchArrayErrorMessage = self::validateKursbesuchForArrayConstraintsFromSetKursbesuch($kursbesuch))) {
            throw new \InvalidArgumentException($kursbesuchArrayErrorMessage, __LINE__);
        }
        $this->kursbesuch = $kursbesuch;
        return $this;
    }
    /**
     * Add item to kursbesuch value
     * @throws \InvalidArgumentException
     * @param \StructType\KursbesuchAuskunft $item
     * @return \StructType\TeilnahmeAuskunft
     */
    public function addToKursbesuch(\StructType\KursbesuchAuskunft $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KursbesuchAuskunft) {
            throw new \InvalidArgumentException(sprintf('The kursbesuch property can only contain items of type \StructType\KursbesuchAuskunft, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kursbesuch[] = $item;
        return $this;
    }
}
