<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SprachtestergebnisAuskunft StructType
 * @subpackage Structs
 */
class SprachtestergebnisAuskunft extends AbstractStructBase
{
    /**
     * The traeger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\KurstraegerAuskunft
     */
    public $traeger;
    /**
     * The testdatum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $testdatum;
    /**
     * The art
     * Meta information extracted from the WSDL
     * - documentation: Codeliste 807.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $art;
    /**
     * The gesamtergebnis
     * Meta information extracted from the WSDL
     * - documentation: Codeliste 808. Liegt ggf. noch nicht vor.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $gesamtergebnis;
    /**
     * The ausweisnummer
     * Meta information extracted from the WSDL
     * - documentation: Liegt ggf. noch nicht vor.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ausweisnummer;
    /**
     * The detailsDTZ
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SprachtestdetailsDTZ
     */
    public $detailsDTZ;
    /**
     * Constructor method for SprachtestergebnisAuskunft
     * @uses SprachtestergebnisAuskunft::setTraeger()
     * @uses SprachtestergebnisAuskunft::setTestdatum()
     * @uses SprachtestergebnisAuskunft::setArt()
     * @uses SprachtestergebnisAuskunft::setGesamtergebnis()
     * @uses SprachtestergebnisAuskunft::setAusweisnummer()
     * @uses SprachtestergebnisAuskunft::setDetailsDTZ()
     * @param \StructType\KurstraegerAuskunft $traeger
     * @param string $testdatum
     * @param string $art
     * @param string $gesamtergebnis
     * @param string $ausweisnummer
     * @param \StructType\SprachtestdetailsDTZ $detailsDTZ
     */
    public function __construct(\StructType\KurstraegerAuskunft $traeger = null, $testdatum = null, $art = null, $gesamtergebnis = null, $ausweisnummer = null, \StructType\SprachtestdetailsDTZ $detailsDTZ = null)
    {
        $this
            ->setTraeger($traeger)
            ->setTestdatum($testdatum)
            ->setArt($art)
            ->setGesamtergebnis($gesamtergebnis)
            ->setAusweisnummer($ausweisnummer)
            ->setDetailsDTZ($detailsDTZ);
    }
    /**
     * Get traeger value
     * @return \StructType\KurstraegerAuskunft
     */
    public function getTraeger()
    {
        return $this->traeger;
    }
    /**
     * Set traeger value
     * @param \StructType\KurstraegerAuskunft $traeger
     * @return \StructType\SprachtestergebnisAuskunft
     */
    public function setTraeger(\StructType\KurstraegerAuskunft $traeger = null)
    {
        $this->traeger = $traeger;
        return $this;
    }
    /**
     * Get testdatum value
     * @return string
     */
    public function getTestdatum()
    {
        return $this->testdatum;
    }
    /**
     * Set testdatum value
     * @param string $testdatum
     * @return \StructType\SprachtestergebnisAuskunft
     */
    public function setTestdatum($testdatum = null)
    {
        // validation for constraint: string
        if (!is_null($testdatum) && !is_string($testdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($testdatum, true), gettype($testdatum)), __LINE__);
        }
        $this->testdatum = $testdatum;
        return $this;
    }
    /**
     * Get art value
     * @return string
     */
    public function getArt()
    {
        return $this->art;
    }
    /**
     * Set art value
     * @param string $art
     * @return \StructType\SprachtestergebnisAuskunft
     */
    public function setArt($art = null)
    {
        // validation for constraint: string
        if (!is_null($art) && !is_string($art)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($art, true), gettype($art)), __LINE__);
        }
        $this->art = $art;
        return $this;
    }
    /**
     * Get gesamtergebnis value
     * @return string|null
     */
    public function getGesamtergebnis()
    {
        return $this->gesamtergebnis;
    }
    /**
     * Set gesamtergebnis value
     * @param string $gesamtergebnis
     * @return \StructType\SprachtestergebnisAuskunft
     */
    public function setGesamtergebnis($gesamtergebnis = null)
    {
        // validation for constraint: string
        if (!is_null($gesamtergebnis) && !is_string($gesamtergebnis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gesamtergebnis, true), gettype($gesamtergebnis)), __LINE__);
        }
        $this->gesamtergebnis = $gesamtergebnis;
        return $this;
    }
    /**
     * Get ausweisnummer value
     * @return string|null
     */
    public function getAusweisnummer()
    {
        return $this->ausweisnummer;
    }
    /**
     * Set ausweisnummer value
     * @param string $ausweisnummer
     * @return \StructType\SprachtestergebnisAuskunft
     */
    public function setAusweisnummer($ausweisnummer = null)
    {
        // validation for constraint: string
        if (!is_null($ausweisnummer) && !is_string($ausweisnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ausweisnummer, true), gettype($ausweisnummer)), __LINE__);
        }
        $this->ausweisnummer = $ausweisnummer;
        return $this;
    }
    /**
     * Get detailsDTZ value
     * @return \StructType\SprachtestdetailsDTZ|null
     */
    public function getDetailsDTZ()
    {
        return $this->detailsDTZ;
    }
    /**
     * Set detailsDTZ value
     * @param \StructType\SprachtestdetailsDTZ $detailsDTZ
     * @return \StructType\SprachtestergebnisAuskunft
     */
    public function setDetailsDTZ(\StructType\SprachtestdetailsDTZ $detailsDTZ = null)
    {
        $this->detailsDTZ = $detailsDTZ;
        return $this;
    }
}
