<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonendatenAuskunft StructType
 * @subpackage Structs
 */
class PersonendatenAuskunft extends AbstractStructBase
{
    /**
     * The familienname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $familienname;
    /**
     * The geburtsdatum
     * Meta information extracted from the WSDL
     * - documentation: Format ist TT.MM.JJJJ. Tag bzw. Tag und Monat können unbekannt sein, dargestellt als 00.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $geburtsdatum;
    /**
     * The geschlecht
     * Meta information extracted from the WSDL
     * - documentation: Codeliste 005.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $geschlecht;
    /**
     * The vorname
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $vorname;
    /**
     * The wohnadresse
     * Meta information extracted from the WSDL
     * - documentation: Die zum Zeitpunkt der Auskunft aktuell hinterlegte Wohnanschrift.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AdresseAuskunft
     */
    public $wohnadresse;
    /**
     * The postadresse
     * Meta information extracted from the WSDL
     * - documentation: Die zum Zeitpunkt der Auskunft aktuell hinterlegte Postanschrift, falls diese von der Wohnanschrift abweicht.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AdresseAuskunft
     */
    public $postadresse;
    /**
     * The geburtsort
     * Meta information extracted from the WSDL
     * - documentation: Der Geburtsort ohne Geburtsland.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $geburtsort;
    /**
     * The staatsangehoerigkeit
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Staat[]
     */
    public $staatsangehoerigkeit;
    /**
     * The fruehererName
     * Meta information extracted from the WSDL
     * - documentation: Liste der zum Zeitpunkt der Auskunft bekannten früheren Namen.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FruehererName[]
     */
    public $fruehererName;
    /**
     * The zustaendigeRST
     * Meta information extracted from the WSDL
     * - documentation: Codeliste xxx. Die zum Zeitpunkt der Auskunft zuständige Regionalstelle des Bundesamtes.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $zustaendigeRST;
    /**
     * Constructor method for PersonendatenAuskunft
     * @uses PersonendatenAuskunft::setFamilienname()
     * @uses PersonendatenAuskunft::setGeburtsdatum()
     * @uses PersonendatenAuskunft::setGeschlecht()
     * @uses PersonendatenAuskunft::setVorname()
     * @uses PersonendatenAuskunft::setWohnadresse()
     * @uses PersonendatenAuskunft::setPostadresse()
     * @uses PersonendatenAuskunft::setGeburtsort()
     * @uses PersonendatenAuskunft::setStaatsangehoerigkeit()
     * @uses PersonendatenAuskunft::setFruehererName()
     * @uses PersonendatenAuskunft::setZustaendigeRST()
     * @param string $familienname
     * @param string $geburtsdatum
     * @param string $geschlecht
     * @param string $vorname
     * @param \StructType\AdresseAuskunft $wohnadresse
     * @param \StructType\AdresseAuskunft $postadresse
     * @param string $geburtsort
     * @param \StructType\Staat[] $staatsangehoerigkeit
     * @param \StructType\FruehererName[] $fruehererName
     * @param string $zustaendigeRST
     */
    public function __construct($familienname = null, $geburtsdatum = null, $geschlecht = null, $vorname = null, \StructType\AdresseAuskunft $wohnadresse = null, \StructType\AdresseAuskunft $postadresse = null, $geburtsort = null, array $staatsangehoerigkeit = array(), array $fruehererName = array(), $zustaendigeRST = null)
    {
        $this
            ->setFamilienname($familienname)
            ->setGeburtsdatum($geburtsdatum)
            ->setGeschlecht($geschlecht)
            ->setVorname($vorname)
            ->setWohnadresse($wohnadresse)
            ->setPostadresse($postadresse)
            ->setGeburtsort($geburtsort)
            ->setStaatsangehoerigkeit($staatsangehoerigkeit)
            ->setFruehererName($fruehererName)
            ->setZustaendigeRST($zustaendigeRST);
    }
    /**
     * Get familienname value
     * @return string
     */
    public function getFamilienname()
    {
        return $this->familienname;
    }
    /**
     * Set familienname value
     * @param string $familienname
     * @return \StructType\PersonendatenAuskunft
     */
    public function setFamilienname($familienname = null)
    {
        // validation for constraint: string
        if (!is_null($familienname) && !is_string($familienname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($familienname, true), gettype($familienname)), __LINE__);
        }
        $this->familienname = $familienname;
        return $this;
    }
    /**
     * Get geburtsdatum value
     * @return string
     */
    public function getGeburtsdatum()
    {
        return $this->geburtsdatum;
    }
    /**
     * Set geburtsdatum value
     * @param string $geburtsdatum
     * @return \StructType\PersonendatenAuskunft
     */
    public function setGeburtsdatum($geburtsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($geburtsdatum) && !is_string($geburtsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geburtsdatum, true), gettype($geburtsdatum)), __LINE__);
        }
        $this->geburtsdatum = $geburtsdatum;
        return $this;
    }
    /**
     * Get geschlecht value
     * @return string
     */
    public function getGeschlecht()
    {
        return $this->geschlecht;
    }
    /**
     * Set geschlecht value
     * @param string $geschlecht
     * @return \StructType\PersonendatenAuskunft
     */
    public function setGeschlecht($geschlecht = null)
    {
        // validation for constraint: string
        if (!is_null($geschlecht) && !is_string($geschlecht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geschlecht, true), gettype($geschlecht)), __LINE__);
        }
        $this->geschlecht = $geschlecht;
        return $this;
    }
    /**
     * Get vorname value
     * @return string|null
     */
    public function getVorname()
    {
        return $this->vorname;
    }
    /**
     * Set vorname value
     * @param string $vorname
     * @return \StructType\PersonendatenAuskunft
     */
    public function setVorname($vorname = null)
    {
        // validation for constraint: string
        if (!is_null($vorname) && !is_string($vorname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vorname, true), gettype($vorname)), __LINE__);
        }
        $this->vorname = $vorname;
        return $this;
    }
    /**
     * Get wohnadresse value
     * @return \StructType\AdresseAuskunft|null
     */
    public function getWohnadresse()
    {
        return $this->wohnadresse;
    }
    /**
     * Set wohnadresse value
     * @param \StructType\AdresseAuskunft $wohnadresse
     * @return \StructType\PersonendatenAuskunft
     */
    public function setWohnadresse(\StructType\AdresseAuskunft $wohnadresse = null)
    {
        $this->wohnadresse = $wohnadresse;
        return $this;
    }
    /**
     * Get postadresse value
     * @return \StructType\AdresseAuskunft|null
     */
    public function getPostadresse()
    {
        return $this->postadresse;
    }
    /**
     * Set postadresse value
     * @param \StructType\AdresseAuskunft $postadresse
     * @return \StructType\PersonendatenAuskunft
     */
    public function setPostadresse(\StructType\AdresseAuskunft $postadresse = null)
    {
        $this->postadresse = $postadresse;
        return $this;
    }
    /**
     * Get geburtsort value
     * @return string|null
     */
    public function getGeburtsort()
    {
        return $this->geburtsort;
    }
    /**
     * Set geburtsort value
     * @param string $geburtsort
     * @return \StructType\PersonendatenAuskunft
     */
    public function setGeburtsort($geburtsort = null)
    {
        // validation for constraint: string
        if (!is_null($geburtsort) && !is_string($geburtsort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($geburtsort, true), gettype($geburtsort)), __LINE__);
        }
        $this->geburtsort = $geburtsort;
        return $this;
    }
    /**
     * Get staatsangehoerigkeit value
     * @return \StructType\Staat[]|null
     */
    public function getStaatsangehoerigkeit()
    {
        return $this->staatsangehoerigkeit;
    }
    /**
     * This method is responsible for validating the values passed to the setStaatsangehoerigkeit method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStaatsangehoerigkeit method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStaatsangehoerigkeitForArrayConstraintsFromSetStaatsangehoerigkeit(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personendatenAuskunftStaatsangehoerigkeitItem) {
            // validation for constraint: itemType
            if (!$personendatenAuskunftStaatsangehoerigkeitItem instanceof \StructType\Staat) {
                $invalidValues[] = is_object($personendatenAuskunftStaatsangehoerigkeitItem) ? get_class($personendatenAuskunftStaatsangehoerigkeitItem) : sprintf('%s(%s)', gettype($personendatenAuskunftStaatsangehoerigkeitItem), var_export($personendatenAuskunftStaatsangehoerigkeitItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The staatsangehoerigkeit property can only contain items of type \StructType\Staat, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set staatsangehoerigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Staat[] $staatsangehoerigkeit
     * @return \StructType\PersonendatenAuskunft
     */
    public function setStaatsangehoerigkeit(array $staatsangehoerigkeit = array())
    {
        // validation for constraint: array
        if ('' !== ($staatsangehoerigkeitArrayErrorMessage = self::validateStaatsangehoerigkeitForArrayConstraintsFromSetStaatsangehoerigkeit($staatsangehoerigkeit))) {
            throw new \InvalidArgumentException($staatsangehoerigkeitArrayErrorMessage, __LINE__);
        }
        $this->staatsangehoerigkeit = $staatsangehoerigkeit;
        return $this;
    }
    /**
     * Add item to staatsangehoerigkeit value
     * @throws \InvalidArgumentException
     * @param \StructType\Staat $item
     * @return \StructType\PersonendatenAuskunft
     */
    public function addToStaatsangehoerigkeit(\StructType\Staat $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Staat) {
            throw new \InvalidArgumentException(sprintf('The staatsangehoerigkeit property can only contain items of type \StructType\Staat, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->staatsangehoerigkeit[] = $item;
        return $this;
    }
    /**
     * Get fruehererName value
     * @return \StructType\FruehererName[]|null
     */
    public function getFruehererName()
    {
        return $this->fruehererName;
    }
    /**
     * This method is responsible for validating the values passed to the setFruehererName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFruehererName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFruehererNameForArrayConstraintsFromSetFruehererName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personendatenAuskunftFruehererNameItem) {
            // validation for constraint: itemType
            if (!$personendatenAuskunftFruehererNameItem instanceof \StructType\FruehererName) {
                $invalidValues[] = is_object($personendatenAuskunftFruehererNameItem) ? get_class($personendatenAuskunftFruehererNameItem) : sprintf('%s(%s)', gettype($personendatenAuskunftFruehererNameItem), var_export($personendatenAuskunftFruehererNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The fruehererName property can only contain items of type \StructType\FruehererName, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set fruehererName value
     * @throws \InvalidArgumentException
     * @param \StructType\FruehererName[] $fruehererName
     * @return \StructType\PersonendatenAuskunft
     */
    public function setFruehererName(array $fruehererName = array())
    {
        // validation for constraint: array
        if ('' !== ($fruehererNameArrayErrorMessage = self::validateFruehererNameForArrayConstraintsFromSetFruehererName($fruehererName))) {
            throw new \InvalidArgumentException($fruehererNameArrayErrorMessage, __LINE__);
        }
        $this->fruehererName = $fruehererName;
        return $this;
    }
    /**
     * Add item to fruehererName value
     * @throws \InvalidArgumentException
     * @param \StructType\FruehererName $item
     * @return \StructType\PersonendatenAuskunft
     */
    public function addToFruehererName(\StructType\FruehererName $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FruehererName) {
            throw new \InvalidArgumentException(sprintf('The fruehererName property can only contain items of type \StructType\FruehererName, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->fruehererName[] = $item;
        return $this;
    }
    /**
     * Get zustaendigeRST value
     * @return string|null
     */
    public function getZustaendigeRST()
    {
        return $this->zustaendigeRST;
    }
    /**
     * Set zustaendigeRST value
     * @param string $zustaendigeRST
     * @return \StructType\PersonendatenAuskunft
     */
    public function setZustaendigeRST($zustaendigeRST = null)
    {
        // validation for constraint: string
        if (!is_null($zustaendigeRST) && !is_string($zustaendigeRST)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zustaendigeRST, true), gettype($zustaendigeRST)), __LINE__);
        }
        $this->zustaendigeRST = $zustaendigeRST;
        return $this;
    }
}
