<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NachweisB1Auskunft StructType
 * @subpackage Structs
 */
class NachweisB1Auskunft extends AbstractStructBase
{
    /**
     * The traeger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\KurstraegerAuskunft
     */
    public $traeger;
    /**
     * The erfassungsdatum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $erfassungsdatum;
    /**
     * The ausweisnummer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ausweisnummer;
    /**
     * Constructor method for NachweisB1Auskunft
     * @uses NachweisB1Auskunft::setTraeger()
     * @uses NachweisB1Auskunft::setErfassungsdatum()
     * @uses NachweisB1Auskunft::setAusweisnummer()
     * @param \StructType\KurstraegerAuskunft $traeger
     * @param string $erfassungsdatum
     * @param string $ausweisnummer
     */
    public function __construct(\StructType\KurstraegerAuskunft $traeger = null, $erfassungsdatum = null, $ausweisnummer = null)
    {
        $this
            ->setTraeger($traeger)
            ->setErfassungsdatum($erfassungsdatum)
            ->setAusweisnummer($ausweisnummer);
    }
    /**
     * Get traeger value
     * @return \StructType\KurstraegerAuskunft
     */
    public function getTraeger()
    {
        return $this->traeger;
    }
    /**
     * Set traeger value
     * @param \StructType\KurstraegerAuskunft $traeger
     * @return \StructType\NachweisB1Auskunft
     */
    public function setTraeger(\StructType\KurstraegerAuskunft $traeger = null)
    {
        $this->traeger = $traeger;
        return $this;
    }
    /**
     * Get erfassungsdatum value
     * @return string
     */
    public function getErfassungsdatum()
    {
        return $this->erfassungsdatum;
    }
    /**
     * Set erfassungsdatum value
     * @param string $erfassungsdatum
     * @return \StructType\NachweisB1Auskunft
     */
    public function setErfassungsdatum($erfassungsdatum = null)
    {
        // validation for constraint: string
        if (!is_null($erfassungsdatum) && !is_string($erfassungsdatum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($erfassungsdatum, true), gettype($erfassungsdatum)), __LINE__);
        }
        $this->erfassungsdatum = $erfassungsdatum;
        return $this;
    }
    /**
     * Get ausweisnummer value
     * @return string
     */
    public function getAusweisnummer()
    {
        return $this->ausweisnummer;
    }
    /**
     * Set ausweisnummer value
     * @param string $ausweisnummer
     * @return \StructType\NachweisB1Auskunft
     */
    public function setAusweisnummer($ausweisnummer = null)
    {
        // validation for constraint: string
        if (!is_null($ausweisnummer) && !is_string($ausweisnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ausweisnummer, true), gettype($ausweisnummer)), __LINE__);
        }
        $this->ausweisnummer = $ausweisnummer;
        return $this;
    }
}
