<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KurstraegerAuskunft StructType
 * @subpackage Structs
 */
class KurstraegerAuskunft extends AbstractStructBase
{
    /**
     * The kennung
     * Meta information extracted from the WSDL
     * - documentation: Die vom BAMF vergebene Trägerkennung.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kennung;
    /**
     * The name
     * Meta information extracted from the WSDL
     * - documentation: Der Name des Kursträgers.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $name;
    /**
     * Constructor method for KurstraegerAuskunft
     * @uses KurstraegerAuskunft::setKennung()
     * @uses KurstraegerAuskunft::setName()
     * @param string $kennung
     * @param string $name
     */
    public function __construct($kennung = null, $name = null)
    {
        $this
            ->setKennung($kennung)
            ->setName($name);
    }
    /**
     * Get kennung value
     * @return string
     */
    public function getKennung()
    {
        return $this->kennung;
    }
    /**
     * Set kennung value
     * @param string $kennung
     * @return \StructType\KurstraegerAuskunft
     */
    public function setKennung($kennung = null)
    {
        // validation for constraint: string
        if (!is_null($kennung) && !is_string($kennung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kennung, true), gettype($kennung)), __LINE__);
        }
        $this->kennung = $kennung;
        return $this;
    }
    /**
     * Get name value
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\KurstraegerAuskunft
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
}
