<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KursbesuchAuskunft StructType
 * @subpackage Structs
 */
class KursbesuchAuskunft extends AbstractStructBase
{
    /**
     * The traeger
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\KurstraegerAuskunft
     */
    public $traeger;
    /**
     * The kursart
     * Meta information extracted from the WSDL
     * - documentation: Codeliste 809.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kursart;
    /**
     * The kursbeginn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kursbeginn;
    /**
     * The kurskennung
     * Meta information extracted from the WSDL
     * - documentation: Die vom Bundesamt vergebene eindeutige Kennung für diesen Kurs.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kurskennung;
    /**
     * The kursabschnittBesuch
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KursabschnittBesuchAuskunft[]
     */
    public $kursabschnittBesuch;
    /**
     * Constructor method for KursbesuchAuskunft
     * @uses KursbesuchAuskunft::setTraeger()
     * @uses KursbesuchAuskunft::setKursart()
     * @uses KursbesuchAuskunft::setKursbeginn()
     * @uses KursbesuchAuskunft::setKurskennung()
     * @uses KursbesuchAuskunft::setKursabschnittBesuch()
     * @param \StructType\KurstraegerAuskunft $traeger
     * @param string $kursart
     * @param string $kursbeginn
     * @param string $kurskennung
     * @param \StructType\KursabschnittBesuchAuskunft[] $kursabschnittBesuch
     */
    public function __construct(\StructType\KurstraegerAuskunft $traeger = null, $kursart = null, $kursbeginn = null, $kurskennung = null, array $kursabschnittBesuch = array())
    {
        $this
            ->setTraeger($traeger)
            ->setKursart($kursart)
            ->setKursbeginn($kursbeginn)
            ->setKurskennung($kurskennung)
            ->setKursabschnittBesuch($kursabschnittBesuch);
    }
    /**
     * Get traeger value
     * @return \StructType\KurstraegerAuskunft
     */
    public function getTraeger()
    {
        return $this->traeger;
    }
    /**
     * Set traeger value
     * @param \StructType\KurstraegerAuskunft $traeger
     * @return \StructType\KursbesuchAuskunft
     */
    public function setTraeger(\StructType\KurstraegerAuskunft $traeger = null)
    {
        $this->traeger = $traeger;
        return $this;
    }
    /**
     * Get kursart value
     * @return string
     */
    public function getKursart()
    {
        return $this->kursart;
    }
    /**
     * Set kursart value
     * @param string $kursart
     * @return \StructType\KursbesuchAuskunft
     */
    public function setKursart($kursart = null)
    {
        // validation for constraint: string
        if (!is_null($kursart) && !is_string($kursart)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kursart, true), gettype($kursart)), __LINE__);
        }
        $this->kursart = $kursart;
        return $this;
    }
    /**
     * Get kursbeginn value
     * @return string
     */
    public function getKursbeginn()
    {
        return $this->kursbeginn;
    }
    /**
     * Set kursbeginn value
     * @param string $kursbeginn
     * @return \StructType\KursbesuchAuskunft
     */
    public function setKursbeginn($kursbeginn = null)
    {
        // validation for constraint: string
        if (!is_null($kursbeginn) && !is_string($kursbeginn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kursbeginn, true), gettype($kursbeginn)), __LINE__);
        }
        $this->kursbeginn = $kursbeginn;
        return $this;
    }
    /**
     * Get kurskennung value
     * @return string
     */
    public function getKurskennung()
    {
        return $this->kurskennung;
    }
    /**
     * Set kurskennung value
     * @param string $kurskennung
     * @return \StructType\KursbesuchAuskunft
     */
    public function setKurskennung($kurskennung = null)
    {
        // validation for constraint: string
        if (!is_null($kurskennung) && !is_string($kurskennung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kurskennung, true), gettype($kurskennung)), __LINE__);
        }
        $this->kurskennung = $kurskennung;
        return $this;
    }
    /**
     * Get kursabschnittBesuch value
     * @return \StructType\KursabschnittBesuchAuskunft[]|null
     */
    public function getKursabschnittBesuch()
    {
        return $this->kursabschnittBesuch;
    }
    /**
     * This method is responsible for validating the values passed to the setKursabschnittBesuch method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKursabschnittBesuch method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKursabschnittBesuchForArrayConstraintsFromSetKursabschnittBesuch(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $kursbesuchAuskunftKursabschnittBesuchItem) {
            // validation for constraint: itemType
            if (!$kursbesuchAuskunftKursabschnittBesuchItem instanceof \StructType\KursabschnittBesuchAuskunft) {
                $invalidValues[] = is_object($kursbesuchAuskunftKursabschnittBesuchItem) ? get_class($kursbesuchAuskunftKursabschnittBesuchItem) : sprintf('%s(%s)', gettype($kursbesuchAuskunftKursabschnittBesuchItem), var_export($kursbesuchAuskunftKursabschnittBesuchItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kursabschnittBesuch property can only contain items of type \StructType\KursabschnittBesuchAuskunft, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kursabschnittBesuch value
     * @throws \InvalidArgumentException
     * @param \StructType\KursabschnittBesuchAuskunft[] $kursabschnittBesuch
     * @return \StructType\KursbesuchAuskunft
     */
    public function setKursabschnittBesuch(array $kursabschnittBesuch = array())
    {
        // validation for constraint: array
        if ('' !== ($kursabschnittBesuchArrayErrorMessage = self::validateKursabschnittBesuchForArrayConstraintsFromSetKursabschnittBesuch($kursabschnittBesuch))) {
            throw new \InvalidArgumentException($kursabschnittBesuchArrayErrorMessage, __LINE__);
        }
        $this->kursabschnittBesuch = $kursabschnittBesuch;
        return $this;
    }
    /**
     * Add item to kursabschnittBesuch value
     * @throws \InvalidArgumentException
     * @param \StructType\KursabschnittBesuchAuskunft $item
     * @return \StructType\KursbesuchAuskunft
     */
    public function addToKursabschnittBesuch(\StructType\KursabschnittBesuchAuskunft $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KursabschnittBesuchAuskunft) {
            throw new \InvalidArgumentException(sprintf('The kursabschnittBesuch property can only contain items of type \StructType\KursabschnittBesuchAuskunft, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kursabschnittBesuch[] = $item;
        return $this;
    }
}
