<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KursabschnittBesuchAuskunft StructType
 * @subpackage Structs
 */
class KursabschnittBesuchAuskunft extends AbstractStructBase
{
    /**
     * The kursabschnitt
     * Meta information extracted from the WSDL
     * - documentation: Codeliste 810.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kursabschnitt;
    /**
     * The kursabschnittBeginn
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $kursabschnittBeginn;
    /**
     * The kursort
     * Meta information extracted from the WSDL
     * - documentation: Die Anschrift des Kursorts, an dem dieser Abschnitt begonnen hat.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AdresseAuskunft
     */
    public $kursort;
    /**
     * The abgerechnet
     * Meta information extracted from the WSDL
     * - documentation: Angabe, ob dieser Abschnitt bereits abgerechnet wurde.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $abgerechnet;
    /**
     * The kursabschnittEnde
     * Meta information extracted from the WSDL
     * - documentation: Diese Information liegt erst definitiv vor, wenn die Abrechnung durchgeführt wurde. Davor ist eventuell ein voraussichtliches Datum vorhanden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $kursabschnittEnde;
    /**
     * The stundenAnwesend
     * Meta information extracted from the WSDL
     * - documentation: Anzahl der abgerechneten UE, an denen der Teilnehmer tatsächlich teilgenommen hat. Diese Information liegt nur vor, wenn die Abrechnung bereits durchgeführt wurde.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $stundenAnwesend;
    /**
     * The fehlstundenEntschuldigt
     * Meta information extracted from the WSDL
     * - documentation: Gesamte Fehlstunden laut Abrechnungsunterlagen, für die eine Entschuldigung vorgelegt wurde. Diese Information liegt nur vor, wenn die Abrechnung bereits durchgeführt wurde.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $fehlstundenEntschuldigt;
    /**
     * The fehlstundenUnentschuldigt
     * Meta information extracted from the WSDL
     * - documentation: Gesamte Fehlstunden laut Abrechnungsunterlagen, für die keine Entschuldigung vorgelegt wurde. Diese Information liegt nur vor, wenn die Abrechnung bereits durchgeführt wurde.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $fehlstundenUnentschuldigt;
    /**
     * The fehlstundenWechsel
     * Meta information extracted from the WSDL
     * - documentation: Hinweis auf einen Kursträgerwechsels während des Kursabschnitts nach §14 Abs. 3 IntV. In diesem Fall wird dieser Abschnitt nicht auf das Stundenkontingent angerechnet. Diese Information liegt nur vor, wenn die Abrechnung bereits
     * durchgeführt wurde.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fehlstundenWechsel;
    /**
     * The abrechnungKostenbefreit
     * Meta information extracted from the WSDL
     * - documentation: Gibt für bereits abgerechnete Abschnitte an, ob der Teilnehmer bei dieser Abrechnung als kostenbefreit berücksichtigt wurde. Für Altdaten liegt diese Information auch bei bereits abgerechneten Abschnitten potenziell nicht vor.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $abrechnungKostenbefreit;
    /**
     * Constructor method for KursabschnittBesuchAuskunft
     * @uses KursabschnittBesuchAuskunft::setKursabschnitt()
     * @uses KursabschnittBesuchAuskunft::setKursabschnittBeginn()
     * @uses KursabschnittBesuchAuskunft::setKursort()
     * @uses KursabschnittBesuchAuskunft::setAbgerechnet()
     * @uses KursabschnittBesuchAuskunft::setKursabschnittEnde()
     * @uses KursabschnittBesuchAuskunft::setStundenAnwesend()
     * @uses KursabschnittBesuchAuskunft::setFehlstundenEntschuldigt()
     * @uses KursabschnittBesuchAuskunft::setFehlstundenUnentschuldigt()
     * @uses KursabschnittBesuchAuskunft::setFehlstundenWechsel()
     * @uses KursabschnittBesuchAuskunft::setAbrechnungKostenbefreit()
     * @param string $kursabschnitt
     * @param string $kursabschnittBeginn
     * @param \StructType\AdresseAuskunft $kursort
     * @param bool $abgerechnet
     * @param string $kursabschnittEnde
     * @param int $stundenAnwesend
     * @param int $fehlstundenEntschuldigt
     * @param int $fehlstundenUnentschuldigt
     * @param string $fehlstundenWechsel
     * @param bool $abrechnungKostenbefreit
     */
    public function __construct($kursabschnitt = null, $kursabschnittBeginn = null, \StructType\AdresseAuskunft $kursort = null, $abgerechnet = null, $kursabschnittEnde = null, $stundenAnwesend = null, $fehlstundenEntschuldigt = null, $fehlstundenUnentschuldigt = null, $fehlstundenWechsel = null, $abrechnungKostenbefreit = null)
    {
        $this
            ->setKursabschnitt($kursabschnitt)
            ->setKursabschnittBeginn($kursabschnittBeginn)
            ->setKursort($kursort)
            ->setAbgerechnet($abgerechnet)
            ->setKursabschnittEnde($kursabschnittEnde)
            ->setStundenAnwesend($stundenAnwesend)
            ->setFehlstundenEntschuldigt($fehlstundenEntschuldigt)
            ->setFehlstundenUnentschuldigt($fehlstundenUnentschuldigt)
            ->setFehlstundenWechsel($fehlstundenWechsel)
            ->setAbrechnungKostenbefreit($abrechnungKostenbefreit);
    }
    /**
     * Get kursabschnitt value
     * @return string
     */
    public function getKursabschnitt()
    {
        return $this->kursabschnitt;
    }
    /**
     * Set kursabschnitt value
     * @param string $kursabschnitt
     * @return \StructType\KursabschnittBesuchAuskunft
     */
    public function setKursabschnitt($kursabschnitt = null)
    {
        // validation for constraint: string
        if (!is_null($kursabschnitt) && !is_string($kursabschnitt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kursabschnitt, true), gettype($kursabschnitt)), __LINE__);
        }
        $this->kursabschnitt = $kursabschnitt;
        return $this;
    }
    /**
     * Get kursabschnittBeginn value
     * @return string
     */
    public function getKursabschnittBeginn()
    {
        return $this->kursabschnittBeginn;
    }
    /**
     * Set kursabschnittBeginn value
     * @param string $kursabschnittBeginn
     * @return \StructType\KursabschnittBesuchAuskunft
     */
    public function setKursabschnittBeginn($kursabschnittBeginn = null)
    {
        // validation for constraint: string
        if (!is_null($kursabschnittBeginn) && !is_string($kursabschnittBeginn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kursabschnittBeginn, true), gettype($kursabschnittBeginn)), __LINE__);
        }
        $this->kursabschnittBeginn = $kursabschnittBeginn;
        return $this;
    }
    /**
     * Get kursort value
     * @return \StructType\AdresseAuskunft
     */
    public function getKursort()
    {
        return $this->kursort;
    }
    /**
     * Set kursort value
     * @param \StructType\AdresseAuskunft $kursort
     * @return \StructType\KursabschnittBesuchAuskunft
     */
    public function setKursort(\StructType\AdresseAuskunft $kursort = null)
    {
        $this->kursort = $kursort;
        return $this;
    }
    /**
     * Get abgerechnet value
     * @return bool
     */
    public function getAbgerechnet()
    {
        return $this->abgerechnet;
    }
    /**
     * Set abgerechnet value
     * @param bool $abgerechnet
     * @return \StructType\KursabschnittBesuchAuskunft
     */
    public function setAbgerechnet($abgerechnet = null)
    {
        // validation for constraint: boolean
        if (!is_null($abgerechnet) && !is_bool($abgerechnet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($abgerechnet, true), gettype($abgerechnet)), __LINE__);
        }
        $this->abgerechnet = $abgerechnet;
        return $this;
    }
    /**
     * Get kursabschnittEnde value
     * @return string|null
     */
    public function getKursabschnittEnde()
    {
        return $this->kursabschnittEnde;
    }
    /**
     * Set kursabschnittEnde value
     * @param string $kursabschnittEnde
     * @return \StructType\KursabschnittBesuchAuskunft
     */
    public function setKursabschnittEnde($kursabschnittEnde = null)
    {
        // validation for constraint: string
        if (!is_null($kursabschnittEnde) && !is_string($kursabschnittEnde)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kursabschnittEnde, true), gettype($kursabschnittEnde)), __LINE__);
        }
        $this->kursabschnittEnde = $kursabschnittEnde;
        return $this;
    }
    /**
     * Get stundenAnwesend value
     * @return int|null
     */
    public function getStundenAnwesend()
    {
        return $this->stundenAnwesend;
    }
    /**
     * Set stundenAnwesend value
     * @param int $stundenAnwesend
     * @return \StructType\KursabschnittBesuchAuskunft
     */
    public function setStundenAnwesend($stundenAnwesend = null)
    {
        // validation for constraint: int
        if (!is_null($stundenAnwesend) && !(is_int($stundenAnwesend) || ctype_digit($stundenAnwesend))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($stundenAnwesend, true), gettype($stundenAnwesend)), __LINE__);
        }
        $this->stundenAnwesend = $stundenAnwesend;
        return $this;
    }
    /**
     * Get fehlstundenEntschuldigt value
     * @return int|null
     */
    public function getFehlstundenEntschuldigt()
    {
        return $this->fehlstundenEntschuldigt;
    }
    /**
     * Set fehlstundenEntschuldigt value
     * @param int $fehlstundenEntschuldigt
     * @return \StructType\KursabschnittBesuchAuskunft
     */
    public function setFehlstundenEntschuldigt($fehlstundenEntschuldigt = null)
    {
        // validation for constraint: int
        if (!is_null($fehlstundenEntschuldigt) && !(is_int($fehlstundenEntschuldigt) || ctype_digit($fehlstundenEntschuldigt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fehlstundenEntschuldigt, true), gettype($fehlstundenEntschuldigt)), __LINE__);
        }
        $this->fehlstundenEntschuldigt = $fehlstundenEntschuldigt;
        return $this;
    }
    /**
     * Get fehlstundenUnentschuldigt value
     * @return int|null
     */
    public function getFehlstundenUnentschuldigt()
    {
        return $this->fehlstundenUnentschuldigt;
    }
    /**
     * Set fehlstundenUnentschuldigt value
     * @param int $fehlstundenUnentschuldigt
     * @return \StructType\KursabschnittBesuchAuskunft
     */
    public function setFehlstundenUnentschuldigt($fehlstundenUnentschuldigt = null)
    {
        // validation for constraint: int
        if (!is_null($fehlstundenUnentschuldigt) && !(is_int($fehlstundenUnentschuldigt) || ctype_digit($fehlstundenUnentschuldigt))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fehlstundenUnentschuldigt, true), gettype($fehlstundenUnentschuldigt)), __LINE__);
        }
        $this->fehlstundenUnentschuldigt = $fehlstundenUnentschuldigt;
        return $this;
    }
    /**
     * Get fehlstundenWechsel value
     * @return string|null
     */
    public function getFehlstundenWechsel()
    {
        return $this->fehlstundenWechsel;
    }
    /**
     * Set fehlstundenWechsel value
     * @param string $fehlstundenWechsel
     * @return \StructType\KursabschnittBesuchAuskunft
     */
    public function setFehlstundenWechsel($fehlstundenWechsel = null)
    {
        // validation for constraint: string
        if (!is_null($fehlstundenWechsel) && !is_string($fehlstundenWechsel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fehlstundenWechsel, true), gettype($fehlstundenWechsel)), __LINE__);
        }
        $this->fehlstundenWechsel = $fehlstundenWechsel;
        return $this;
    }
    /**
     * Get abrechnungKostenbefreit value
     * @return bool|null
     */
    public function getAbrechnungKostenbefreit()
    {
        return $this->abrechnungKostenbefreit;
    }
    /**
     * Set abrechnungKostenbefreit value
     * @param bool $abrechnungKostenbefreit
     * @return \StructType\KursabschnittBesuchAuskunft
     */
    public function setAbrechnungKostenbefreit($abrechnungKostenbefreit = null)
    {
        // validation for constraint: boolean
        if (!is_null($abrechnungKostenbefreit) && !is_bool($abrechnungKostenbefreit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($abrechnungKostenbefreit, true), gettype($abrechnungKostenbefreit)), __LINE__);
        }
        $this->abrechnungKostenbefreit = $abrechnungKostenbefreit;
        return $this;
    }
}
