<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KontingentAuskunft StructType
 * @subpackage Structs
 */
class KontingentAuskunft extends AbstractStructBase
{
    /**
     * The sprachstundenVerfuegbarErstverfahren
     * Meta information extracted from the WSDL
     * - documentation: Nach Kenntnisstand des Bundesamts noch verfügbare Sprachkurs-Stunden im Erstverfahren. Noch offene Abrechnungen sind dabei nicht berücksichtigt! Entsprechend den spezifischen Eigenheiten des Vorgangs, können die offenen UE
     * eventuell nur in bestimmten Kursarten bzw. in einem bestimmten Zeitraum wahrgenommen werden. Insbesondere ist zu beachten, dass ab Erteilung der Wiederholerberechtigung eventuell noch vorhandene Sprachkursstunden (nicht Orientierungskurs) im
     * Erstverfahren nicht mehr nutzbar sind.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $sprachstundenVerfuegbarErstverfahren;
    /**
     * The sprachstundenVerbrauchtErstverfahren
     * Meta information extracted from the WSDL
     * - documentation: Bereits abgerechnete Sprachkurs-Stunden im Erstverfahren. Noch offene Abrechnungen sind dabei nicht berücksichtigt!
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $sprachstundenVerbrauchtErstverfahren;
    /**
     * The sprachstundenVerfuegbarWhVerfahren
     * Meta information extracted from the WSDL
     * - documentation: Nach Kenntnisstand des Bundesamts noch verfügbare Sprachkurs-Stunden im Wiederholerverfahren. Noch offene Abrechnungen sind dabei nicht berücksichtigt!
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $sprachstundenVerfuegbarWhVerfahren;
    /**
     * The sprachstundenVerbrauchtWhVerfahren
     * Meta information extracted from the WSDL
     * - documentation: Bereits abgerechnete Sprachkurs-Stunden im Wiederholerverfahren. Noch offene Abrechnungen sind dabei nicht berücksichtigt!
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $sprachstundenVerbrauchtWhVerfahren;
    /**
     * The oKursStundenVerbraucht
     * Meta information extracted from the WSDL
     * - documentation: Wahr, falls der Orientierungskurs bereits abgerechnet wurde. Noch offene Abrechnungen sind dabei nicht berücksichtigt!
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $oKursStundenVerbraucht;
    /**
     * Constructor method for KontingentAuskunft
     * @uses KontingentAuskunft::setSprachstundenVerfuegbarErstverfahren()
     * @uses KontingentAuskunft::setSprachstundenVerbrauchtErstverfahren()
     * @uses KontingentAuskunft::setSprachstundenVerfuegbarWhVerfahren()
     * @uses KontingentAuskunft::setSprachstundenVerbrauchtWhVerfahren()
     * @uses KontingentAuskunft::setOKursStundenVerbraucht()
     * @param int $sprachstundenVerfuegbarErstverfahren
     * @param int $sprachstundenVerbrauchtErstverfahren
     * @param int $sprachstundenVerfuegbarWhVerfahren
     * @param int $sprachstundenVerbrauchtWhVerfahren
     * @param bool $oKursStundenVerbraucht
     */
    public function __construct($sprachstundenVerfuegbarErstverfahren = null, $sprachstundenVerbrauchtErstverfahren = null, $sprachstundenVerfuegbarWhVerfahren = null, $sprachstundenVerbrauchtWhVerfahren = null, $oKursStundenVerbraucht = null)
    {
        $this
            ->setSprachstundenVerfuegbarErstverfahren($sprachstundenVerfuegbarErstverfahren)
            ->setSprachstundenVerbrauchtErstverfahren($sprachstundenVerbrauchtErstverfahren)
            ->setSprachstundenVerfuegbarWhVerfahren($sprachstundenVerfuegbarWhVerfahren)
            ->setSprachstundenVerbrauchtWhVerfahren($sprachstundenVerbrauchtWhVerfahren)
            ->setOKursStundenVerbraucht($oKursStundenVerbraucht);
    }
    /**
     * Get sprachstundenVerfuegbarErstverfahren value
     * @return int|null
     */
    public function getSprachstundenVerfuegbarErstverfahren()
    {
        return $this->sprachstundenVerfuegbarErstverfahren;
    }
    /**
     * Set sprachstundenVerfuegbarErstverfahren value
     * @param int $sprachstundenVerfuegbarErstverfahren
     * @return \StructType\KontingentAuskunft
     */
    public function setSprachstundenVerfuegbarErstverfahren($sprachstundenVerfuegbarErstverfahren = null)
    {
        // validation for constraint: int
        if (!is_null($sprachstundenVerfuegbarErstverfahren) && !(is_int($sprachstundenVerfuegbarErstverfahren) || ctype_digit($sprachstundenVerfuegbarErstverfahren))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sprachstundenVerfuegbarErstverfahren, true), gettype($sprachstundenVerfuegbarErstverfahren)), __LINE__);
        }
        $this->sprachstundenVerfuegbarErstverfahren = $sprachstundenVerfuegbarErstverfahren;
        return $this;
    }
    /**
     * Get sprachstundenVerbrauchtErstverfahren value
     * @return int|null
     */
    public function getSprachstundenVerbrauchtErstverfahren()
    {
        return $this->sprachstundenVerbrauchtErstverfahren;
    }
    /**
     * Set sprachstundenVerbrauchtErstverfahren value
     * @param int $sprachstundenVerbrauchtErstverfahren
     * @return \StructType\KontingentAuskunft
     */
    public function setSprachstundenVerbrauchtErstverfahren($sprachstundenVerbrauchtErstverfahren = null)
    {
        // validation for constraint: int
        if (!is_null($sprachstundenVerbrauchtErstverfahren) && !(is_int($sprachstundenVerbrauchtErstverfahren) || ctype_digit($sprachstundenVerbrauchtErstverfahren))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sprachstundenVerbrauchtErstverfahren, true), gettype($sprachstundenVerbrauchtErstverfahren)), __LINE__);
        }
        $this->sprachstundenVerbrauchtErstverfahren = $sprachstundenVerbrauchtErstverfahren;
        return $this;
    }
    /**
     * Get sprachstundenVerfuegbarWhVerfahren value
     * @return int|null
     */
    public function getSprachstundenVerfuegbarWhVerfahren()
    {
        return $this->sprachstundenVerfuegbarWhVerfahren;
    }
    /**
     * Set sprachstundenVerfuegbarWhVerfahren value
     * @param int $sprachstundenVerfuegbarWhVerfahren
     * @return \StructType\KontingentAuskunft
     */
    public function setSprachstundenVerfuegbarWhVerfahren($sprachstundenVerfuegbarWhVerfahren = null)
    {
        // validation for constraint: int
        if (!is_null($sprachstundenVerfuegbarWhVerfahren) && !(is_int($sprachstundenVerfuegbarWhVerfahren) || ctype_digit($sprachstundenVerfuegbarWhVerfahren))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sprachstundenVerfuegbarWhVerfahren, true), gettype($sprachstundenVerfuegbarWhVerfahren)), __LINE__);
        }
        $this->sprachstundenVerfuegbarWhVerfahren = $sprachstundenVerfuegbarWhVerfahren;
        return $this;
    }
    /**
     * Get sprachstundenVerbrauchtWhVerfahren value
     * @return int|null
     */
    public function getSprachstundenVerbrauchtWhVerfahren()
    {
        return $this->sprachstundenVerbrauchtWhVerfahren;
    }
    /**
     * Set sprachstundenVerbrauchtWhVerfahren value
     * @param int $sprachstundenVerbrauchtWhVerfahren
     * @return \StructType\KontingentAuskunft
     */
    public function setSprachstundenVerbrauchtWhVerfahren($sprachstundenVerbrauchtWhVerfahren = null)
    {
        // validation for constraint: int
        if (!is_null($sprachstundenVerbrauchtWhVerfahren) && !(is_int($sprachstundenVerbrauchtWhVerfahren) || ctype_digit($sprachstundenVerbrauchtWhVerfahren))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sprachstundenVerbrauchtWhVerfahren, true), gettype($sprachstundenVerbrauchtWhVerfahren)), __LINE__);
        }
        $this->sprachstundenVerbrauchtWhVerfahren = $sprachstundenVerbrauchtWhVerfahren;
        return $this;
    }
    /**
     * Get oKursStundenVerbraucht value
     * @return bool|null
     */
    public function getOKursStundenVerbraucht()
    {
        return $this->oKursStundenVerbraucht;
    }
    /**
     * Set oKursStundenVerbraucht value
     * @param bool $oKursStundenVerbraucht
     * @return \StructType\KontingentAuskunft
     */
    public function setOKursStundenVerbraucht($oKursStundenVerbraucht = null)
    {
        // validation for constraint: boolean
        if (!is_null($oKursStundenVerbraucht) && !is_bool($oKursStundenVerbraucht)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($oKursStundenVerbraucht, true), gettype($oKursStundenVerbraucht)), __LINE__);
        }
        $this->oKursStundenVerbraucht = $oKursStundenVerbraucht;
        return $this;
    }
}
