<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KontaktAuskunft StructType
 * @subpackage Structs
 */
class KontaktAuskunft extends AbstractStructBase
{
    /**
     * The art
     * Meta information extracted from the WSDL
     * - documentation: Codeliste 816.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $art;
    /**
     * The information
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $information;
    /**
     * Constructor method for KontaktAuskunft
     * @uses KontaktAuskunft::setArt()
     * @uses KontaktAuskunft::setInformation()
     * @param string $art
     * @param string $information
     */
    public function __construct($art = null, $information = null)
    {
        $this
            ->setArt($art)
            ->setInformation($information);
    }
    /**
     * Get art value
     * @return string
     */
    public function getArt()
    {
        return $this->art;
    }
    /**
     * Set art value
     * @param string $art
     * @return \StructType\KontaktAuskunft
     */
    public function setArt($art = null)
    {
        // validation for constraint: string
        if (!is_null($art) && !is_string($art)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($art, true), gettype($art)), __LINE__);
        }
        $this->art = $art;
        return $this;
    }
    /**
     * Get information value
     * @return string
     */
    public function getInformation()
    {
        return $this->information;
    }
    /**
     * Set information value
     * @param string $information
     * @return \StructType\KontaktAuskunft
     */
    public function setInformation($information = null)
    {
        // validation for constraint: string
        if (!is_null($information) && !is_string($information)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($information, true), gettype($information)), __LINE__);
        }
        $this->information = $information;
        return $this;
    }
}
