<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BehoerdeAuskunft StructType
 * @subpackage Structs
 */
class BehoerdeAuskunft extends AbstractStructBase
{
    /**
     * The art
     * Meta information extracted from the WSDL
     * - documentation: Textuelle Beschreibung des Behördentyps.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $art;
    /**
     * The bezeichnung
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $bezeichnung;
    /**
     * The kennung
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $kennung;
    /**
     * The anschrift
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AdresseAuskunft
     */
    public $anschrift;
    /**
     * The kontakt
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KontaktAuskunft[]
     */
    public $kontakt;
    /**
     * Constructor method for BehoerdeAuskunft
     * @uses BehoerdeAuskunft::setArt()
     * @uses BehoerdeAuskunft::setBezeichnung()
     * @uses BehoerdeAuskunft::setKennung()
     * @uses BehoerdeAuskunft::setAnschrift()
     * @uses BehoerdeAuskunft::setKontakt()
     * @param string $art
     * @param string $bezeichnung
     * @param string $kennung
     * @param \StructType\AdresseAuskunft $anschrift
     * @param \StructType\KontaktAuskunft[] $kontakt
     */
    public function __construct($art = null, $bezeichnung = null, $kennung = null, \StructType\AdresseAuskunft $anschrift = null, array $kontakt = array())
    {
        $this
            ->setArt($art)
            ->setBezeichnung($bezeichnung)
            ->setKennung($kennung)
            ->setAnschrift($anschrift)
            ->setKontakt($kontakt);
    }
    /**
     * Get art value
     * @return string
     */
    public function getArt()
    {
        return $this->art;
    }
    /**
     * Set art value
     * @param string $art
     * @return \StructType\BehoerdeAuskunft
     */
    public function setArt($art = null)
    {
        // validation for constraint: string
        if (!is_null($art) && !is_string($art)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($art, true), gettype($art)), __LINE__);
        }
        $this->art = $art;
        return $this;
    }
    /**
     * Get bezeichnung value
     * @return string
     */
    public function getBezeichnung()
    {
        return $this->bezeichnung;
    }
    /**
     * Set bezeichnung value
     * @param string $bezeichnung
     * @return \StructType\BehoerdeAuskunft
     */
    public function setBezeichnung($bezeichnung = null)
    {
        // validation for constraint: string
        if (!is_null($bezeichnung) && !is_string($bezeichnung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bezeichnung, true), gettype($bezeichnung)), __LINE__);
        }
        $this->bezeichnung = $bezeichnung;
        return $this;
    }
    /**
     * Get kennung value
     * @return string|null
     */
    public function getKennung()
    {
        return $this->kennung;
    }
    /**
     * Set kennung value
     * @param string $kennung
     * @return \StructType\BehoerdeAuskunft
     */
    public function setKennung($kennung = null)
    {
        // validation for constraint: string
        if (!is_null($kennung) && !is_string($kennung)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kennung, true), gettype($kennung)), __LINE__);
        }
        $this->kennung = $kennung;
        return $this;
    }
    /**
     * Get anschrift value
     * @return \StructType\AdresseAuskunft|null
     */
    public function getAnschrift()
    {
        return $this->anschrift;
    }
    /**
     * Set anschrift value
     * @param \StructType\AdresseAuskunft $anschrift
     * @return \StructType\BehoerdeAuskunft
     */
    public function setAnschrift(\StructType\AdresseAuskunft $anschrift = null)
    {
        $this->anschrift = $anschrift;
        return $this;
    }
    /**
     * Get kontakt value
     * @return \StructType\KontaktAuskunft[]|null
     */
    public function getKontakt()
    {
        return $this->kontakt;
    }
    /**
     * This method is responsible for validating the values passed to the setKontakt method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKontakt method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKontaktForArrayConstraintsFromSetKontakt(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $behoerdeAuskunftKontaktItem) {
            // validation for constraint: itemType
            if (!$behoerdeAuskunftKontaktItem instanceof \StructType\KontaktAuskunft) {
                $invalidValues[] = is_object($behoerdeAuskunftKontaktItem) ? get_class($behoerdeAuskunftKontaktItem) : sprintf('%s(%s)', gettype($behoerdeAuskunftKontaktItem), var_export($behoerdeAuskunftKontaktItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The kontakt property can only contain items of type \StructType\KontaktAuskunft, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set kontakt value
     * @throws \InvalidArgumentException
     * @param \StructType\KontaktAuskunft[] $kontakt
     * @return \StructType\BehoerdeAuskunft
     */
    public function setKontakt(array $kontakt = array())
    {
        // validation for constraint: array
        if ('' !== ($kontaktArrayErrorMessage = self::validateKontaktForArrayConstraintsFromSetKontakt($kontakt))) {
            throw new \InvalidArgumentException($kontaktArrayErrorMessage, __LINE__);
        }
        $this->kontakt = $kontakt;
        return $this;
    }
    /**
     * Add item to kontakt value
     * @throws \InvalidArgumentException
     * @param \StructType\KontaktAuskunft $item
     * @return \StructType\BehoerdeAuskunft
     */
    public function addToKontakt(\StructType\KontaktAuskunft $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KontaktAuskunft) {
            throw new \InvalidArgumentException(sprintf('The kontakt property can only contain items of type \StructType\KontaktAuskunft, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->kontakt[] = $item;
        return $this;
    }
}
