<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdresseAuskunft StructType
 * @subpackage Structs
 */
class AdresseAuskunft extends AbstractStructBase
{
    /**
     * The plz
     * Meta information extracted from the WSDL
     * - documentation: Adressen ohne Postleitzahl (oder äquivalent bei ausländische Adressen) sind nicht erlaubt.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $plz;
    /**
     * The ort
     * Meta information extracted from the WSDL
     * - documentation: Adressen ohne Ortsangabe sind nicht erlaubt.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ort;
    /**
     * The bevollmaechtigter
     * Meta information extracted from the WSDL
     * - documentation: Wird gefüllt, wenn eine Postvollmacht vorliegt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bevollmaechtigter;
    /**
     * The strasse
     * Meta information extracted from the WSDL
     * - documentation: Pflichtfeld, falls Postfach nicht gefüllt. Die Hausnummer muss im separaten Feld Hausnummer übermittelt werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $strasse;
    /**
     * The hausnummer
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $hausnummer;
    /**
     * The postfach
     * Meta information extracted from the WSDL
     * - documentation: Pflichtfeld, falls Strasse nicht gefüllt.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $postfach;
    /**
     * The careOf
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $careOf;
    /**
     * The adresszusatz
     * Meta information extracted from the WSDL
     * - documentation: Ausschließlich für zusätzliche Angaben zur Adresse.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $adresszusatz;
    /**
     * The bundesland
     * Meta information extracted from the WSDL
     * - documentation: Code-Liste 010. Darf nur bei inländischen Adressen gesetzt werden.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bundesland;
    /**
     * The staat
     * Meta information extracted from the WSDL
     * - documentation: Das Land dieser Adresse, nicht die Staatsangehörigkeit. In der Regel Deutschland. Muss bei Anmeldung gesetzt sein.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Staat
     */
    public $staat;
    /**
     * Constructor method for AdresseAuskunft
     * @uses AdresseAuskunft::setPlz()
     * @uses AdresseAuskunft::setOrt()
     * @uses AdresseAuskunft::setBevollmaechtigter()
     * @uses AdresseAuskunft::setStrasse()
     * @uses AdresseAuskunft::setHausnummer()
     * @uses AdresseAuskunft::setPostfach()
     * @uses AdresseAuskunft::setCareOf()
     * @uses AdresseAuskunft::setAdresszusatz()
     * @uses AdresseAuskunft::setBundesland()
     * @uses AdresseAuskunft::setStaat()
     * @param string $plz
     * @param string $ort
     * @param string $bevollmaechtigter
     * @param string $strasse
     * @param string $hausnummer
     * @param string $postfach
     * @param string $careOf
     * @param string $adresszusatz
     * @param string $bundesland
     * @param \StructType\Staat $staat
     */
    public function __construct($plz = null, $ort = null, $bevollmaechtigter = null, $strasse = null, $hausnummer = null, $postfach = null, $careOf = null, $adresszusatz = null, $bundesland = null, \StructType\Staat $staat = null)
    {
        $this
            ->setPlz($plz)
            ->setOrt($ort)
            ->setBevollmaechtigter($bevollmaechtigter)
            ->setStrasse($strasse)
            ->setHausnummer($hausnummer)
            ->setPostfach($postfach)
            ->setCareOf($careOf)
            ->setAdresszusatz($adresszusatz)
            ->setBundesland($bundesland)
            ->setStaat($staat);
    }
    /**
     * Get plz value
     * @return string
     */
    public function getPlz()
    {
        return $this->plz;
    }
    /**
     * Set plz value
     * @param string $plz
     * @return \StructType\AdresseAuskunft
     */
    public function setPlz($plz = null)
    {
        // validation for constraint: string
        if (!is_null($plz) && !is_string($plz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($plz, true), gettype($plz)), __LINE__);
        }
        $this->plz = $plz;
        return $this;
    }
    /**
     * Get ort value
     * @return string
     */
    public function getOrt()
    {
        return $this->ort;
    }
    /**
     * Set ort value
     * @param string $ort
     * @return \StructType\AdresseAuskunft
     */
    public function setOrt($ort = null)
    {
        // validation for constraint: string
        if (!is_null($ort) && !is_string($ort)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ort, true), gettype($ort)), __LINE__);
        }
        $this->ort = $ort;
        return $this;
    }
    /**
     * Get bevollmaechtigter value
     * @return string|null
     */
    public function getBevollmaechtigter()
    {
        return $this->bevollmaechtigter;
    }
    /**
     * Set bevollmaechtigter value
     * @param string $bevollmaechtigter
     * @return \StructType\AdresseAuskunft
     */
    public function setBevollmaechtigter($bevollmaechtigter = null)
    {
        // validation for constraint: string
        if (!is_null($bevollmaechtigter) && !is_string($bevollmaechtigter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bevollmaechtigter, true), gettype($bevollmaechtigter)), __LINE__);
        }
        $this->bevollmaechtigter = $bevollmaechtigter;
        return $this;
    }
    /**
     * Get strasse value
     * @return string|null
     */
    public function getStrasse()
    {
        return $this->strasse;
    }
    /**
     * Set strasse value
     * @param string $strasse
     * @return \StructType\AdresseAuskunft
     */
    public function setStrasse($strasse = null)
    {
        // validation for constraint: string
        if (!is_null($strasse) && !is_string($strasse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($strasse, true), gettype($strasse)), __LINE__);
        }
        $this->strasse = $strasse;
        return $this;
    }
    /**
     * Get hausnummer value
     * @return string|null
     */
    public function getHausnummer()
    {
        return $this->hausnummer;
    }
    /**
     * Set hausnummer value
     * @param string $hausnummer
     * @return \StructType\AdresseAuskunft
     */
    public function setHausnummer($hausnummer = null)
    {
        // validation for constraint: string
        if (!is_null($hausnummer) && !is_string($hausnummer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hausnummer, true), gettype($hausnummer)), __LINE__);
        }
        $this->hausnummer = $hausnummer;
        return $this;
    }
    /**
     * Get postfach value
     * @return string|null
     */
    public function getPostfach()
    {
        return $this->postfach;
    }
    /**
     * Set postfach value
     * @param string $postfach
     * @return \StructType\AdresseAuskunft
     */
    public function setPostfach($postfach = null)
    {
        // validation for constraint: string
        if (!is_null($postfach) && !is_string($postfach)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postfach, true), gettype($postfach)), __LINE__);
        }
        $this->postfach = $postfach;
        return $this;
    }
    /**
     * Get careOf value
     * @return string|null
     */
    public function getCareOf()
    {
        return $this->careOf;
    }
    /**
     * Set careOf value
     * @param string $careOf
     * @return \StructType\AdresseAuskunft
     */
    public function setCareOf($careOf = null)
    {
        // validation for constraint: string
        if (!is_null($careOf) && !is_string($careOf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($careOf, true), gettype($careOf)), __LINE__);
        }
        $this->careOf = $careOf;
        return $this;
    }
    /**
     * Get adresszusatz value
     * @return string|null
     */
    public function getAdresszusatz()
    {
        return $this->adresszusatz;
    }
    /**
     * Set adresszusatz value
     * @param string $adresszusatz
     * @return \StructType\AdresseAuskunft
     */
    public function setAdresszusatz($adresszusatz = null)
    {
        // validation for constraint: string
        if (!is_null($adresszusatz) && !is_string($adresszusatz)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adresszusatz, true), gettype($adresszusatz)), __LINE__);
        }
        $this->adresszusatz = $adresszusatz;
        return $this;
    }
    /**
     * Get bundesland value
     * @return string|null
     */
    public function getBundesland()
    {
        return $this->bundesland;
    }
    /**
     * Set bundesland value
     * @param string $bundesland
     * @return \StructType\AdresseAuskunft
     */
    public function setBundesland($bundesland = null)
    {
        // validation for constraint: string
        if (!is_null($bundesland) && !is_string($bundesland)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundesland, true), gettype($bundesland)), __LINE__);
        }
        $this->bundesland = $bundesland;
        return $this;
    }
    /**
     * Get staat value
     * @return \StructType\Staat|null
     */
    public function getStaat()
    {
        return $this->staat;
    }
    /**
     * Set staat value
     * @param \StructType\Staat $staat
     * @return \StructType\AdresseAuskunft
     */
    public function setStaat(\StructType\Staat $staat = null)
    {
        $this->staat = $staat;
        return $this;
    }
}
