<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbschlussAuskunft StructType
 * @subpackage Structs
 */
class AbschlussAuskunft extends AbstractStructBase
{
    /**
     * The sprachtest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SprachtestergebnisAuskunft[]
     */
    public $sprachtest;
    /**
     * The b1Nachweis
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\NachweisB1Auskunft[]
     */
    public $b1Nachweis;
    /**
     * The oKurstest
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OKurstestergebnisAuskunft[]
     */
    public $oKurstest;
    /**
     * Constructor method for AbschlussAuskunft
     * @uses AbschlussAuskunft::setSprachtest()
     * @uses AbschlussAuskunft::setB1Nachweis()
     * @uses AbschlussAuskunft::setOKurstest()
     * @param \StructType\SprachtestergebnisAuskunft[] $sprachtest
     * @param \StructType\NachweisB1Auskunft[] $b1Nachweis
     * @param \StructType\OKurstestergebnisAuskunft[] $oKurstest
     */
    public function __construct(array $sprachtest = array(), array $b1Nachweis = array(), array $oKurstest = array())
    {
        $this
            ->setSprachtest($sprachtest)
            ->setB1Nachweis($b1Nachweis)
            ->setOKurstest($oKurstest);
    }
    /**
     * Get sprachtest value
     * @return \StructType\SprachtestergebnisAuskunft[]|null
     */
    public function getSprachtest()
    {
        return $this->sprachtest;
    }
    /**
     * This method is responsible for validating the values passed to the setSprachtest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSprachtest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSprachtestForArrayConstraintsFromSetSprachtest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $abschlussAuskunftSprachtestItem) {
            // validation for constraint: itemType
            if (!$abschlussAuskunftSprachtestItem instanceof \StructType\SprachtestergebnisAuskunft) {
                $invalidValues[] = is_object($abschlussAuskunftSprachtestItem) ? get_class($abschlussAuskunftSprachtestItem) : sprintf('%s(%s)', gettype($abschlussAuskunftSprachtestItem), var_export($abschlussAuskunftSprachtestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The sprachtest property can only contain items of type \StructType\SprachtestergebnisAuskunft, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set sprachtest value
     * @throws \InvalidArgumentException
     * @param \StructType\SprachtestergebnisAuskunft[] $sprachtest
     * @return \StructType\AbschlussAuskunft
     */
    public function setSprachtest(array $sprachtest = array())
    {
        // validation for constraint: array
        if ('' !== ($sprachtestArrayErrorMessage = self::validateSprachtestForArrayConstraintsFromSetSprachtest($sprachtest))) {
            throw new \InvalidArgumentException($sprachtestArrayErrorMessage, __LINE__);
        }
        $this->sprachtest = $sprachtest;
        return $this;
    }
    /**
     * Add item to sprachtest value
     * @throws \InvalidArgumentException
     * @param \StructType\SprachtestergebnisAuskunft $item
     * @return \StructType\AbschlussAuskunft
     */
    public function addToSprachtest(\StructType\SprachtestergebnisAuskunft $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SprachtestergebnisAuskunft) {
            throw new \InvalidArgumentException(sprintf('The sprachtest property can only contain items of type \StructType\SprachtestergebnisAuskunft, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->sprachtest[] = $item;
        return $this;
    }
    /**
     * Get b1Nachweis value
     * @return \StructType\NachweisB1Auskunft[]|null
     */
    public function getB1Nachweis()
    {
        return $this->b1Nachweis;
    }
    /**
     * This method is responsible for validating the values passed to the setB1Nachweis method
     * This method is willingly generated in order to preserve the one-line inline validation within the setB1Nachweis method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateB1NachweisForArrayConstraintsFromSetB1Nachweis(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $abschlussAuskunftB1NachweisItem) {
            // validation for constraint: itemType
            if (!$abschlussAuskunftB1NachweisItem instanceof \StructType\NachweisB1Auskunft) {
                $invalidValues[] = is_object($abschlussAuskunftB1NachweisItem) ? get_class($abschlussAuskunftB1NachweisItem) : sprintf('%s(%s)', gettype($abschlussAuskunftB1NachweisItem), var_export($abschlussAuskunftB1NachweisItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The b1Nachweis property can only contain items of type \StructType\NachweisB1Auskunft, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set b1Nachweis value
     * @throws \InvalidArgumentException
     * @param \StructType\NachweisB1Auskunft[] $b1Nachweis
     * @return \StructType\AbschlussAuskunft
     */
    public function setB1Nachweis(array $b1Nachweis = array())
    {
        // validation for constraint: array
        if ('' !== ($b1NachweisArrayErrorMessage = self::validateB1NachweisForArrayConstraintsFromSetB1Nachweis($b1Nachweis))) {
            throw new \InvalidArgumentException($b1NachweisArrayErrorMessage, __LINE__);
        }
        $this->b1Nachweis = $b1Nachweis;
        return $this;
    }
    /**
     * Add item to b1Nachweis value
     * @throws \InvalidArgumentException
     * @param \StructType\NachweisB1Auskunft $item
     * @return \StructType\AbschlussAuskunft
     */
    public function addToB1Nachweis(\StructType\NachweisB1Auskunft $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\NachweisB1Auskunft) {
            throw new \InvalidArgumentException(sprintf('The b1Nachweis property can only contain items of type \StructType\NachweisB1Auskunft, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->b1Nachweis[] = $item;
        return $this;
    }
    /**
     * Get oKurstest value
     * @return \StructType\OKurstestergebnisAuskunft[]|null
     */
    public function getOKurstest()
    {
        return $this->oKurstest;
    }
    /**
     * This method is responsible for validating the values passed to the setOKurstest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOKurstest method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOKurstestForArrayConstraintsFromSetOKurstest(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $abschlussAuskunftOKurstestItem) {
            // validation for constraint: itemType
            if (!$abschlussAuskunftOKurstestItem instanceof \StructType\OKurstestergebnisAuskunft) {
                $invalidValues[] = is_object($abschlussAuskunftOKurstestItem) ? get_class($abschlussAuskunftOKurstestItem) : sprintf('%s(%s)', gettype($abschlussAuskunftOKurstestItem), var_export($abschlussAuskunftOKurstestItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The oKurstest property can only contain items of type \StructType\OKurstestergebnisAuskunft, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set oKurstest value
     * @throws \InvalidArgumentException
     * @param \StructType\OKurstestergebnisAuskunft[] $oKurstest
     * @return \StructType\AbschlussAuskunft
     */
    public function setOKurstest(array $oKurstest = array())
    {
        // validation for constraint: array
        if ('' !== ($oKurstestArrayErrorMessage = self::validateOKurstestForArrayConstraintsFromSetOKurstest($oKurstest))) {
            throw new \InvalidArgumentException($oKurstestArrayErrorMessage, __LINE__);
        }
        $this->oKurstest = $oKurstest;
        return $this;
    }
    /**
     * Add item to oKurstest value
     * @throws \InvalidArgumentException
     * @param \StructType\OKurstestergebnisAuskunft $item
     * @return \StructType\AbschlussAuskunft
     */
    public function addToOKurstest(\StructType\OKurstestergebnisAuskunft $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OKurstestergebnisAuskunft) {
            throw new \InvalidArgumentException(sprintf('The oKurstest property can only contain items of type \StructType\OKurstestergebnisAuskunft, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->oKurstest[] = $item;
        return $this;
    }
}
