<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Teilnehmer ServiceType
 * @subpackage Services
 */
class Teilnehmer extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named teilnehmerAuskunftAnfordern
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TeilnehmerAuskunft_teilnehmerAuskunftAnfordernElement $parameters
     * @return \StructType\TeilnehmerAuskunft_teilnehmerAuskunftAnfordernResponseElement|bool
     */
    public function teilnehmerAuskunftAnfordern(\StructType\TeilnehmerAuskunft_teilnehmerAuskunftAnfordernElement $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->teilnehmerAuskunftAnfordern($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TeilnehmerAuskunft_teilnehmerAuskunftAnfordernResponseElement
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
