<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sindicato StructType
 * @subpackage Structs
 */
class Sindicato extends AbstractStructBase
{
    /**
     * The codigo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $codigo;
    /**
     * The cnpj
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cnpj;
    /**
     * The ufFederacao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ufFederacao;
    /**
     * The sigla
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sigla;
    /**
     * The nome
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nome;
    /**
     * The nomeCompleto
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nomeCompleto;
    /**
     * The filiado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $filiado;
    /**
     * The tipoAbrangencia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tipoAbrangencia;
    /**
     * The presidente
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PessoaFisica
     */
    public $presidente;
    /**
     * The cep
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cep;
    /**
     * The uf
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $uf;
    /**
     * The municipio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Municipio
     */
    public $municipio;
    /**
     * The logradouro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $logradouro;
    /**
     * The bairro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bairro;
    /**
     * The ddd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ddd;
    /**
     * The telefone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $telefone;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The homePage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $homePage;
    /**
     * The contato
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PessoaFisica
     */
    public $contato;
    /**
     * The dataFundacao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataFundacao;
    /**
     * The sedeSindicatoNacional
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sedeSindicatoNacional;
    /**
     * Constructor method for Sindicato
     * @uses Sindicato::setCodigo()
     * @uses Sindicato::setCnpj()
     * @uses Sindicato::setUfFederacao()
     * @uses Sindicato::setSigla()
     * @uses Sindicato::setNome()
     * @uses Sindicato::setNomeCompleto()
     * @uses Sindicato::setFiliado()
     * @uses Sindicato::setTipoAbrangencia()
     * @uses Sindicato::setPresidente()
     * @uses Sindicato::setCep()
     * @uses Sindicato::setUf()
     * @uses Sindicato::setMunicipio()
     * @uses Sindicato::setLogradouro()
     * @uses Sindicato::setBairro()
     * @uses Sindicato::setDdd()
     * @uses Sindicato::setTelefone()
     * @uses Sindicato::setFax()
     * @uses Sindicato::setEmail()
     * @uses Sindicato::setHomePage()
     * @uses Sindicato::setContato()
     * @uses Sindicato::setDataFundacao()
     * @uses Sindicato::setSedeSindicatoNacional()
     * @param string $codigo
     * @param string $cnpj
     * @param string $ufFederacao
     * @param string $sigla
     * @param string $nome
     * @param string $nomeCompleto
     * @param string $filiado
     * @param string $tipoAbrangencia
     * @param \StructType\PessoaFisica $presidente
     * @param string $cep
     * @param string $uf
     * @param \StructType\Municipio $municipio
     * @param string $logradouro
     * @param string $bairro
     * @param string $ddd
     * @param string $telefone
     * @param string $fax
     * @param string $email
     * @param string $homePage
     * @param \StructType\PessoaFisica $contato
     * @param string $dataFundacao
     * @param string $sedeSindicatoNacional
     */
    public function __construct($codigo = null, $cnpj = null, $ufFederacao = null, $sigla = null, $nome = null, $nomeCompleto = null, $filiado = null, $tipoAbrangencia = null, \StructType\PessoaFisica $presidente = null, $cep = null, $uf = null, \StructType\Municipio $municipio = null, $logradouro = null, $bairro = null, $ddd = null, $telefone = null, $fax = null, $email = null, $homePage = null, \StructType\PessoaFisica $contato = null, $dataFundacao = null, $sedeSindicatoNacional = null)
    {
        $this
            ->setCodigo($codigo)
            ->setCnpj($cnpj)
            ->setUfFederacao($ufFederacao)
            ->setSigla($sigla)
            ->setNome($nome)
            ->setNomeCompleto($nomeCompleto)
            ->setFiliado($filiado)
            ->setTipoAbrangencia($tipoAbrangencia)
            ->setPresidente($presidente)
            ->setCep($cep)
            ->setUf($uf)
            ->setMunicipio($municipio)
            ->setLogradouro($logradouro)
            ->setBairro($bairro)
            ->setDdd($ddd)
            ->setTelefone($telefone)
            ->setFax($fax)
            ->setEmail($email)
            ->setHomePage($homePage)
            ->setContato($contato)
            ->setDataFundacao($dataFundacao)
            ->setSedeSindicatoNacional($sedeSindicatoNacional);
    }
    /**
     * Get codigo value
     * @return string|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param string $codigo
     * @return \StructType\Sindicato
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: string
        if (!is_null($codigo) && !is_string($codigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get cnpj value
     * @return string|null
     */
    public function getCnpj()
    {
        return $this->cnpj;
    }
    /**
     * Set cnpj value
     * @param string $cnpj
     * @return \StructType\Sindicato
     */
    public function setCnpj($cnpj = null)
    {
        // validation for constraint: string
        if (!is_null($cnpj) && !is_string($cnpj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cnpj, true), gettype($cnpj)), __LINE__);
        }
        $this->cnpj = $cnpj;
        return $this;
    }
    /**
     * Get ufFederacao value
     * @return string|null
     */
    public function getUfFederacao()
    {
        return $this->ufFederacao;
    }
    /**
     * Set ufFederacao value
     * @param string $ufFederacao
     * @return \StructType\Sindicato
     */
    public function setUfFederacao($ufFederacao = null)
    {
        // validation for constraint: string
        if (!is_null($ufFederacao) && !is_string($ufFederacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ufFederacao, true), gettype($ufFederacao)), __LINE__);
        }
        $this->ufFederacao = $ufFederacao;
        return $this;
    }
    /**
     * Get sigla value
     * @return string|null
     */
    public function getSigla()
    {
        return $this->sigla;
    }
    /**
     * Set sigla value
     * @param string $sigla
     * @return \StructType\Sindicato
     */
    public function setSigla($sigla = null)
    {
        // validation for constraint: string
        if (!is_null($sigla) && !is_string($sigla)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sigla, true), gettype($sigla)), __LINE__);
        }
        $this->sigla = $sigla;
        return $this;
    }
    /**
     * Get nome value
     * @return string|null
     */
    public function getNome()
    {
        return $this->nome;
    }
    /**
     * Set nome value
     * @param string $nome
     * @return \StructType\Sindicato
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        $this->nome = $nome;
        return $this;
    }
    /**
     * Get nomeCompleto value
     * @return string|null
     */
    public function getNomeCompleto()
    {
        return $this->nomeCompleto;
    }
    /**
     * Set nomeCompleto value
     * @param string $nomeCompleto
     * @return \StructType\Sindicato
     */
    public function setNomeCompleto($nomeCompleto = null)
    {
        // validation for constraint: string
        if (!is_null($nomeCompleto) && !is_string($nomeCompleto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeCompleto, true), gettype($nomeCompleto)), __LINE__);
        }
        $this->nomeCompleto = $nomeCompleto;
        return $this;
    }
    /**
     * Get filiado value
     * @return string|null
     */
    public function getFiliado()
    {
        return $this->filiado;
    }
    /**
     * Set filiado value
     * @param string $filiado
     * @return \StructType\Sindicato
     */
    public function setFiliado($filiado = null)
    {
        // validation for constraint: string
        if (!is_null($filiado) && !is_string($filiado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filiado, true), gettype($filiado)), __LINE__);
        }
        $this->filiado = $filiado;
        return $this;
    }
    /**
     * Get tipoAbrangencia value
     * @return string|null
     */
    public function getTipoAbrangencia()
    {
        return $this->tipoAbrangencia;
    }
    /**
     * Set tipoAbrangencia value
     * @param string $tipoAbrangencia
     * @return \StructType\Sindicato
     */
    public function setTipoAbrangencia($tipoAbrangencia = null)
    {
        // validation for constraint: string
        if (!is_null($tipoAbrangencia) && !is_string($tipoAbrangencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoAbrangencia, true), gettype($tipoAbrangencia)), __LINE__);
        }
        $this->tipoAbrangencia = $tipoAbrangencia;
        return $this;
    }
    /**
     * Get presidente value
     * @return \StructType\PessoaFisica|null
     */
    public function getPresidente()
    {
        return $this->presidente;
    }
    /**
     * Set presidente value
     * @param \StructType\PessoaFisica $presidente
     * @return \StructType\Sindicato
     */
    public function setPresidente(\StructType\PessoaFisica $presidente = null)
    {
        $this->presidente = $presidente;
        return $this;
    }
    /**
     * Get cep value
     * @return string|null
     */
    public function getCep()
    {
        return $this->cep;
    }
    /**
     * Set cep value
     * @param string $cep
     * @return \StructType\Sindicato
     */
    public function setCep($cep = null)
    {
        // validation for constraint: string
        if (!is_null($cep) && !is_string($cep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cep, true), gettype($cep)), __LINE__);
        }
        $this->cep = $cep;
        return $this;
    }
    /**
     * Get uf value
     * @return string|null
     */
    public function getUf()
    {
        return $this->uf;
    }
    /**
     * Set uf value
     * @param string $uf
     * @return \StructType\Sindicato
     */
    public function setUf($uf = null)
    {
        // validation for constraint: string
        if (!is_null($uf) && !is_string($uf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uf, true), gettype($uf)), __LINE__);
        }
        $this->uf = $uf;
        return $this;
    }
    /**
     * Get municipio value
     * @return \StructType\Municipio|null
     */
    public function getMunicipio()
    {
        return $this->municipio;
    }
    /**
     * Set municipio value
     * @param \StructType\Municipio $municipio
     * @return \StructType\Sindicato
     */
    public function setMunicipio(\StructType\Municipio $municipio = null)
    {
        $this->municipio = $municipio;
        return $this;
    }
    /**
     * Get logradouro value
     * @return string|null
     */
    public function getLogradouro()
    {
        return $this->logradouro;
    }
    /**
     * Set logradouro value
     * @param string $logradouro
     * @return \StructType\Sindicato
     */
    public function setLogradouro($logradouro = null)
    {
        // validation for constraint: string
        if (!is_null($logradouro) && !is_string($logradouro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logradouro, true), gettype($logradouro)), __LINE__);
        }
        $this->logradouro = $logradouro;
        return $this;
    }
    /**
     * Get bairro value
     * @return string|null
     */
    public function getBairro()
    {
        return $this->bairro;
    }
    /**
     * Set bairro value
     * @param string $bairro
     * @return \StructType\Sindicato
     */
    public function setBairro($bairro = null)
    {
        // validation for constraint: string
        if (!is_null($bairro) && !is_string($bairro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bairro, true), gettype($bairro)), __LINE__);
        }
        $this->bairro = $bairro;
        return $this;
    }
    /**
     * Get ddd value
     * @return string|null
     */
    public function getDdd()
    {
        return $this->ddd;
    }
    /**
     * Set ddd value
     * @param string $ddd
     * @return \StructType\Sindicato
     */
    public function setDdd($ddd = null)
    {
        // validation for constraint: string
        if (!is_null($ddd) && !is_string($ddd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ddd, true), gettype($ddd)), __LINE__);
        }
        $this->ddd = $ddd;
        return $this;
    }
    /**
     * Get telefone value
     * @return string|null
     */
    public function getTelefone()
    {
        return $this->telefone;
    }
    /**
     * Set telefone value
     * @param string $telefone
     * @return \StructType\Sindicato
     */
    public function setTelefone($telefone = null)
    {
        // validation for constraint: string
        if (!is_null($telefone) && !is_string($telefone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefone, true), gettype($telefone)), __LINE__);
        }
        $this->telefone = $telefone;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\Sindicato
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Sindicato
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get homePage value
     * @return string|null
     */
    public function getHomePage()
    {
        return $this->homePage;
    }
    /**
     * Set homePage value
     * @param string $homePage
     * @return \StructType\Sindicato
     */
    public function setHomePage($homePage = null)
    {
        // validation for constraint: string
        if (!is_null($homePage) && !is_string($homePage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePage, true), gettype($homePage)), __LINE__);
        }
        $this->homePage = $homePage;
        return $this;
    }
    /**
     * Get contato value
     * @return \StructType\PessoaFisica|null
     */
    public function getContato()
    {
        return $this->contato;
    }
    /**
     * Set contato value
     * @param \StructType\PessoaFisica $contato
     * @return \StructType\Sindicato
     */
    public function setContato(\StructType\PessoaFisica $contato = null)
    {
        $this->contato = $contato;
        return $this;
    }
    /**
     * Get dataFundacao value
     * @return string|null
     */
    public function getDataFundacao()
    {
        return $this->dataFundacao;
    }
    /**
     * Set dataFundacao value
     * @param string $dataFundacao
     * @return \StructType\Sindicato
     */
    public function setDataFundacao($dataFundacao = null)
    {
        // validation for constraint: string
        if (!is_null($dataFundacao) && !is_string($dataFundacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataFundacao, true), gettype($dataFundacao)), __LINE__);
        }
        $this->dataFundacao = $dataFundacao;
        return $this;
    }
    /**
     * Get sedeSindicatoNacional value
     * @return string|null
     */
    public function getSedeSindicatoNacional()
    {
        return $this->sedeSindicatoNacional;
    }
    /**
     * Set sedeSindicatoNacional value
     * @param string $sedeSindicatoNacional
     * @return \StructType\Sindicato
     */
    public function setSedeSindicatoNacional($sedeSindicatoNacional = null)
    {
        // validation for constraint: string
        if (!is_null($sedeSindicatoNacional) && !is_string($sedeSindicatoNacional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sedeSindicatoNacional, true), gettype($sedeSindicatoNacional)), __LINE__);
        }
        $this->sedeSindicatoNacional = $sedeSindicatoNacional;
        return $this;
    }
}
