<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for findSindicatoByCnpj StructType
 * @subpackage Structs
 */
class FindSindicatoByCnpj extends AbstractStructBase
{
    /**
     * The cnpj
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cnpj;
    /**
     * The sistema
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Sistema
     */
    public $sistema;
    /**
     * Constructor method for findSindicatoByCnpj
     * @uses FindSindicatoByCnpj::setCnpj()
     * @uses FindSindicatoByCnpj::setSistema()
     * @param string $cnpj
     * @param \StructType\Sistema $sistema
     */
    public function __construct($cnpj = null, \StructType\Sistema $sistema = null)
    {
        $this
            ->setCnpj($cnpj)
            ->setSistema($sistema);
    }
    /**
     * Get cnpj value
     * @return string|null
     */
    public function getCnpj()
    {
        return $this->cnpj;
    }
    /**
     * Set cnpj value
     * @param string $cnpj
     * @return \StructType\FindSindicatoByCnpj
     */
    public function setCnpj($cnpj = null)
    {
        // validation for constraint: string
        if (!is_null($cnpj) && !is_string($cnpj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cnpj, true), gettype($cnpj)), __LINE__);
        }
        $this->cnpj = $cnpj;
        return $this;
    }
    /**
     * Get sistema value
     * @return \StructType\Sistema|null
     */
    public function getSistema()
    {
        return $this->sistema;
    }
    /**
     * Set sistema value
     * @param \StructType\Sistema $sistema
     * @return \StructType\FindSindicatoByCnpj
     */
    public function setSistema(\StructType\Sistema $sistema = null)
    {
        $this->sistema = $sistema;
        return $this;
    }
}
