<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for findContribuinteByCnpj StructType
 * @subpackage Structs
 */
class FindContribuinteByCnpj extends AbstractStructBase
{
    /**
     * The cnpj
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cnpj;
    /**
     * The escopo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $escopo;
    /**
     * The periodo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $periodo;
    /**
     * The exerciciosSindicais
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $exerciciosSindicais;
    /**
     * The sistema
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Sistema
     */
    public $sistema;
    /**
     * Constructor method for findContribuinteByCnpj
     * @uses FindContribuinteByCnpj::setCnpj()
     * @uses FindContribuinteByCnpj::setEscopo()
     * @uses FindContribuinteByCnpj::setPeriodo()
     * @uses FindContribuinteByCnpj::setExerciciosSindicais()
     * @uses FindContribuinteByCnpj::setSistema()
     * @param string $cnpj
     * @param string $escopo
     * @param string $periodo
     * @param string $exerciciosSindicais
     * @param \StructType\Sistema $sistema
     */
    public function __construct($cnpj = null, $escopo = null, $periodo = null, $exerciciosSindicais = null, \StructType\Sistema $sistema = null)
    {
        $this
            ->setCnpj($cnpj)
            ->setEscopo($escopo)
            ->setPeriodo($periodo)
            ->setExerciciosSindicais($exerciciosSindicais)
            ->setSistema($sistema);
    }
    /**
     * Get cnpj value
     * @return string|null
     */
    public function getCnpj()
    {
        return $this->cnpj;
    }
    /**
     * Set cnpj value
     * @param string $cnpj
     * @return \StructType\FindContribuinteByCnpj
     */
    public function setCnpj($cnpj = null)
    {
        // validation for constraint: string
        if (!is_null($cnpj) && !is_string($cnpj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cnpj, true), gettype($cnpj)), __LINE__);
        }
        $this->cnpj = $cnpj;
        return $this;
    }
    /**
     * Get escopo value
     * @return string|null
     */
    public function getEscopo()
    {
        return $this->escopo;
    }
    /**
     * Set escopo value
     * @param string $escopo
     * @return \StructType\FindContribuinteByCnpj
     */
    public function setEscopo($escopo = null)
    {
        // validation for constraint: string
        if (!is_null($escopo) && !is_string($escopo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($escopo, true), gettype($escopo)), __LINE__);
        }
        $this->escopo = $escopo;
        return $this;
    }
    /**
     * Get periodo value
     * @return string|null
     */
    public function getPeriodo()
    {
        return $this->periodo;
    }
    /**
     * Set periodo value
     * @param string $periodo
     * @return \StructType\FindContribuinteByCnpj
     */
    public function setPeriodo($periodo = null)
    {
        // validation for constraint: string
        if (!is_null($periodo) && !is_string($periodo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($periodo, true), gettype($periodo)), __LINE__);
        }
        $this->periodo = $periodo;
        return $this;
    }
    /**
     * Get exerciciosSindicais value
     * @return string|null
     */
    public function getExerciciosSindicais()
    {
        return $this->exerciciosSindicais;
    }
    /**
     * Set exerciciosSindicais value
     * @param string $exerciciosSindicais
     * @return \StructType\FindContribuinteByCnpj
     */
    public function setExerciciosSindicais($exerciciosSindicais = null)
    {
        // validation for constraint: string
        if (!is_null($exerciciosSindicais) && !is_string($exerciciosSindicais)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exerciciosSindicais, true), gettype($exerciciosSindicais)), __LINE__);
        }
        $this->exerciciosSindicais = $exerciciosSindicais;
        return $this;
    }
    /**
     * Get sistema value
     * @return \StructType\Sistema|null
     */
    public function getSistema()
    {
        return $this->sistema;
    }
    /**
     * Set sistema value
     * @param \StructType\Sistema $sistema
     * @return \StructType\FindContribuinteByCnpj
     */
    public function setSistema(\StructType\Sistema $sistema = null)
    {
        $this->sistema = $sistema;
        return $this;
    }
}
