<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Federacao StructType
 * @subpackage Structs
 */
class Federacao extends AbstractStructBase
{
    /**
     * The sigla
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sigla;
    /**
     * The nome
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nome;
    /**
     * The cnpj
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cnpj;
    /**
     * The presidente
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PessoaFisica
     */
    public $presidente;
    /**
     * The cep
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cep;
    /**
     * The municipio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Municipio
     */
    public $municipio;
    /**
     * The logradouro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $logradouro;
    /**
     * The bairro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bairro;
    /**
     * The uf
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $uf;
    /**
     * The homePage
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $homePage;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The principaisExecutivos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $principaisExecutivos;
    /**
     * The telefone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $telefone;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * Constructor method for Federacao
     * @uses Federacao::setSigla()
     * @uses Federacao::setNome()
     * @uses Federacao::setCnpj()
     * @uses Federacao::setPresidente()
     * @uses Federacao::setCep()
     * @uses Federacao::setMunicipio()
     * @uses Federacao::setLogradouro()
     * @uses Federacao::setBairro()
     * @uses Federacao::setUf()
     * @uses Federacao::setHomePage()
     * @uses Federacao::setEmail()
     * @uses Federacao::setPrincipaisExecutivos()
     * @uses Federacao::setTelefone()
     * @uses Federacao::setFax()
     * @param string $sigla
     * @param string $nome
     * @param string $cnpj
     * @param \StructType\PessoaFisica $presidente
     * @param string $cep
     * @param \StructType\Municipio $municipio
     * @param string $logradouro
     * @param string $bairro
     * @param string $uf
     * @param string $homePage
     * @param string $email
     * @param string $principaisExecutivos
     * @param string $telefone
     * @param string $fax
     */
    public function __construct($sigla = null, $nome = null, $cnpj = null, \StructType\PessoaFisica $presidente = null, $cep = null, \StructType\Municipio $municipio = null, $logradouro = null, $bairro = null, $uf = null, $homePage = null, $email = null, $principaisExecutivos = null, $telefone = null, $fax = null)
    {
        $this
            ->setSigla($sigla)
            ->setNome($nome)
            ->setCnpj($cnpj)
            ->setPresidente($presidente)
            ->setCep($cep)
            ->setMunicipio($municipio)
            ->setLogradouro($logradouro)
            ->setBairro($bairro)
            ->setUf($uf)
            ->setHomePage($homePage)
            ->setEmail($email)
            ->setPrincipaisExecutivos($principaisExecutivos)
            ->setTelefone($telefone)
            ->setFax($fax);
    }
    /**
     * Get sigla value
     * @return string|null
     */
    public function getSigla()
    {
        return $this->sigla;
    }
    /**
     * Set sigla value
     * @param string $sigla
     * @return \StructType\Federacao
     */
    public function setSigla($sigla = null)
    {
        // validation for constraint: string
        if (!is_null($sigla) && !is_string($sigla)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sigla, true), gettype($sigla)), __LINE__);
        }
        $this->sigla = $sigla;
        return $this;
    }
    /**
     * Get nome value
     * @return string|null
     */
    public function getNome()
    {
        return $this->nome;
    }
    /**
     * Set nome value
     * @param string $nome
     * @return \StructType\Federacao
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        $this->nome = $nome;
        return $this;
    }
    /**
     * Get cnpj value
     * @return string|null
     */
    public function getCnpj()
    {
        return $this->cnpj;
    }
    /**
     * Set cnpj value
     * @param string $cnpj
     * @return \StructType\Federacao
     */
    public function setCnpj($cnpj = null)
    {
        // validation for constraint: string
        if (!is_null($cnpj) && !is_string($cnpj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cnpj, true), gettype($cnpj)), __LINE__);
        }
        $this->cnpj = $cnpj;
        return $this;
    }
    /**
     * Get presidente value
     * @return \StructType\PessoaFisica|null
     */
    public function getPresidente()
    {
        return $this->presidente;
    }
    /**
     * Set presidente value
     * @param \StructType\PessoaFisica $presidente
     * @return \StructType\Federacao
     */
    public function setPresidente(\StructType\PessoaFisica $presidente = null)
    {
        $this->presidente = $presidente;
        return $this;
    }
    /**
     * Get cep value
     * @return string|null
     */
    public function getCep()
    {
        return $this->cep;
    }
    /**
     * Set cep value
     * @param string $cep
     * @return \StructType\Federacao
     */
    public function setCep($cep = null)
    {
        // validation for constraint: string
        if (!is_null($cep) && !is_string($cep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cep, true), gettype($cep)), __LINE__);
        }
        $this->cep = $cep;
        return $this;
    }
    /**
     * Get municipio value
     * @return \StructType\Municipio|null
     */
    public function getMunicipio()
    {
        return $this->municipio;
    }
    /**
     * Set municipio value
     * @param \StructType\Municipio $municipio
     * @return \StructType\Federacao
     */
    public function setMunicipio(\StructType\Municipio $municipio = null)
    {
        $this->municipio = $municipio;
        return $this;
    }
    /**
     * Get logradouro value
     * @return string|null
     */
    public function getLogradouro()
    {
        return $this->logradouro;
    }
    /**
     * Set logradouro value
     * @param string $logradouro
     * @return \StructType\Federacao
     */
    public function setLogradouro($logradouro = null)
    {
        // validation for constraint: string
        if (!is_null($logradouro) && !is_string($logradouro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logradouro, true), gettype($logradouro)), __LINE__);
        }
        $this->logradouro = $logradouro;
        return $this;
    }
    /**
     * Get bairro value
     * @return string|null
     */
    public function getBairro()
    {
        return $this->bairro;
    }
    /**
     * Set bairro value
     * @param string $bairro
     * @return \StructType\Federacao
     */
    public function setBairro($bairro = null)
    {
        // validation for constraint: string
        if (!is_null($bairro) && !is_string($bairro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bairro, true), gettype($bairro)), __LINE__);
        }
        $this->bairro = $bairro;
        return $this;
    }
    /**
     * Get uf value
     * @return string|null
     */
    public function getUf()
    {
        return $this->uf;
    }
    /**
     * Set uf value
     * @param string $uf
     * @return \StructType\Federacao
     */
    public function setUf($uf = null)
    {
        // validation for constraint: string
        if (!is_null($uf) && !is_string($uf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uf, true), gettype($uf)), __LINE__);
        }
        $this->uf = $uf;
        return $this;
    }
    /**
     * Get homePage value
     * @return string|null
     */
    public function getHomePage()
    {
        return $this->homePage;
    }
    /**
     * Set homePage value
     * @param string $homePage
     * @return \StructType\Federacao
     */
    public function setHomePage($homePage = null)
    {
        // validation for constraint: string
        if (!is_null($homePage) && !is_string($homePage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePage, true), gettype($homePage)), __LINE__);
        }
        $this->homePage = $homePage;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Federacao
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get principaisExecutivos value
     * @return string|null
     */
    public function getPrincipaisExecutivos()
    {
        return $this->principaisExecutivos;
    }
    /**
     * Set principaisExecutivos value
     * @param string $principaisExecutivos
     * @return \StructType\Federacao
     */
    public function setPrincipaisExecutivos($principaisExecutivos = null)
    {
        // validation for constraint: string
        if (!is_null($principaisExecutivos) && !is_string($principaisExecutivos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($principaisExecutivos, true), gettype($principaisExecutivos)), __LINE__);
        }
        $this->principaisExecutivos = $principaisExecutivos;
        return $this;
    }
    /**
     * Get telefone value
     * @return string|null
     */
    public function getTelefone()
    {
        return $this->telefone;
    }
    /**
     * Set telefone value
     * @param string $telefone
     * @return \StructType\Federacao
     */
    public function setTelefone($telefone = null)
    {
        // validation for constraint: string
        if (!is_null($telefone) && !is_string($telefone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefone, true), gettype($telefone)), __LINE__);
        }
        $this->telefone = $telefone;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\Federacao
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
}
