<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailSindicato StructType
 * @subpackage Structs
 */
class EmailSindicato extends AbstractStructBase
{
    /**
     * The descricao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $descricao;
    /**
     * The sindicato
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Sindicato
     */
    public $sindicato;
    /**
     * Constructor method for EmailSindicato
     * @uses EmailSindicato::setDescricao()
     * @uses EmailSindicato::setSindicato()
     * @param string $descricao
     * @param \StructType\Sindicato $sindicato
     */
    public function __construct($descricao = null, \StructType\Sindicato $sindicato = null)
    {
        $this
            ->setDescricao($descricao)
            ->setSindicato($sindicato);
    }
    /**
     * Get descricao value
     * @return string|null
     */
    public function getDescricao()
    {
        return $this->descricao;
    }
    /**
     * Set descricao value
     * @param string $descricao
     * @return \StructType\EmailSindicato
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricao, true), gettype($descricao)), __LINE__);
        }
        $this->descricao = $descricao;
        return $this;
    }
    /**
     * Get sindicato value
     * @return \StructType\Sindicato|null
     */
    public function getSindicato()
    {
        return $this->sindicato;
    }
    /**
     * Set sindicato value
     * @param \StructType\Sindicato $sindicato
     * @return \StructType\EmailSindicato
     */
    public function setSindicato(\StructType\Sindicato $sindicato = null)
    {
        $this->sindicato = $sindicato;
        return $this;
    }
}
