<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CadastroIndustrial StructType
 * @subpackage Structs
 */
class CadastroIndustrial extends AbstractStructBase
{
    /**
     * The nomeFantasia
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $nomeFantasia;
    /**
     * The situacaoReceita
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SituacaoReceita
     */
    public $situacaoReceita;
    /**
     * The periodoAbertura
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Periodo
     */
    public $periodoAbertura;
    /**
     * The faixaQuantidadeEmpregados
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $faixaQuantidadeEmpregados;
    /**
     * The faixaFaturamento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $faixaFaturamento;
    /**
     * The opcaoSimples
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OpcaoSimples
     */
    public $opcaoSimples;
    /**
     * The valorCapitalSocial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $valorCapitalSocial;
    /**
     * The situacaoSintegra
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SituacaoSintegra
     */
    public $situacaoSintegra;
    /**
     * The relacaoSocios
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $relacaoSocios;
    /**
     * The responsavel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PessoaFisica
     */
    public $responsavel;
    /**
     * The relacaoProdutos
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $relacaoProdutos;
    /**
     * The relacaoCamposVariaveis
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $relacaoCamposVariaveis;
    /**
     * The razaoSocial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $razaoSocial;
    /**
     * The logradouro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $logradouro;
    /**
     * The bairro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bairro;
    /**
     * The cep
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cep;
    /**
     * The uf
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $uf;
    /**
     * The municipio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Municipio
     */
    public $municipio;
    /**
     * The cnae
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Cnae
     */
    public $cnae;
    /**
     * The telefones
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $telefones;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The tipoIdentificador
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $tipoIdentificador;
    /**
     * The identificador
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $identificador;
    /**
     * The numeroInscricaoEstadual
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $numeroInscricaoEstadual;
    /**
     * The dataInscricaoEstadual
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataInscricaoEstadual;
    /**
     * The dataAbertura
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataAbertura;
    /**
     * The dataBaixa
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataBaixa;
    /**
     * Constructor method for CadastroIndustrial
     * @uses CadastroIndustrial::setNomeFantasia()
     * @uses CadastroIndustrial::setSituacaoReceita()
     * @uses CadastroIndustrial::setPeriodoAbertura()
     * @uses CadastroIndustrial::setFaixaQuantidadeEmpregados()
     * @uses CadastroIndustrial::setFaixaFaturamento()
     * @uses CadastroIndustrial::setOpcaoSimples()
     * @uses CadastroIndustrial::setValorCapitalSocial()
     * @uses CadastroIndustrial::setSituacaoSintegra()
     * @uses CadastroIndustrial::setRelacaoSocios()
     * @uses CadastroIndustrial::setResponsavel()
     * @uses CadastroIndustrial::setRelacaoProdutos()
     * @uses CadastroIndustrial::setRelacaoCamposVariaveis()
     * @uses CadastroIndustrial::setRazaoSocial()
     * @uses CadastroIndustrial::setLogradouro()
     * @uses CadastroIndustrial::setBairro()
     * @uses CadastroIndustrial::setCep()
     * @uses CadastroIndustrial::setUf()
     * @uses CadastroIndustrial::setMunicipio()
     * @uses CadastroIndustrial::setCnae()
     * @uses CadastroIndustrial::setTelefones()
     * @uses CadastroIndustrial::setEmail()
     * @uses CadastroIndustrial::setTipoIdentificador()
     * @uses CadastroIndustrial::setIdentificador()
     * @uses CadastroIndustrial::setNumeroInscricaoEstadual()
     * @uses CadastroIndustrial::setDataInscricaoEstadual()
     * @uses CadastroIndustrial::setDataAbertura()
     * @uses CadastroIndustrial::setDataBaixa()
     * @param string $nomeFantasia
     * @param \StructType\SituacaoReceita $situacaoReceita
     * @param \StructType\Periodo $periodoAbertura
     * @param string $faixaQuantidadeEmpregados
     * @param string $faixaFaturamento
     * @param \StructType\OpcaoSimples $opcaoSimples
     * @param string $valorCapitalSocial
     * @param \StructType\SituacaoSintegra $situacaoSintegra
     * @param string $relacaoSocios
     * @param \StructType\PessoaFisica $responsavel
     * @param string $relacaoProdutos
     * @param string $relacaoCamposVariaveis
     * @param string $razaoSocial
     * @param string $logradouro
     * @param string $bairro
     * @param string $cep
     * @param string $uf
     * @param \StructType\Municipio $municipio
     * @param \StructType\Cnae $cnae
     * @param string $telefones
     * @param string $email
     * @param string $tipoIdentificador
     * @param string $identificador
     * @param string $numeroInscricaoEstadual
     * @param string $dataInscricaoEstadual
     * @param string $dataAbertura
     * @param string $dataBaixa
     */
    public function __construct($nomeFantasia = null, \StructType\SituacaoReceita $situacaoReceita = null, \StructType\Periodo $periodoAbertura = null, $faixaQuantidadeEmpregados = null, $faixaFaturamento = null, \StructType\OpcaoSimples $opcaoSimples = null, $valorCapitalSocial = null, \StructType\SituacaoSintegra $situacaoSintegra = null, $relacaoSocios = null, \StructType\PessoaFisica $responsavel = null, $relacaoProdutos = null, $relacaoCamposVariaveis = null, $razaoSocial = null, $logradouro = null, $bairro = null, $cep = null, $uf = null, \StructType\Municipio $municipio = null, \StructType\Cnae $cnae = null, $telefones = null, $email = null, $tipoIdentificador = null, $identificador = null, $numeroInscricaoEstadual = null, $dataInscricaoEstadual = null, $dataAbertura = null, $dataBaixa = null)
    {
        $this
            ->setNomeFantasia($nomeFantasia)
            ->setSituacaoReceita($situacaoReceita)
            ->setPeriodoAbertura($periodoAbertura)
            ->setFaixaQuantidadeEmpregados($faixaQuantidadeEmpregados)
            ->setFaixaFaturamento($faixaFaturamento)
            ->setOpcaoSimples($opcaoSimples)
            ->setValorCapitalSocial($valorCapitalSocial)
            ->setSituacaoSintegra($situacaoSintegra)
            ->setRelacaoSocios($relacaoSocios)
            ->setResponsavel($responsavel)
            ->setRelacaoProdutos($relacaoProdutos)
            ->setRelacaoCamposVariaveis($relacaoCamposVariaveis)
            ->setRazaoSocial($razaoSocial)
            ->setLogradouro($logradouro)
            ->setBairro($bairro)
            ->setCep($cep)
            ->setUf($uf)
            ->setMunicipio($municipio)
            ->setCnae($cnae)
            ->setTelefones($telefones)
            ->setEmail($email)
            ->setTipoIdentificador($tipoIdentificador)
            ->setIdentificador($identificador)
            ->setNumeroInscricaoEstadual($numeroInscricaoEstadual)
            ->setDataInscricaoEstadual($dataInscricaoEstadual)
            ->setDataAbertura($dataAbertura)
            ->setDataBaixa($dataBaixa);
    }
    /**
     * Get nomeFantasia value
     * @return string|null
     */
    public function getNomeFantasia()
    {
        return $this->nomeFantasia;
    }
    /**
     * Set nomeFantasia value
     * @param string $nomeFantasia
     * @return \StructType\CadastroIndustrial
     */
    public function setNomeFantasia($nomeFantasia = null)
    {
        // validation for constraint: string
        if (!is_null($nomeFantasia) && !is_string($nomeFantasia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeFantasia, true), gettype($nomeFantasia)), __LINE__);
        }
        $this->nomeFantasia = $nomeFantasia;
        return $this;
    }
    /**
     * Get situacaoReceita value
     * @return \StructType\SituacaoReceita|null
     */
    public function getSituacaoReceita()
    {
        return $this->situacaoReceita;
    }
    /**
     * Set situacaoReceita value
     * @param \StructType\SituacaoReceita $situacaoReceita
     * @return \StructType\CadastroIndustrial
     */
    public function setSituacaoReceita(\StructType\SituacaoReceita $situacaoReceita = null)
    {
        $this->situacaoReceita = $situacaoReceita;
        return $this;
    }
    /**
     * Get periodoAbertura value
     * @return \StructType\Periodo|null
     */
    public function getPeriodoAbertura()
    {
        return $this->periodoAbertura;
    }
    /**
     * Set periodoAbertura value
     * @param \StructType\Periodo $periodoAbertura
     * @return \StructType\CadastroIndustrial
     */
    public function setPeriodoAbertura(\StructType\Periodo $periodoAbertura = null)
    {
        $this->periodoAbertura = $periodoAbertura;
        return $this;
    }
    /**
     * Get faixaQuantidadeEmpregados value
     * @return string|null
     */
    public function getFaixaQuantidadeEmpregados()
    {
        return $this->faixaQuantidadeEmpregados;
    }
    /**
     * Set faixaQuantidadeEmpregados value
     * @param string $faixaQuantidadeEmpregados
     * @return \StructType\CadastroIndustrial
     */
    public function setFaixaQuantidadeEmpregados($faixaQuantidadeEmpregados = null)
    {
        // validation for constraint: string
        if (!is_null($faixaQuantidadeEmpregados) && !is_string($faixaQuantidadeEmpregados)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faixaQuantidadeEmpregados, true), gettype($faixaQuantidadeEmpregados)), __LINE__);
        }
        $this->faixaQuantidadeEmpregados = $faixaQuantidadeEmpregados;
        return $this;
    }
    /**
     * Get faixaFaturamento value
     * @return string|null
     */
    public function getFaixaFaturamento()
    {
        return $this->faixaFaturamento;
    }
    /**
     * Set faixaFaturamento value
     * @param string $faixaFaturamento
     * @return \StructType\CadastroIndustrial
     */
    public function setFaixaFaturamento($faixaFaturamento = null)
    {
        // validation for constraint: string
        if (!is_null($faixaFaturamento) && !is_string($faixaFaturamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faixaFaturamento, true), gettype($faixaFaturamento)), __LINE__);
        }
        $this->faixaFaturamento = $faixaFaturamento;
        return $this;
    }
    /**
     * Get opcaoSimples value
     * @return \StructType\OpcaoSimples|null
     */
    public function getOpcaoSimples()
    {
        return $this->opcaoSimples;
    }
    /**
     * Set opcaoSimples value
     * @param \StructType\OpcaoSimples $opcaoSimples
     * @return \StructType\CadastroIndustrial
     */
    public function setOpcaoSimples(\StructType\OpcaoSimples $opcaoSimples = null)
    {
        $this->opcaoSimples = $opcaoSimples;
        return $this;
    }
    /**
     * Get valorCapitalSocial value
     * @return string|null
     */
    public function getValorCapitalSocial()
    {
        return $this->valorCapitalSocial;
    }
    /**
     * Set valorCapitalSocial value
     * @param string $valorCapitalSocial
     * @return \StructType\CadastroIndustrial
     */
    public function setValorCapitalSocial($valorCapitalSocial = null)
    {
        // validation for constraint: string
        if (!is_null($valorCapitalSocial) && !is_string($valorCapitalSocial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valorCapitalSocial, true), gettype($valorCapitalSocial)), __LINE__);
        }
        $this->valorCapitalSocial = $valorCapitalSocial;
        return $this;
    }
    /**
     * Get situacaoSintegra value
     * @return \StructType\SituacaoSintegra|null
     */
    public function getSituacaoSintegra()
    {
        return $this->situacaoSintegra;
    }
    /**
     * Set situacaoSintegra value
     * @param \StructType\SituacaoSintegra $situacaoSintegra
     * @return \StructType\CadastroIndustrial
     */
    public function setSituacaoSintegra(\StructType\SituacaoSintegra $situacaoSintegra = null)
    {
        $this->situacaoSintegra = $situacaoSintegra;
        return $this;
    }
    /**
     * Get relacaoSocios value
     * @return string|null
     */
    public function getRelacaoSocios()
    {
        return $this->relacaoSocios;
    }
    /**
     * Set relacaoSocios value
     * @param string $relacaoSocios
     * @return \StructType\CadastroIndustrial
     */
    public function setRelacaoSocios($relacaoSocios = null)
    {
        // validation for constraint: string
        if (!is_null($relacaoSocios) && !is_string($relacaoSocios)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relacaoSocios, true), gettype($relacaoSocios)), __LINE__);
        }
        $this->relacaoSocios = $relacaoSocios;
        return $this;
    }
    /**
     * Get responsavel value
     * @return \StructType\PessoaFisica|null
     */
    public function getResponsavel()
    {
        return $this->responsavel;
    }
    /**
     * Set responsavel value
     * @param \StructType\PessoaFisica $responsavel
     * @return \StructType\CadastroIndustrial
     */
    public function setResponsavel(\StructType\PessoaFisica $responsavel = null)
    {
        $this->responsavel = $responsavel;
        return $this;
    }
    /**
     * Get relacaoProdutos value
     * @return string|null
     */
    public function getRelacaoProdutos()
    {
        return $this->relacaoProdutos;
    }
    /**
     * Set relacaoProdutos value
     * @param string $relacaoProdutos
     * @return \StructType\CadastroIndustrial
     */
    public function setRelacaoProdutos($relacaoProdutos = null)
    {
        // validation for constraint: string
        if (!is_null($relacaoProdutos) && !is_string($relacaoProdutos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relacaoProdutos, true), gettype($relacaoProdutos)), __LINE__);
        }
        $this->relacaoProdutos = $relacaoProdutos;
        return $this;
    }
    /**
     * Get relacaoCamposVariaveis value
     * @return string|null
     */
    public function getRelacaoCamposVariaveis()
    {
        return $this->relacaoCamposVariaveis;
    }
    /**
     * Set relacaoCamposVariaveis value
     * @param string $relacaoCamposVariaveis
     * @return \StructType\CadastroIndustrial
     */
    public function setRelacaoCamposVariaveis($relacaoCamposVariaveis = null)
    {
        // validation for constraint: string
        if (!is_null($relacaoCamposVariaveis) && !is_string($relacaoCamposVariaveis)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relacaoCamposVariaveis, true), gettype($relacaoCamposVariaveis)), __LINE__);
        }
        $this->relacaoCamposVariaveis = $relacaoCamposVariaveis;
        return $this;
    }
    /**
     * Get razaoSocial value
     * @return string|null
     */
    public function getRazaoSocial()
    {
        return $this->razaoSocial;
    }
    /**
     * Set razaoSocial value
     * @param string $razaoSocial
     * @return \StructType\CadastroIndustrial
     */
    public function setRazaoSocial($razaoSocial = null)
    {
        // validation for constraint: string
        if (!is_null($razaoSocial) && !is_string($razaoSocial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($razaoSocial, true), gettype($razaoSocial)), __LINE__);
        }
        $this->razaoSocial = $razaoSocial;
        return $this;
    }
    /**
     * Get logradouro value
     * @return string|null
     */
    public function getLogradouro()
    {
        return $this->logradouro;
    }
    /**
     * Set logradouro value
     * @param string $logradouro
     * @return \StructType\CadastroIndustrial
     */
    public function setLogradouro($logradouro = null)
    {
        // validation for constraint: string
        if (!is_null($logradouro) && !is_string($logradouro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logradouro, true), gettype($logradouro)), __LINE__);
        }
        $this->logradouro = $logradouro;
        return $this;
    }
    /**
     * Get bairro value
     * @return string|null
     */
    public function getBairro()
    {
        return $this->bairro;
    }
    /**
     * Set bairro value
     * @param string $bairro
     * @return \StructType\CadastroIndustrial
     */
    public function setBairro($bairro = null)
    {
        // validation for constraint: string
        if (!is_null($bairro) && !is_string($bairro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bairro, true), gettype($bairro)), __LINE__);
        }
        $this->bairro = $bairro;
        return $this;
    }
    /**
     * Get cep value
     * @return string|null
     */
    public function getCep()
    {
        return $this->cep;
    }
    /**
     * Set cep value
     * @param string $cep
     * @return \StructType\CadastroIndustrial
     */
    public function setCep($cep = null)
    {
        // validation for constraint: string
        if (!is_null($cep) && !is_string($cep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cep, true), gettype($cep)), __LINE__);
        }
        $this->cep = $cep;
        return $this;
    }
    /**
     * Get uf value
     * @return string|null
     */
    public function getUf()
    {
        return $this->uf;
    }
    /**
     * Set uf value
     * @param string $uf
     * @return \StructType\CadastroIndustrial
     */
    public function setUf($uf = null)
    {
        // validation for constraint: string
        if (!is_null($uf) && !is_string($uf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uf, true), gettype($uf)), __LINE__);
        }
        $this->uf = $uf;
        return $this;
    }
    /**
     * Get municipio value
     * @return \StructType\Municipio|null
     */
    public function getMunicipio()
    {
        return $this->municipio;
    }
    /**
     * Set municipio value
     * @param \StructType\Municipio $municipio
     * @return \StructType\CadastroIndustrial
     */
    public function setMunicipio(\StructType\Municipio $municipio = null)
    {
        $this->municipio = $municipio;
        return $this;
    }
    /**
     * Get cnae value
     * @return \StructType\Cnae|null
     */
    public function getCnae()
    {
        return $this->cnae;
    }
    /**
     * Set cnae value
     * @param \StructType\Cnae $cnae
     * @return \StructType\CadastroIndustrial
     */
    public function setCnae(\StructType\Cnae $cnae = null)
    {
        $this->cnae = $cnae;
        return $this;
    }
    /**
     * Get telefones value
     * @return string|null
     */
    public function getTelefones()
    {
        return $this->telefones;
    }
    /**
     * Set telefones value
     * @param string $telefones
     * @return \StructType\CadastroIndustrial
     */
    public function setTelefones($telefones = null)
    {
        // validation for constraint: string
        if (!is_null($telefones) && !is_string($telefones)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefones, true), gettype($telefones)), __LINE__);
        }
        $this->telefones = $telefones;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\CadastroIndustrial
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get tipoIdentificador value
     * @return string|null
     */
    public function getTipoIdentificador()
    {
        return $this->tipoIdentificador;
    }
    /**
     * Set tipoIdentificador value
     * @param string $tipoIdentificador
     * @return \StructType\CadastroIndustrial
     */
    public function setTipoIdentificador($tipoIdentificador = null)
    {
        // validation for constraint: string
        if (!is_null($tipoIdentificador) && !is_string($tipoIdentificador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoIdentificador, true), gettype($tipoIdentificador)), __LINE__);
        }
        $this->tipoIdentificador = $tipoIdentificador;
        return $this;
    }
    /**
     * Get identificador value
     * @return string|null
     */
    public function getIdentificador()
    {
        return $this->identificador;
    }
    /**
     * Set identificador value
     * @param string $identificador
     * @return \StructType\CadastroIndustrial
     */
    public function setIdentificador($identificador = null)
    {
        // validation for constraint: string
        if (!is_null($identificador) && !is_string($identificador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificador, true), gettype($identificador)), __LINE__);
        }
        $this->identificador = $identificador;
        return $this;
    }
    /**
     * Get numeroInscricaoEstadual value
     * @return string|null
     */
    public function getNumeroInscricaoEstadual()
    {
        return $this->numeroInscricaoEstadual;
    }
    /**
     * Set numeroInscricaoEstadual value
     * @param string $numeroInscricaoEstadual
     * @return \StructType\CadastroIndustrial
     */
    public function setNumeroInscricaoEstadual($numeroInscricaoEstadual = null)
    {
        // validation for constraint: string
        if (!is_null($numeroInscricaoEstadual) && !is_string($numeroInscricaoEstadual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($numeroInscricaoEstadual, true), gettype($numeroInscricaoEstadual)), __LINE__);
        }
        $this->numeroInscricaoEstadual = $numeroInscricaoEstadual;
        return $this;
    }
    /**
     * Get dataInscricaoEstadual value
     * @return string|null
     */
    public function getDataInscricaoEstadual()
    {
        return $this->dataInscricaoEstadual;
    }
    /**
     * Set dataInscricaoEstadual value
     * @param string $dataInscricaoEstadual
     * @return \StructType\CadastroIndustrial
     */
    public function setDataInscricaoEstadual($dataInscricaoEstadual = null)
    {
        // validation for constraint: string
        if (!is_null($dataInscricaoEstadual) && !is_string($dataInscricaoEstadual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataInscricaoEstadual, true), gettype($dataInscricaoEstadual)), __LINE__);
        }
        $this->dataInscricaoEstadual = $dataInscricaoEstadual;
        return $this;
    }
    /**
     * Get dataAbertura value
     * @return string|null
     */
    public function getDataAbertura()
    {
        return $this->dataAbertura;
    }
    /**
     * Set dataAbertura value
     * @param string $dataAbertura
     * @return \StructType\CadastroIndustrial
     */
    public function setDataAbertura($dataAbertura = null)
    {
        // validation for constraint: string
        if (!is_null($dataAbertura) && !is_string($dataAbertura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataAbertura, true), gettype($dataAbertura)), __LINE__);
        }
        $this->dataAbertura = $dataAbertura;
        return $this;
    }
    /**
     * Get dataBaixa value
     * @return string|null
     */
    public function getDataBaixa()
    {
        return $this->dataBaixa;
    }
    /**
     * Set dataBaixa value
     * @param string $dataBaixa
     * @return \StructType\CadastroIndustrial
     */
    public function setDataBaixa($dataBaixa = null)
    {
        // validation for constraint: string
        if (!is_null($dataBaixa) && !is_string($dataBaixa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataBaixa, true), gettype($dataBaixa)), __LINE__);
        }
        $this->dataBaixa = $dataBaixa;
        return $this;
    }
}
