<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://app.sistemaindustria.com.br/Minerva/services.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://app.sistemaindustria.com.br/Minerva/services.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Find ServiceType
 */
$find = new \ServiceType\Find($options);
/**
 * Sample call for findSindicatoByCnpj operation/method
 */
if ($find->findSindicatoByCnpj(new \StructType\FindSindicatoByCnpj()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findCadastroIndustrialByCeiAndFederacaoFromUf operation/method
 */
if ($find->findCadastroIndustrialByCeiAndFederacaoFromUf(new \StructType\FindCadastroIndustrialByCeiAndFederacaoFromUf()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findContribuintesSindicaisBySindicatosFromUf operation/method
 */
if ($find->findContribuintesSindicaisBySindicatosFromUf(new \StructType\FindContribuintesSindicaisBySindicatosFromUf()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findEmailsSindicatoByUf operation/method
 */
if ($find->findEmailsSindicatoByUf(new \StructType\FindEmailsSindicatoByUf()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findContribuinteByCei operation/method
 */
if ($find->findContribuinteByCei(new \StructType\FindContribuinteByCei()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findCadastrosIndustriaisByFederacaoFromUf operation/method
 */
if ($find->findCadastrosIndustriaisByFederacaoFromUf(new \StructType\FindCadastrosIndustriaisByFederacaoFromUf()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findFederacaoByUf operation/method
 */
if ($find->findFederacaoByUf(new \StructType\FindFederacaoByUf()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findEmailsSindicatoAndSociosByUf operation/method
 */
if ($find->findEmailsSindicatoAndSociosByUf(new \StructType\FindEmailsSindicatoAndSociosByUf()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findEmailsSindicatoByCodigo operation/method
 */
if ($find->findEmailsSindicatoByCodigo(new \StructType\FindEmailsSindicatoByCodigo()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findSindicatoByCodigo operation/method
 */
if ($find->findSindicatoByCodigo(new \StructType\FindSindicatoByCodigo()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findEmailsSindicatoAndSociosByCodigo operation/method
 */
if ($find->findEmailsSindicatoAndSociosByCodigo(new \StructType\FindEmailsSindicatoAndSociosByCodigo()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findEstabelecimentoByCei operation/method
 */
if ($find->findEstabelecimentoByCei(new \StructType\FindEstabelecimentoByCei()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findEstabelecimentoByCnpj operation/method
 */
if ($find->findEstabelecimentoByCnpj(new \StructType\FindEstabelecimentoByCnpj()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findContribuintesSindicaisBySindicato operation/method
 */
if ($find->findContribuintesSindicaisBySindicato(new \StructType\FindContribuintesSindicaisBySindicato()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findContribuinteByCnpj operation/method
 */
if ($find->findContribuinteByCnpj(new \StructType\FindContribuinteByCnpj()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findContribuinteSindicalByCnpjAndSindicato operation/method
 */
if ($find->findContribuinteSindicalByCnpjAndSindicato(new \StructType\FindContribuinteSindicalByCnpjAndSindicato()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findCadastroIndustrialByCnpjAndFederacaoFromUf operation/method
 */
if ($find->findCadastroIndustrialByCnpjAndFederacaoFromUf(new \StructType\FindCadastroIndustrialByCnpjAndFederacaoFromUf()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
/**
 * Sample call for findSindicatosByUf operation/method
 */
if ($find->findSindicatosByUf(new \StructType\FindSindicatosByUf()) !== false) {
    print_r($find->getResult());
} else {
    print_r($find->getLastError());
}
