<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Sistema StructType
 * @subpackage Structs
 */
class Sistema extends AbstractStructBase
{
    /**
     * The Codigo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Codigo;
    /**
     * The Senha
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Senha;
    /**
     * Constructor method for Sistema
     * @uses Sistema::setCodigo()
     * @uses Sistema::setSenha()
     * @param string $codigo
     * @param string $senha
     */
    public function __construct($codigo = null, $senha = null)
    {
        $this
            ->setCodigo($codigo)
            ->setSenha($senha);
    }
    /**
     * Get Codigo value
     * @return string|null
     */
    public function getCodigo()
    {
        return $this->Codigo;
    }
    /**
     * Set Codigo value
     * @param string $codigo
     * @return \StructType\Sistema
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: string
        if (!is_null($codigo) && !is_string($codigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->Codigo = $codigo;
        return $this;
    }
    /**
     * Get Senha value
     * @return string|null
     */
    public function getSenha()
    {
        return $this->Senha;
    }
    /**
     * Set Senha value
     * @param string $senha
     * @return \StructType\Sistema
     */
    public function setSenha($senha = null)
    {
        // validation for constraint: string
        if (!is_null($senha) && !is_string($senha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senha, true), gettype($senha)), __LINE__);
        }
        $this->Senha = $senha;
        return $this;
    }
}
