<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OpcaoSimples StructType
 * @subpackage Structs
 */
class OpcaoSimples extends AbstractStructBase
{
    /**
     * The indicator
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $indicator;
    /**
     * The data
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $data;
    /**
     * The dataCancelamento
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataCancelamento;
    /**
     * Constructor method for OpcaoSimples
     * @uses OpcaoSimples::setIndicator()
     * @uses OpcaoSimples::setData()
     * @uses OpcaoSimples::setDataCancelamento()
     * @param string $indicator
     * @param string $data
     * @param string $dataCancelamento
     */
    public function __construct($indicator = null, $data = null, $dataCancelamento = null)
    {
        $this
            ->setIndicator($indicator)
            ->setData($data)
            ->setDataCancelamento($dataCancelamento);
    }
    /**
     * Get indicator value
     * @return string|null
     */
    public function getIndicator()
    {
        return $this->indicator;
    }
    /**
     * Set indicator value
     * @param string $indicator
     * @return \StructType\OpcaoSimples
     */
    public function setIndicator($indicator = null)
    {
        // validation for constraint: string
        if (!is_null($indicator) && !is_string($indicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indicator, true), gettype($indicator)), __LINE__);
        }
        $this->indicator = $indicator;
        return $this;
    }
    /**
     * Get data value
     * @return string|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param string $data
     * @return \StructType\OpcaoSimples
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        $this->data = $data;
        return $this;
    }
    /**
     * Get dataCancelamento value
     * @return string|null
     */
    public function getDataCancelamento()
    {
        return $this->dataCancelamento;
    }
    /**
     * Set dataCancelamento value
     * @param string $dataCancelamento
     * @return \StructType\OpcaoSimples
     */
    public function setDataCancelamento($dataCancelamento = null)
    {
        // validation for constraint: string
        if (!is_null($dataCancelamento) && !is_string($dataCancelamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataCancelamento, true), gettype($dataCancelamento)), __LINE__);
        }
        $this->dataCancelamento = $dataCancelamento;
        return $this;
    }
}
