<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for findContribuinteSindicalByCnpjAndSindicato StructType
 * @subpackage Structs
 */
class FindContribuinteSindicalByCnpjAndSindicato extends AbstractStructBase
{
    /**
     * The cnpj
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cnpj;
    /**
     * The sindicato
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $sindicato;
    /**
     * The sistema
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Sistema
     */
    public $sistema;
    /**
     * Constructor method for findContribuinteSindicalByCnpjAndSindicato
     * @uses FindContribuinteSindicalByCnpjAndSindicato::setCnpj()
     * @uses FindContribuinteSindicalByCnpjAndSindicato::setSindicato()
     * @uses FindContribuinteSindicalByCnpjAndSindicato::setSistema()
     * @param string $cnpj
     * @param string $sindicato
     * @param \StructType\Sistema $sistema
     */
    public function __construct($cnpj = null, $sindicato = null, \StructType\Sistema $sistema = null)
    {
        $this
            ->setCnpj($cnpj)
            ->setSindicato($sindicato)
            ->setSistema($sistema);
    }
    /**
     * Get cnpj value
     * @return string|null
     */
    public function getCnpj()
    {
        return $this->cnpj;
    }
    /**
     * Set cnpj value
     * @param string $cnpj
     * @return \StructType\FindContribuinteSindicalByCnpjAndSindicato
     */
    public function setCnpj($cnpj = null)
    {
        // validation for constraint: string
        if (!is_null($cnpj) && !is_string($cnpj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cnpj, true), gettype($cnpj)), __LINE__);
        }
        $this->cnpj = $cnpj;
        return $this;
    }
    /**
     * Get sindicato value
     * @return string|null
     */
    public function getSindicato()
    {
        return $this->sindicato;
    }
    /**
     * Set sindicato value
     * @param string $sindicato
     * @return \StructType\FindContribuinteSindicalByCnpjAndSindicato
     */
    public function setSindicato($sindicato = null)
    {
        // validation for constraint: string
        if (!is_null($sindicato) && !is_string($sindicato)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sindicato, true), gettype($sindicato)), __LINE__);
        }
        $this->sindicato = $sindicato;
        return $this;
    }
    /**
     * Get sistema value
     * @return \StructType\Sistema|null
     */
    public function getSistema()
    {
        return $this->sistema;
    }
    /**
     * Set sistema value
     * @param \StructType\Sistema $sistema
     * @return \StructType\FindContribuinteSindicalByCnpjAndSindicato
     */
    public function setSistema(\StructType\Sistema $sistema = null)
    {
        $this->sistema = $sistema;
        return $this;
    }
}
