<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for findCadastroIndustrialByCnpjAndFederacaoFromUf StructType
 * @subpackage Structs
 */
class FindCadastroIndustrialByCnpjAndFederacaoFromUf extends AbstractStructBase
{
    /**
     * The cnpj
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cnpj;
    /**
     * The federacao
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $federacao;
    /**
     * The sistema
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Sistema
     */
    public $sistema;
    /**
     * Constructor method for findCadastroIndustrialByCnpjAndFederacaoFromUf
     * @uses FindCadastroIndustrialByCnpjAndFederacaoFromUf::setCnpj()
     * @uses FindCadastroIndustrialByCnpjAndFederacaoFromUf::setFederacao()
     * @uses FindCadastroIndustrialByCnpjAndFederacaoFromUf::setSistema()
     * @param string $cnpj
     * @param string $federacao
     * @param \StructType\Sistema $sistema
     */
    public function __construct($cnpj = null, $federacao = null, \StructType\Sistema $sistema = null)
    {
        $this
            ->setCnpj($cnpj)
            ->setFederacao($federacao)
            ->setSistema($sistema);
    }
    /**
     * Get cnpj value
     * @return string|null
     */
    public function getCnpj()
    {
        return $this->cnpj;
    }
    /**
     * Set cnpj value
     * @param string $cnpj
     * @return \StructType\FindCadastroIndustrialByCnpjAndFederacaoFromUf
     */
    public function setCnpj($cnpj = null)
    {
        // validation for constraint: string
        if (!is_null($cnpj) && !is_string($cnpj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cnpj, true), gettype($cnpj)), __LINE__);
        }
        $this->cnpj = $cnpj;
        return $this;
    }
    /**
     * Get federacao value
     * @return string|null
     */
    public function getFederacao()
    {
        return $this->federacao;
    }
    /**
     * Set federacao value
     * @param string $federacao
     * @return \StructType\FindCadastroIndustrialByCnpjAndFederacaoFromUf
     */
    public function setFederacao($federacao = null)
    {
        // validation for constraint: string
        if (!is_null($federacao) && !is_string($federacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($federacao, true), gettype($federacao)), __LINE__);
        }
        $this->federacao = $federacao;
        return $this;
    }
    /**
     * Get sistema value
     * @return \StructType\Sistema|null
     */
    public function getSistema()
    {
        return $this->sistema;
    }
    /**
     * Set sistema value
     * @param \StructType\Sistema $sistema
     * @return \StructType\FindCadastroIndustrialByCnpjAndFederacaoFromUf
     */
    public function setSistema(\StructType\Sistema $sistema = null)
    {
        $this->sistema = $sistema;
        return $this;
    }
}
