<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Estabelecimento StructType
 * @subpackage Structs
 */
class Estabelecimento extends AbstractStructBase
{
    /**
     * The porteEmpresa
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $porteEmpresa;
    /**
     * The quantidadeEmpregados
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $quantidadeEmpregados;
    /**
     * The indicaOrigem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $indicaOrigem;
    /**
     * The cnpj
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cnpj;
    /**
     * The cei
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cei;
    /**
     * The razaoSocial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $razaoSocial;
    /**
     * The logradouro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $logradouro;
    /**
     * The bairro
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $bairro;
    /**
     * The cep
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cep;
    /**
     * The uf
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $uf;
    /**
     * The municipio
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Municipio
     */
    public $municipio;
    /**
     * The cnae
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Cnae
     */
    public $cnae;
    /**
     * The indicaIndustriaCnae
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $indicaIndustriaCnae;
    /**
     * The indicaIndustriaFpas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $indicaIndustriaFpas;
    /**
     * The indicaOptanteSimples
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $indicaOptanteSimples;
    /**
     * The descricaoPorteEmpresa
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $descricaoPorteEmpresa;
    /**
     * The ddd
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ddd;
    /**
     * The telefone
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $telefone;
    /**
     * The ramal
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ramal;
    /**
     * The fax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $fax;
    /**
     * The email
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $email;
    /**
     * The situacaoRFB
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $situacaoRFB;
    /**
     * The dataAbertura
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataAbertura;
    /**
     * The dataBaixa
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataBaixa;
    /**
     * The situacaoACARC
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $situacaoACARC;
    /**
     * The dataSituacaoCadastral
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dataSituacaoCadastral;
    /**
     * The cnpjVinculado
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cnpjVinculado;
    /**
     * The ultimoProcessamentoFonteExterna
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ultimoProcessamentoFonteExterna;
    /**
     * The indicaContribuinteSindical
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $indicaContribuinteSindical;
    /**
     * The indicaContribuinteConfederativa
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $indicaContribuinteConfederativa;
    /**
     * The indicaContribuinteAssociativa
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $indicaContribuinteAssociativa;
    /**
     * The indicaContribuinteAssistencial
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $indicaContribuinteAssistencial;
    /**
     * The indicaContribuinteOutrasReceitas
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $indicaContribuinteOutrasReceitas;
    /**
     * The exerciciosSindicais
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $exerciciosSindicais;
    /**
     * The convenioAtivoSENAI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $convenioAtivoSENAI;
    /**
     * The convenioAtivoSESI
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $convenioAtivoSESI;
    /**
     * Constructor method for Estabelecimento
     * @uses Estabelecimento::setPorteEmpresa()
     * @uses Estabelecimento::setQuantidadeEmpregados()
     * @uses Estabelecimento::setIndicaOrigem()
     * @uses Estabelecimento::setCnpj()
     * @uses Estabelecimento::setCei()
     * @uses Estabelecimento::setRazaoSocial()
     * @uses Estabelecimento::setLogradouro()
     * @uses Estabelecimento::setBairro()
     * @uses Estabelecimento::setCep()
     * @uses Estabelecimento::setUf()
     * @uses Estabelecimento::setMunicipio()
     * @uses Estabelecimento::setCnae()
     * @uses Estabelecimento::setIndicaIndustriaCnae()
     * @uses Estabelecimento::setIndicaIndustriaFpas()
     * @uses Estabelecimento::setIndicaOptanteSimples()
     * @uses Estabelecimento::setDescricaoPorteEmpresa()
     * @uses Estabelecimento::setDdd()
     * @uses Estabelecimento::setTelefone()
     * @uses Estabelecimento::setRamal()
     * @uses Estabelecimento::setFax()
     * @uses Estabelecimento::setEmail()
     * @uses Estabelecimento::setSituacaoRFB()
     * @uses Estabelecimento::setDataAbertura()
     * @uses Estabelecimento::setDataBaixa()
     * @uses Estabelecimento::setSituacaoACARC()
     * @uses Estabelecimento::setDataSituacaoCadastral()
     * @uses Estabelecimento::setCnpjVinculado()
     * @uses Estabelecimento::setUltimoProcessamentoFonteExterna()
     * @uses Estabelecimento::setIndicaContribuinteSindical()
     * @uses Estabelecimento::setIndicaContribuinteConfederativa()
     * @uses Estabelecimento::setIndicaContribuinteAssociativa()
     * @uses Estabelecimento::setIndicaContribuinteAssistencial()
     * @uses Estabelecimento::setIndicaContribuinteOutrasReceitas()
     * @uses Estabelecimento::setExerciciosSindicais()
     * @uses Estabelecimento::setConvenioAtivoSENAI()
     * @uses Estabelecimento::setConvenioAtivoSESI()
     * @param int $porteEmpresa
     * @param int $quantidadeEmpregados
     * @param int $indicaOrigem
     * @param string $cnpj
     * @param string $cei
     * @param string $razaoSocial
     * @param string $logradouro
     * @param string $bairro
     * @param string $cep
     * @param string $uf
     * @param \StructType\Municipio $municipio
     * @param \StructType\Cnae $cnae
     * @param string $indicaIndustriaCnae
     * @param string $indicaIndustriaFpas
     * @param string $indicaOptanteSimples
     * @param string $descricaoPorteEmpresa
     * @param string $ddd
     * @param string $telefone
     * @param string $ramal
     * @param string $fax
     * @param string $email
     * @param string $situacaoRFB
     * @param string $dataAbertura
     * @param string $dataBaixa
     * @param string $situacaoACARC
     * @param string $dataSituacaoCadastral
     * @param string $cnpjVinculado
     * @param string $ultimoProcessamentoFonteExterna
     * @param string $indicaContribuinteSindical
     * @param string $indicaContribuinteConfederativa
     * @param string $indicaContribuinteAssociativa
     * @param string $indicaContribuinteAssistencial
     * @param string $indicaContribuinteOutrasReceitas
     * @param string $exerciciosSindicais
     * @param string $convenioAtivoSENAI
     * @param string $convenioAtivoSESI
     */
    public function __construct($porteEmpresa = null, $quantidadeEmpregados = null, $indicaOrigem = null, $cnpj = null, $cei = null, $razaoSocial = null, $logradouro = null, $bairro = null, $cep = null, $uf = null, \StructType\Municipio $municipio = null, \StructType\Cnae $cnae = null, $indicaIndustriaCnae = null, $indicaIndustriaFpas = null, $indicaOptanteSimples = null, $descricaoPorteEmpresa = null, $ddd = null, $telefone = null, $ramal = null, $fax = null, $email = null, $situacaoRFB = null, $dataAbertura = null, $dataBaixa = null, $situacaoACARC = null, $dataSituacaoCadastral = null, $cnpjVinculado = null, $ultimoProcessamentoFonteExterna = null, $indicaContribuinteSindical = null, $indicaContribuinteConfederativa = null, $indicaContribuinteAssociativa = null, $indicaContribuinteAssistencial = null, $indicaContribuinteOutrasReceitas = null, $exerciciosSindicais = null, $convenioAtivoSENAI = null, $convenioAtivoSESI = null)
    {
        $this
            ->setPorteEmpresa($porteEmpresa)
            ->setQuantidadeEmpregados($quantidadeEmpregados)
            ->setIndicaOrigem($indicaOrigem)
            ->setCnpj($cnpj)
            ->setCei($cei)
            ->setRazaoSocial($razaoSocial)
            ->setLogradouro($logradouro)
            ->setBairro($bairro)
            ->setCep($cep)
            ->setUf($uf)
            ->setMunicipio($municipio)
            ->setCnae($cnae)
            ->setIndicaIndustriaCnae($indicaIndustriaCnae)
            ->setIndicaIndustriaFpas($indicaIndustriaFpas)
            ->setIndicaOptanteSimples($indicaOptanteSimples)
            ->setDescricaoPorteEmpresa($descricaoPorteEmpresa)
            ->setDdd($ddd)
            ->setTelefone($telefone)
            ->setRamal($ramal)
            ->setFax($fax)
            ->setEmail($email)
            ->setSituacaoRFB($situacaoRFB)
            ->setDataAbertura($dataAbertura)
            ->setDataBaixa($dataBaixa)
            ->setSituacaoACARC($situacaoACARC)
            ->setDataSituacaoCadastral($dataSituacaoCadastral)
            ->setCnpjVinculado($cnpjVinculado)
            ->setUltimoProcessamentoFonteExterna($ultimoProcessamentoFonteExterna)
            ->setIndicaContribuinteSindical($indicaContribuinteSindical)
            ->setIndicaContribuinteConfederativa($indicaContribuinteConfederativa)
            ->setIndicaContribuinteAssociativa($indicaContribuinteAssociativa)
            ->setIndicaContribuinteAssistencial($indicaContribuinteAssistencial)
            ->setIndicaContribuinteOutrasReceitas($indicaContribuinteOutrasReceitas)
            ->setExerciciosSindicais($exerciciosSindicais)
            ->setConvenioAtivoSENAI($convenioAtivoSENAI)
            ->setConvenioAtivoSESI($convenioAtivoSESI);
    }
    /**
     * Get porteEmpresa value
     * @return int
     */
    public function getPorteEmpresa()
    {
        return $this->porteEmpresa;
    }
    /**
     * Set porteEmpresa value
     * @param int $porteEmpresa
     * @return \StructType\Estabelecimento
     */
    public function setPorteEmpresa($porteEmpresa = null)
    {
        // validation for constraint: int
        if (!is_null($porteEmpresa) && !(is_int($porteEmpresa) || ctype_digit($porteEmpresa))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($porteEmpresa, true), gettype($porteEmpresa)), __LINE__);
        }
        $this->porteEmpresa = $porteEmpresa;
        return $this;
    }
    /**
     * Get quantidadeEmpregados value
     * @return int
     */
    public function getQuantidadeEmpregados()
    {
        return $this->quantidadeEmpregados;
    }
    /**
     * Set quantidadeEmpregados value
     * @param int $quantidadeEmpregados
     * @return \StructType\Estabelecimento
     */
    public function setQuantidadeEmpregados($quantidadeEmpregados = null)
    {
        // validation for constraint: int
        if (!is_null($quantidadeEmpregados) && !(is_int($quantidadeEmpregados) || ctype_digit($quantidadeEmpregados))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantidadeEmpregados, true), gettype($quantidadeEmpregados)), __LINE__);
        }
        $this->quantidadeEmpregados = $quantidadeEmpregados;
        return $this;
    }
    /**
     * Get indicaOrigem value
     * @return int
     */
    public function getIndicaOrigem()
    {
        return $this->indicaOrigem;
    }
    /**
     * Set indicaOrigem value
     * @param int $indicaOrigem
     * @return \StructType\Estabelecimento
     */
    public function setIndicaOrigem($indicaOrigem = null)
    {
        // validation for constraint: int
        if (!is_null($indicaOrigem) && !(is_int($indicaOrigem) || ctype_digit($indicaOrigem))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($indicaOrigem, true), gettype($indicaOrigem)), __LINE__);
        }
        $this->indicaOrigem = $indicaOrigem;
        return $this;
    }
    /**
     * Get cnpj value
     * @return string|null
     */
    public function getCnpj()
    {
        return $this->cnpj;
    }
    /**
     * Set cnpj value
     * @param string $cnpj
     * @return \StructType\Estabelecimento
     */
    public function setCnpj($cnpj = null)
    {
        // validation for constraint: string
        if (!is_null($cnpj) && !is_string($cnpj)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cnpj, true), gettype($cnpj)), __LINE__);
        }
        $this->cnpj = $cnpj;
        return $this;
    }
    /**
     * Get cei value
     * @return string|null
     */
    public function getCei()
    {
        return $this->cei;
    }
    /**
     * Set cei value
     * @param string $cei
     * @return \StructType\Estabelecimento
     */
    public function setCei($cei = null)
    {
        // validation for constraint: string
        if (!is_null($cei) && !is_string($cei)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cei, true), gettype($cei)), __LINE__);
        }
        $this->cei = $cei;
        return $this;
    }
    /**
     * Get razaoSocial value
     * @return string|null
     */
    public function getRazaoSocial()
    {
        return $this->razaoSocial;
    }
    /**
     * Set razaoSocial value
     * @param string $razaoSocial
     * @return \StructType\Estabelecimento
     */
    public function setRazaoSocial($razaoSocial = null)
    {
        // validation for constraint: string
        if (!is_null($razaoSocial) && !is_string($razaoSocial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($razaoSocial, true), gettype($razaoSocial)), __LINE__);
        }
        $this->razaoSocial = $razaoSocial;
        return $this;
    }
    /**
     * Get logradouro value
     * @return string|null
     */
    public function getLogradouro()
    {
        return $this->logradouro;
    }
    /**
     * Set logradouro value
     * @param string $logradouro
     * @return \StructType\Estabelecimento
     */
    public function setLogradouro($logradouro = null)
    {
        // validation for constraint: string
        if (!is_null($logradouro) && !is_string($logradouro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($logradouro, true), gettype($logradouro)), __LINE__);
        }
        $this->logradouro = $logradouro;
        return $this;
    }
    /**
     * Get bairro value
     * @return string|null
     */
    public function getBairro()
    {
        return $this->bairro;
    }
    /**
     * Set bairro value
     * @param string $bairro
     * @return \StructType\Estabelecimento
     */
    public function setBairro($bairro = null)
    {
        // validation for constraint: string
        if (!is_null($bairro) && !is_string($bairro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bairro, true), gettype($bairro)), __LINE__);
        }
        $this->bairro = $bairro;
        return $this;
    }
    /**
     * Get cep value
     * @return string|null
     */
    public function getCep()
    {
        return $this->cep;
    }
    /**
     * Set cep value
     * @param string $cep
     * @return \StructType\Estabelecimento
     */
    public function setCep($cep = null)
    {
        // validation for constraint: string
        if (!is_null($cep) && !is_string($cep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cep, true), gettype($cep)), __LINE__);
        }
        $this->cep = $cep;
        return $this;
    }
    /**
     * Get uf value
     * @return string|null
     */
    public function getUf()
    {
        return $this->uf;
    }
    /**
     * Set uf value
     * @param string $uf
     * @return \StructType\Estabelecimento
     */
    public function setUf($uf = null)
    {
        // validation for constraint: string
        if (!is_null($uf) && !is_string($uf)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uf, true), gettype($uf)), __LINE__);
        }
        $this->uf = $uf;
        return $this;
    }
    /**
     * Get municipio value
     * @return \StructType\Municipio|null
     */
    public function getMunicipio()
    {
        return $this->municipio;
    }
    /**
     * Set municipio value
     * @param \StructType\Municipio $municipio
     * @return \StructType\Estabelecimento
     */
    public function setMunicipio(\StructType\Municipio $municipio = null)
    {
        $this->municipio = $municipio;
        return $this;
    }
    /**
     * Get cnae value
     * @return \StructType\Cnae|null
     */
    public function getCnae()
    {
        return $this->cnae;
    }
    /**
     * Set cnae value
     * @param \StructType\Cnae $cnae
     * @return \StructType\Estabelecimento
     */
    public function setCnae(\StructType\Cnae $cnae = null)
    {
        $this->cnae = $cnae;
        return $this;
    }
    /**
     * Get indicaIndustriaCnae value
     * @return string|null
     */
    public function getIndicaIndustriaCnae()
    {
        return $this->indicaIndustriaCnae;
    }
    /**
     * Set indicaIndustriaCnae value
     * @param string $indicaIndustriaCnae
     * @return \StructType\Estabelecimento
     */
    public function setIndicaIndustriaCnae($indicaIndustriaCnae = null)
    {
        // validation for constraint: string
        if (!is_null($indicaIndustriaCnae) && !is_string($indicaIndustriaCnae)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indicaIndustriaCnae, true), gettype($indicaIndustriaCnae)), __LINE__);
        }
        $this->indicaIndustriaCnae = $indicaIndustriaCnae;
        return $this;
    }
    /**
     * Get indicaIndustriaFpas value
     * @return string|null
     */
    public function getIndicaIndustriaFpas()
    {
        return $this->indicaIndustriaFpas;
    }
    /**
     * Set indicaIndustriaFpas value
     * @param string $indicaIndustriaFpas
     * @return \StructType\Estabelecimento
     */
    public function setIndicaIndustriaFpas($indicaIndustriaFpas = null)
    {
        // validation for constraint: string
        if (!is_null($indicaIndustriaFpas) && !is_string($indicaIndustriaFpas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indicaIndustriaFpas, true), gettype($indicaIndustriaFpas)), __LINE__);
        }
        $this->indicaIndustriaFpas = $indicaIndustriaFpas;
        return $this;
    }
    /**
     * Get indicaOptanteSimples value
     * @return string|null
     */
    public function getIndicaOptanteSimples()
    {
        return $this->indicaOptanteSimples;
    }
    /**
     * Set indicaOptanteSimples value
     * @param string $indicaOptanteSimples
     * @return \StructType\Estabelecimento
     */
    public function setIndicaOptanteSimples($indicaOptanteSimples = null)
    {
        // validation for constraint: string
        if (!is_null($indicaOptanteSimples) && !is_string($indicaOptanteSimples)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indicaOptanteSimples, true), gettype($indicaOptanteSimples)), __LINE__);
        }
        $this->indicaOptanteSimples = $indicaOptanteSimples;
        return $this;
    }
    /**
     * Get descricaoPorteEmpresa value
     * @return string|null
     */
    public function getDescricaoPorteEmpresa()
    {
        return $this->descricaoPorteEmpresa;
    }
    /**
     * Set descricaoPorteEmpresa value
     * @param string $descricaoPorteEmpresa
     * @return \StructType\Estabelecimento
     */
    public function setDescricaoPorteEmpresa($descricaoPorteEmpresa = null)
    {
        // validation for constraint: string
        if (!is_null($descricaoPorteEmpresa) && !is_string($descricaoPorteEmpresa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricaoPorteEmpresa, true), gettype($descricaoPorteEmpresa)), __LINE__);
        }
        $this->descricaoPorteEmpresa = $descricaoPorteEmpresa;
        return $this;
    }
    /**
     * Get ddd value
     * @return string|null
     */
    public function getDdd()
    {
        return $this->ddd;
    }
    /**
     * Set ddd value
     * @param string $ddd
     * @return \StructType\Estabelecimento
     */
    public function setDdd($ddd = null)
    {
        // validation for constraint: string
        if (!is_null($ddd) && !is_string($ddd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ddd, true), gettype($ddd)), __LINE__);
        }
        $this->ddd = $ddd;
        return $this;
    }
    /**
     * Get telefone value
     * @return string|null
     */
    public function getTelefone()
    {
        return $this->telefone;
    }
    /**
     * Set telefone value
     * @param string $telefone
     * @return \StructType\Estabelecimento
     */
    public function setTelefone($telefone = null)
    {
        // validation for constraint: string
        if (!is_null($telefone) && !is_string($telefone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefone, true), gettype($telefone)), __LINE__);
        }
        $this->telefone = $telefone;
        return $this;
    }
    /**
     * Get ramal value
     * @return string|null
     */
    public function getRamal()
    {
        return $this->ramal;
    }
    /**
     * Set ramal value
     * @param string $ramal
     * @return \StructType\Estabelecimento
     */
    public function setRamal($ramal = null)
    {
        // validation for constraint: string
        if (!is_null($ramal) && !is_string($ramal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ramal, true), gettype($ramal)), __LINE__);
        }
        $this->ramal = $ramal;
        return $this;
    }
    /**
     * Get fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->fax;
    }
    /**
     * Set fax value
     * @param string $fax
     * @return \StructType\Estabelecimento
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->fax = $fax;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\Estabelecimento
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get situacaoRFB value
     * @return string|null
     */
    public function getSituacaoRFB()
    {
        return $this->situacaoRFB;
    }
    /**
     * Set situacaoRFB value
     * @param string $situacaoRFB
     * @return \StructType\Estabelecimento
     */
    public function setSituacaoRFB($situacaoRFB = null)
    {
        // validation for constraint: string
        if (!is_null($situacaoRFB) && !is_string($situacaoRFB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($situacaoRFB, true), gettype($situacaoRFB)), __LINE__);
        }
        $this->situacaoRFB = $situacaoRFB;
        return $this;
    }
    /**
     * Get dataAbertura value
     * @return string|null
     */
    public function getDataAbertura()
    {
        return $this->dataAbertura;
    }
    /**
     * Set dataAbertura value
     * @param string $dataAbertura
     * @return \StructType\Estabelecimento
     */
    public function setDataAbertura($dataAbertura = null)
    {
        // validation for constraint: string
        if (!is_null($dataAbertura) && !is_string($dataAbertura)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataAbertura, true), gettype($dataAbertura)), __LINE__);
        }
        $this->dataAbertura = $dataAbertura;
        return $this;
    }
    /**
     * Get dataBaixa value
     * @return string|null
     */
    public function getDataBaixa()
    {
        return $this->dataBaixa;
    }
    /**
     * Set dataBaixa value
     * @param string $dataBaixa
     * @return \StructType\Estabelecimento
     */
    public function setDataBaixa($dataBaixa = null)
    {
        // validation for constraint: string
        if (!is_null($dataBaixa) && !is_string($dataBaixa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataBaixa, true), gettype($dataBaixa)), __LINE__);
        }
        $this->dataBaixa = $dataBaixa;
        return $this;
    }
    /**
     * Get situacaoACARC value
     * @return string|null
     */
    public function getSituacaoACARC()
    {
        return $this->situacaoACARC;
    }
    /**
     * Set situacaoACARC value
     * @param string $situacaoACARC
     * @return \StructType\Estabelecimento
     */
    public function setSituacaoACARC($situacaoACARC = null)
    {
        // validation for constraint: string
        if (!is_null($situacaoACARC) && !is_string($situacaoACARC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($situacaoACARC, true), gettype($situacaoACARC)), __LINE__);
        }
        $this->situacaoACARC = $situacaoACARC;
        return $this;
    }
    /**
     * Get dataSituacaoCadastral value
     * @return string|null
     */
    public function getDataSituacaoCadastral()
    {
        return $this->dataSituacaoCadastral;
    }
    /**
     * Set dataSituacaoCadastral value
     * @param string $dataSituacaoCadastral
     * @return \StructType\Estabelecimento
     */
    public function setDataSituacaoCadastral($dataSituacaoCadastral = null)
    {
        // validation for constraint: string
        if (!is_null($dataSituacaoCadastral) && !is_string($dataSituacaoCadastral)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataSituacaoCadastral, true), gettype($dataSituacaoCadastral)), __LINE__);
        }
        $this->dataSituacaoCadastral = $dataSituacaoCadastral;
        return $this;
    }
    /**
     * Get cnpjVinculado value
     * @return string|null
     */
    public function getCnpjVinculado()
    {
        return $this->cnpjVinculado;
    }
    /**
     * Set cnpjVinculado value
     * @param string $cnpjVinculado
     * @return \StructType\Estabelecimento
     */
    public function setCnpjVinculado($cnpjVinculado = null)
    {
        // validation for constraint: string
        if (!is_null($cnpjVinculado) && !is_string($cnpjVinculado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cnpjVinculado, true), gettype($cnpjVinculado)), __LINE__);
        }
        $this->cnpjVinculado = $cnpjVinculado;
        return $this;
    }
    /**
     * Get ultimoProcessamentoFonteExterna value
     * @return string|null
     */
    public function getUltimoProcessamentoFonteExterna()
    {
        return $this->ultimoProcessamentoFonteExterna;
    }
    /**
     * Set ultimoProcessamentoFonteExterna value
     * @param string $ultimoProcessamentoFonteExterna
     * @return \StructType\Estabelecimento
     */
    public function setUltimoProcessamentoFonteExterna($ultimoProcessamentoFonteExterna = null)
    {
        // validation for constraint: string
        if (!is_null($ultimoProcessamentoFonteExterna) && !is_string($ultimoProcessamentoFonteExterna)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ultimoProcessamentoFonteExterna, true), gettype($ultimoProcessamentoFonteExterna)), __LINE__);
        }
        $this->ultimoProcessamentoFonteExterna = $ultimoProcessamentoFonteExterna;
        return $this;
    }
    /**
     * Get indicaContribuinteSindical value
     * @return string|null
     */
    public function getIndicaContribuinteSindical()
    {
        return $this->indicaContribuinteSindical;
    }
    /**
     * Set indicaContribuinteSindical value
     * @param string $indicaContribuinteSindical
     * @return \StructType\Estabelecimento
     */
    public function setIndicaContribuinteSindical($indicaContribuinteSindical = null)
    {
        // validation for constraint: string
        if (!is_null($indicaContribuinteSindical) && !is_string($indicaContribuinteSindical)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indicaContribuinteSindical, true), gettype($indicaContribuinteSindical)), __LINE__);
        }
        $this->indicaContribuinteSindical = $indicaContribuinteSindical;
        return $this;
    }
    /**
     * Get indicaContribuinteConfederativa value
     * @return string|null
     */
    public function getIndicaContribuinteConfederativa()
    {
        return $this->indicaContribuinteConfederativa;
    }
    /**
     * Set indicaContribuinteConfederativa value
     * @param string $indicaContribuinteConfederativa
     * @return \StructType\Estabelecimento
     */
    public function setIndicaContribuinteConfederativa($indicaContribuinteConfederativa = null)
    {
        // validation for constraint: string
        if (!is_null($indicaContribuinteConfederativa) && !is_string($indicaContribuinteConfederativa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indicaContribuinteConfederativa, true), gettype($indicaContribuinteConfederativa)), __LINE__);
        }
        $this->indicaContribuinteConfederativa = $indicaContribuinteConfederativa;
        return $this;
    }
    /**
     * Get indicaContribuinteAssociativa value
     * @return string|null
     */
    public function getIndicaContribuinteAssociativa()
    {
        return $this->indicaContribuinteAssociativa;
    }
    /**
     * Set indicaContribuinteAssociativa value
     * @param string $indicaContribuinteAssociativa
     * @return \StructType\Estabelecimento
     */
    public function setIndicaContribuinteAssociativa($indicaContribuinteAssociativa = null)
    {
        // validation for constraint: string
        if (!is_null($indicaContribuinteAssociativa) && !is_string($indicaContribuinteAssociativa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indicaContribuinteAssociativa, true), gettype($indicaContribuinteAssociativa)), __LINE__);
        }
        $this->indicaContribuinteAssociativa = $indicaContribuinteAssociativa;
        return $this;
    }
    /**
     * Get indicaContribuinteAssistencial value
     * @return string|null
     */
    public function getIndicaContribuinteAssistencial()
    {
        return $this->indicaContribuinteAssistencial;
    }
    /**
     * Set indicaContribuinteAssistencial value
     * @param string $indicaContribuinteAssistencial
     * @return \StructType\Estabelecimento
     */
    public function setIndicaContribuinteAssistencial($indicaContribuinteAssistencial = null)
    {
        // validation for constraint: string
        if (!is_null($indicaContribuinteAssistencial) && !is_string($indicaContribuinteAssistencial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indicaContribuinteAssistencial, true), gettype($indicaContribuinteAssistencial)), __LINE__);
        }
        $this->indicaContribuinteAssistencial = $indicaContribuinteAssistencial;
        return $this;
    }
    /**
     * Get indicaContribuinteOutrasReceitas value
     * @return string|null
     */
    public function getIndicaContribuinteOutrasReceitas()
    {
        return $this->indicaContribuinteOutrasReceitas;
    }
    /**
     * Set indicaContribuinteOutrasReceitas value
     * @param string $indicaContribuinteOutrasReceitas
     * @return \StructType\Estabelecimento
     */
    public function setIndicaContribuinteOutrasReceitas($indicaContribuinteOutrasReceitas = null)
    {
        // validation for constraint: string
        if (!is_null($indicaContribuinteOutrasReceitas) && !is_string($indicaContribuinteOutrasReceitas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($indicaContribuinteOutrasReceitas, true), gettype($indicaContribuinteOutrasReceitas)), __LINE__);
        }
        $this->indicaContribuinteOutrasReceitas = $indicaContribuinteOutrasReceitas;
        return $this;
    }
    /**
     * Get exerciciosSindicais value
     * @return string|null
     */
    public function getExerciciosSindicais()
    {
        return $this->exerciciosSindicais;
    }
    /**
     * Set exerciciosSindicais value
     * @param string $exerciciosSindicais
     * @return \StructType\Estabelecimento
     */
    public function setExerciciosSindicais($exerciciosSindicais = null)
    {
        // validation for constraint: string
        if (!is_null($exerciciosSindicais) && !is_string($exerciciosSindicais)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($exerciciosSindicais, true), gettype($exerciciosSindicais)), __LINE__);
        }
        $this->exerciciosSindicais = $exerciciosSindicais;
        return $this;
    }
    /**
     * Get convenioAtivoSENAI value
     * @return string|null
     */
    public function getConvenioAtivoSENAI()
    {
        return $this->convenioAtivoSENAI;
    }
    /**
     * Set convenioAtivoSENAI value
     * @param string $convenioAtivoSENAI
     * @return \StructType\Estabelecimento
     */
    public function setConvenioAtivoSENAI($convenioAtivoSENAI = null)
    {
        // validation for constraint: string
        if (!is_null($convenioAtivoSENAI) && !is_string($convenioAtivoSENAI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($convenioAtivoSENAI, true), gettype($convenioAtivoSENAI)), __LINE__);
        }
        $this->convenioAtivoSENAI = $convenioAtivoSENAI;
        return $this;
    }
    /**
     * Get convenioAtivoSESI value
     * @return string|null
     */
    public function getConvenioAtivoSESI()
    {
        return $this->convenioAtivoSESI;
    }
    /**
     * Set convenioAtivoSESI value
     * @param string $convenioAtivoSESI
     * @return \StructType\Estabelecimento
     */
    public function setConvenioAtivoSESI($convenioAtivoSESI = null)
    {
        // validation for constraint: string
        if (!is_null($convenioAtivoSESI) && !is_string($convenioAtivoSESI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($convenioAtivoSESI, true), gettype($convenioAtivoSESI)), __LINE__);
        }
        $this->convenioAtivoSESI = $convenioAtivoSESI;
        return $this;
    }
}
