<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Find ServiceType
 * @subpackage Services
 */
class Find extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named findSindicatoByCnpj
     * Meta information extracted from the WSDL
     * - documentation: findSindicatoByCnpjRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindSindicatoByCnpj $parameters
     * @return \StructType\FindSindicatoByCnpjResponse|bool
     */
    public function findSindicatoByCnpj(\StructType\FindSindicatoByCnpj $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findSindicatoByCnpj($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findCadastroIndustrialByCeiAndFederacaoFromUf
     * Meta information extracted from the WSDL
     * - documentation: findCadastroIndustrialByCeiAndFederacaoFromUfRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindCadastroIndustrialByCeiAndFederacaoFromUf $parameters
     * @return \StructType\FindCadastroIndustrialByCeiAndFederacaoFromUfResponse|bool
     */
    public function findCadastroIndustrialByCeiAndFederacaoFromUf(\StructType\FindCadastroIndustrialByCeiAndFederacaoFromUf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findCadastroIndustrialByCeiAndFederacaoFromUf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findContribuintesSindicaisBySindicatosFromUf
     * Meta information extracted from the WSDL
     * - documentation: findContribuintesSindicaisBySindicatosFromUfRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindContribuintesSindicaisBySindicatosFromUf $parameters
     * @return \StructType\FindContribuintesSindicaisBySindicatosFromUfResponse|bool
     */
    public function findContribuintesSindicaisBySindicatosFromUf(\StructType\FindContribuintesSindicaisBySindicatosFromUf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findContribuintesSindicaisBySindicatosFromUf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findEmailsSindicatoByUf
     * Meta information extracted from the WSDL
     * - documentation: findEmailsSindicatoByUfRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindEmailsSindicatoByUf $parameters
     * @return \StructType\FindEmailsSindicatoByUfResponse|bool
     */
    public function findEmailsSindicatoByUf(\StructType\FindEmailsSindicatoByUf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findEmailsSindicatoByUf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findContribuinteByCei
     * Meta information extracted from the WSDL
     * - documentation: findContribuinteByCeiRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindContribuinteByCei $parameters
     * @return \StructType\FindContribuinteByCeiResponse|bool
     */
    public function findContribuinteByCei(\StructType\FindContribuinteByCei $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findContribuinteByCei($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findCadastrosIndustriaisByFederacaoFromUf
     * Meta information extracted from the WSDL
     * - documentation: findCadastrosIndustriaisByFederacaoFromUfRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindCadastrosIndustriaisByFederacaoFromUf $parameters
     * @return \StructType\FindCadastrosIndustriaisByFederacaoFromUfResponse|bool
     */
    public function findCadastrosIndustriaisByFederacaoFromUf(\StructType\FindCadastrosIndustriaisByFederacaoFromUf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findCadastrosIndustriaisByFederacaoFromUf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findFederacaoByUf
     * Meta information extracted from the WSDL
     * - documentation: findFederacaoByUfRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindFederacaoByUf $parameters
     * @return \StructType\FindFederacaoByUfResponse|bool
     */
    public function findFederacaoByUf(\StructType\FindFederacaoByUf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findFederacaoByUf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findEmailsSindicatoAndSociosByUf
     * Meta information extracted from the WSDL
     * - documentation: findEmailsSindicatoAndSociosByUfRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindEmailsSindicatoAndSociosByUf $parameters
     * @return \StructType\FindEmailsSindicatoAndSociosByUfResponse|bool
     */
    public function findEmailsSindicatoAndSociosByUf(\StructType\FindEmailsSindicatoAndSociosByUf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findEmailsSindicatoAndSociosByUf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findEmailsSindicatoByCodigo
     * Meta information extracted from the WSDL
     * - documentation: findEmailsSindicatoByCodigoRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindEmailsSindicatoByCodigo $parameters
     * @return \StructType\FindEmailsSindicatoByCodigoResponse|bool
     */
    public function findEmailsSindicatoByCodigo(\StructType\FindEmailsSindicatoByCodigo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findEmailsSindicatoByCodigo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findSindicatoByCodigo
     * Meta information extracted from the WSDL
     * - documentation: findSindicatoByCodigoRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindSindicatoByCodigo $parameters
     * @return \StructType\FindSindicatoByCodigoResponse|bool
     */
    public function findSindicatoByCodigo(\StructType\FindSindicatoByCodigo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findSindicatoByCodigo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findEmailsSindicatoAndSociosByCodigo
     * Meta information extracted from the WSDL
     * - documentation: findEmailsSindicatoAndSociosByCodigoRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindEmailsSindicatoAndSociosByCodigo $parameters
     * @return \StructType\FindEmailsSindicatoAndSociosByCodigoResponse|bool
     */
    public function findEmailsSindicatoAndSociosByCodigo(\StructType\FindEmailsSindicatoAndSociosByCodigo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findEmailsSindicatoAndSociosByCodigo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findEstabelecimentoByCei
     * Meta information extracted from the WSDL
     * - documentation: findEstabelecimentoByCeiRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindEstabelecimentoByCei $parameters
     * @return \StructType\FindEstabelecimentoByCeiResponse|bool
     */
    public function findEstabelecimentoByCei(\StructType\FindEstabelecimentoByCei $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findEstabelecimentoByCei($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findEstabelecimentoByCnpj
     * Meta information extracted from the WSDL
     * - documentation: findEstabelecimentoByCnpjRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindEstabelecimentoByCnpj $parameters
     * @return \StructType\FindEstabelecimentoByCnpjResponse|bool
     */
    public function findEstabelecimentoByCnpj(\StructType\FindEstabelecimentoByCnpj $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findEstabelecimentoByCnpj($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findContribuintesSindicaisBySindicato
     * Meta information extracted from the WSDL
     * - documentation: findContribuintesSindicaisBySindicatoRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindContribuintesSindicaisBySindicato $parameters
     * @return \StructType\FindContribuintesSindicaisBySindicatoResponse|bool
     */
    public function findContribuintesSindicaisBySindicato(\StructType\FindContribuintesSindicaisBySindicato $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findContribuintesSindicaisBySindicato($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findContribuinteByCnpj
     * Meta information extracted from the WSDL
     * - documentation: findContribuinteByCnpjRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindContribuinteByCnpj $parameters
     * @return \StructType\FindContribuinteByCnpjResponse|bool
     */
    public function findContribuinteByCnpj(\StructType\FindContribuinteByCnpj $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findContribuinteByCnpj($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findContribuinteSindicalByCnpjAndSindicato
     * Meta information extracted from the WSDL
     * - documentation: findContribuinteSindicalByCnpjAndSindicatoRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindContribuinteSindicalByCnpjAndSindicato $parameters
     * @return \StructType\FindContribuinteSindicalByCnpjAndSindicatoResponse|bool
     */
    public function findContribuinteSindicalByCnpjAndSindicato(\StructType\FindContribuinteSindicalByCnpjAndSindicato $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findContribuinteSindicalByCnpjAndSindicato($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * findCadastroIndustrialByCnpjAndFederacaoFromUf
     * Meta information extracted from the WSDL
     * - documentation: findCadastroIndustrialByCnpjAndFederacaoFromUfRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindCadastroIndustrialByCnpjAndFederacaoFromUf $parameters
     * @return \StructType\FindCadastroIndustrialByCnpjAndFederacaoFromUfResponse|bool
     */
    public function findCadastroIndustrialByCnpjAndFederacaoFromUf(\StructType\FindCadastroIndustrialByCnpjAndFederacaoFromUf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findCadastroIndustrialByCnpjAndFederacaoFromUf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named findSindicatosByUf
     * Meta information extracted from the WSDL
     * - documentation: findSindicatosByUfRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\FindSindicatosByUf $parameters
     * @return \StructType\FindSindicatosByUfResponse|bool
     */
    public function findSindicatosByUf(\StructType\FindSindicatosByUf $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->findSindicatosByUf($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\FindCadastroIndustrialByCeiAndFederacaoFromUfResponse|\StructType\FindCadastroIndustrialByCnpjAndFederacaoFromUfResponse|\StructType\FindCadastrosIndustriaisByFederacaoFromUfResponse|\StructType\FindContribuinteByCeiResponse|\StructType\FindContribuinteByCnpjResponse|\StructType\FindContribuinteSindicalByCnpjAndSindicatoResponse|\StructType\FindContribuintesSindicaisBySindicatoResponse|\StructType\FindContribuintesSindicaisBySindicatosFromUfResponse|\StructType\FindEmailsSindicatoAndSociosByCodigoResponse|\StructType\FindEmailsSindicatoAndSociosByUfResponse|\StructType\FindEmailsSindicatoByCodigoResponse|\StructType\FindEmailsSindicatoByUfResponse|\StructType\FindEstabelecimentoByCeiResponse|\StructType\FindEstabelecimentoByCnpjResponse|\StructType\FindFederacaoByUfResponse|\StructType\FindSindicatoByCnpjResponse|\StructType\FindSindicatoByCodigoResponse|\StructType\FindSindicatosByUfResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
