<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfCadastroIndustrial ArrayType
 * @subpackage Arrays
 */
class ArrayOfCadastroIndustrial extends AbstractStructArrayBase
{
    /**
     * The CadastroIndustrial
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CadastroIndustrial[]
     */
    public $CadastroIndustrial;
    /**
     * Constructor method for ArrayOfCadastroIndustrial
     * @uses ArrayOfCadastroIndustrial::setCadastroIndustrial()
     * @param \StructType\CadastroIndustrial[] $cadastroIndustrial
     */
    public function __construct(array $cadastroIndustrial = array())
    {
        $this
            ->setCadastroIndustrial($cadastroIndustrial);
    }
    /**
     * Get CadastroIndustrial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CadastroIndustrial[]|null
     */
    public function getCadastroIndustrial()
    {
        return isset($this->CadastroIndustrial) ? $this->CadastroIndustrial : null;
    }
    /**
     * This method is responsible for validating the values passed to the setCadastroIndustrial method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCadastroIndustrial method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCadastroIndustrialForArrayConstraintsFromSetCadastroIndustrial(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfCadastroIndustrialCadastroIndustrialItem) {
            // validation for constraint: itemType
            if (!$arrayOfCadastroIndustrialCadastroIndustrialItem instanceof \StructType\CadastroIndustrial) {
                $invalidValues[] = is_object($arrayOfCadastroIndustrialCadastroIndustrialItem) ? get_class($arrayOfCadastroIndustrialCadastroIndustrialItem) : sprintf('%s(%s)', gettype($arrayOfCadastroIndustrialCadastroIndustrialItem), var_export($arrayOfCadastroIndustrialCadastroIndustrialItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CadastroIndustrial property can only contain items of type \StructType\CadastroIndustrial, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CadastroIndustrial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\CadastroIndustrial[] $cadastroIndustrial
     * @return \ArrayType\ArrayOfCadastroIndustrial
     */
    public function setCadastroIndustrial(array $cadastroIndustrial = array())
    {
        // validation for constraint: array
        if ('' !== ($cadastroIndustrialArrayErrorMessage = self::validateCadastroIndustrialForArrayConstraintsFromSetCadastroIndustrial($cadastroIndustrial))) {
            throw new \InvalidArgumentException($cadastroIndustrialArrayErrorMessage, __LINE__);
        }
        if (is_null($cadastroIndustrial) || (is_array($cadastroIndustrial) && empty($cadastroIndustrial))) {
            unset($this->CadastroIndustrial);
        } else {
            $this->CadastroIndustrial = $cadastroIndustrial;
        }
        return $this;
    }
    /**
     * Add item to CadastroIndustrial value
     * @throws \InvalidArgumentException
     * @param \StructType\CadastroIndustrial $item
     * @return \ArrayType\ArrayOfCadastroIndustrial
     */
    public function addToCadastroIndustrial(\StructType\CadastroIndustrial $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CadastroIndustrial) {
            throw new \InvalidArgumentException(sprintf('The CadastroIndustrial property can only contain items of type \StructType\CadastroIndustrial, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CadastroIndustrial[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\CadastroIndustrial|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\CadastroIndustrial|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\CadastroIndustrial|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\CadastroIndustrial|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\CadastroIndustrial|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CadastroIndustrial
     */
    public function getAttributeName()
    {
        return 'CadastroIndustrial';
    }
}
