<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for data StructType
 * @subpackage Structs
 */
class Data extends AbstractStructBase
{
    /**
     * The Error_Code
     * @var string
     */
    public $Error_Code;
    /**
     * The Error
     * @var string
     */
    public $Error;
    /**
     * The Error_Resource_Id
     * @var string
     */
    public $Error_Resource_Id;
    /**
     * The Voucher
     * @var string
     */
    public $Voucher;
    /**
     * The DuplicateVoucher
     * @var string
     */
    public $DuplicateVoucher;
    /**
     * The R_Zone_Code
     * @var string
     */
    public $R_Zone_Code;
    /**
     * The R_Zone_Description
     * @var string
     */
    public $R_Zone_Description;
    /**
     * The Has_Cash_On_Delivery
     * @var string
     */
    public $Has_Cash_On_Delivery;
    /**
     * The Cash_On_Delivery
     * @var string
     */
    public $Cash_On_Delivery;
    /**
     * The Cheques_On_Delivery
     * @var string
     */
    public $Cheques_On_Delivery;
    /**
     * The Relative1
     * @var string
     */
    public $Relative1;
    /**
     * Constructor method for data
     * @uses Data::setError_Code()
     * @uses Data::setError()
     * @uses Data::setError_Resource_Id()
     * @uses Data::setVoucher()
     * @uses Data::setDuplicateVoucher()
     * @uses Data::setR_Zone_Code()
     * @uses Data::setR_Zone_Description()
     * @uses Data::setHas_Cash_On_Delivery()
     * @uses Data::setCash_On_Delivery()
     * @uses Data::setCheques_On_Delivery()
     * @uses Data::setRelative1()
     * @param string $error_Code
     * @param string $error
     * @param string $error_Resource_Id
     * @param string $voucher
     * @param string $duplicateVoucher
     * @param string $r_Zone_Code
     * @param string $r_Zone_Description
     * @param string $has_Cash_On_Delivery
     * @param string $cash_On_Delivery
     * @param string $cheques_On_Delivery
     * @param string $relative1
     */
    public function __construct($error_Code = null, $error = null, $error_Resource_Id = null, $voucher = null, $duplicateVoucher = null, $r_Zone_Code = null, $r_Zone_Description = null, $has_Cash_On_Delivery = null, $cash_On_Delivery = null, $cheques_On_Delivery = null, $relative1 = null)
    {
        $this
            ->setError_Code($error_Code)
            ->setError($error)
            ->setError_Resource_Id($error_Resource_Id)
            ->setVoucher($voucher)
            ->setDuplicateVoucher($duplicateVoucher)
            ->setR_Zone_Code($r_Zone_Code)
            ->setR_Zone_Description($r_Zone_Description)
            ->setHas_Cash_On_Delivery($has_Cash_On_Delivery)
            ->setCash_On_Delivery($cash_On_Delivery)
            ->setCheques_On_Delivery($cheques_On_Delivery)
            ->setRelative1($relative1);
    }
    /**
     * Get Error_Code value
     * @return string|null
     */
    public function getError_Code()
    {
        return $this->Error_Code;
    }
    /**
     * Set Error_Code value
     * @param string $error_Code
     * @return \StructType\Data
     */
    public function setError_Code($error_Code = null)
    {
        // validation for constraint: string
        if (!is_null($error_Code) && !is_string($error_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error_Code, true), gettype($error_Code)), __LINE__);
        }
        $this->Error_Code = $error_Code;
        return $this;
    }
    /**
     * Get Error value
     * @return string|null
     */
    public function getError()
    {
        return $this->Error;
    }
    /**
     * Set Error value
     * @param string $error
     * @return \StructType\Data
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        $this->Error = $error;
        return $this;
    }
    /**
     * Get Error_Resource_Id value
     * @return string|null
     */
    public function getError_Resource_Id()
    {
        return $this->Error_Resource_Id;
    }
    /**
     * Set Error_Resource_Id value
     * @param string $error_Resource_Id
     * @return \StructType\Data
     */
    public function setError_Resource_Id($error_Resource_Id = null)
    {
        // validation for constraint: string
        if (!is_null($error_Resource_Id) && !is_string($error_Resource_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error_Resource_Id, true), gettype($error_Resource_Id)), __LINE__);
        }
        $this->Error_Resource_Id = $error_Resource_Id;
        return $this;
    }
    /**
     * Get Voucher value
     * @return string|null
     */
    public function getVoucher()
    {
        return $this->Voucher;
    }
    /**
     * Set Voucher value
     * @param string $voucher
     * @return \StructType\Data
     */
    public function setVoucher($voucher = null)
    {
        // validation for constraint: string
        if (!is_null($voucher) && !is_string($voucher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($voucher, true), gettype($voucher)), __LINE__);
        }
        $this->Voucher = $voucher;
        return $this;
    }
    /**
     * Get DuplicateVoucher value
     * @return string|null
     */
    public function getDuplicateVoucher()
    {
        return $this->DuplicateVoucher;
    }
    /**
     * Set DuplicateVoucher value
     * @param string $duplicateVoucher
     * @return \StructType\Data
     */
    public function setDuplicateVoucher($duplicateVoucher = null)
    {
        // validation for constraint: string
        if (!is_null($duplicateVoucher) && !is_string($duplicateVoucher)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($duplicateVoucher, true), gettype($duplicateVoucher)), __LINE__);
        }
        $this->DuplicateVoucher = $duplicateVoucher;
        return $this;
    }
    /**
     * Get R_Zone_Code value
     * @return string|null
     */
    public function getR_Zone_Code()
    {
        return $this->R_Zone_Code;
    }
    /**
     * Set R_Zone_Code value
     * @param string $r_Zone_Code
     * @return \StructType\Data
     */
    public function setR_Zone_Code($r_Zone_Code = null)
    {
        // validation for constraint: string
        if (!is_null($r_Zone_Code) && !is_string($r_Zone_Code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($r_Zone_Code, true), gettype($r_Zone_Code)), __LINE__);
        }
        $this->R_Zone_Code = $r_Zone_Code;
        return $this;
    }
    /**
     * Get R_Zone_Description value
     * @return string|null
     */
    public function getR_Zone_Description()
    {
        return $this->R_Zone_Description;
    }
    /**
     * Set R_Zone_Description value
     * @param string $r_Zone_Description
     * @return \StructType\Data
     */
    public function setR_Zone_Description($r_Zone_Description = null)
    {
        // validation for constraint: string
        if (!is_null($r_Zone_Description) && !is_string($r_Zone_Description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($r_Zone_Description, true), gettype($r_Zone_Description)), __LINE__);
        }
        $this->R_Zone_Description = $r_Zone_Description;
        return $this;
    }
    /**
     * Get Has_Cash_On_Delivery value
     * @return string|null
     */
    public function getHas_Cash_On_Delivery()
    {
        return $this->Has_Cash_On_Delivery;
    }
    /**
     * Set Has_Cash_On_Delivery value
     * @param string $has_Cash_On_Delivery
     * @return \StructType\Data
     */
    public function setHas_Cash_On_Delivery($has_Cash_On_Delivery = null)
    {
        // validation for constraint: string
        if (!is_null($has_Cash_On_Delivery) && !is_string($has_Cash_On_Delivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($has_Cash_On_Delivery, true), gettype($has_Cash_On_Delivery)), __LINE__);
        }
        $this->Has_Cash_On_Delivery = $has_Cash_On_Delivery;
        return $this;
    }
    /**
     * Get Cash_On_Delivery value
     * @return string|null
     */
    public function getCash_On_Delivery()
    {
        return $this->Cash_On_Delivery;
    }
    /**
     * Set Cash_On_Delivery value
     * @param string $cash_On_Delivery
     * @return \StructType\Data
     */
    public function setCash_On_Delivery($cash_On_Delivery = null)
    {
        // validation for constraint: string
        if (!is_null($cash_On_Delivery) && !is_string($cash_On_Delivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cash_On_Delivery, true), gettype($cash_On_Delivery)), __LINE__);
        }
        $this->Cash_On_Delivery = $cash_On_Delivery;
        return $this;
    }
    /**
     * Get Cheques_On_Delivery value
     * @return string|null
     */
    public function getCheques_On_Delivery()
    {
        return $this->Cheques_On_Delivery;
    }
    /**
     * Set Cheques_On_Delivery value
     * @param string $cheques_On_Delivery
     * @return \StructType\Data
     */
    public function setCheques_On_Delivery($cheques_On_Delivery = null)
    {
        // validation for constraint: string
        if (!is_null($cheques_On_Delivery) && !is_string($cheques_On_Delivery)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cheques_On_Delivery, true), gettype($cheques_On_Delivery)), __LINE__);
        }
        $this->Cheques_On_Delivery = $cheques_On_Delivery;
        return $this;
    }
    /**
     * Get Relative1 value
     * @return string|null
     */
    public function getRelative1()
    {
        return $this->Relative1;
    }
    /**
     * Set Relative1 value
     * @param string $relative1
     * @return \StructType\Data
     */
    public function setRelative1($relative1 = null)
    {
        // validation for constraint: string
        if (!is_null($relative1) && !is_string($relative1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relative1, true), gettype($relative1)), __LINE__);
        }
        $this->Relative1 = $relative1;
        return $this;
    }
}
