<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for New ServiceType
 * @subpackage Services
 */
class _New extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named newShipment
     * Meta information extracted from the WSDL
     * - documentation: Create New Shipments
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $code
     * @param string $cRM
     * @param string $user
     * @param string $pass
     * @param string $r_Name
     * @param string $r_Address
     * @param string $r_Area_Code
     * @param string $r_Area
     * @param string $r_PC
     * @param string $r_Phone1
     * @param string $r_Phone2
     * @param string $r_Email
     * @param string $length
     * @param string $width
     * @param string $height
     * @param string $weight
     * @param string $prod
     * @param string $pieces
     * @param string $multi_Prod
     * @param string $cash_On_Delivery
     * @param string $cheques_On_Delivery
     * @param string $comments
     * @param string $charge
     * @param string $type
     * @param string $relative1
     * @param string $relative2
     * @param string $delivery_Time_To
     * @param string $sMS
     * @param string $special_Treatment
     * @param string $protocol
     * @param string $morning_Delivery
     * @param string $buy_Amount
     * @param string $pick_Up
     * @param string $service_Type
     * @param string $relabel
     * @param string $con_Call
     * @param string $ins_Amount
     * @return \StructType\Data|bool
     */
    public function newShipment($code, $cRM, $user, $pass, $r_Name, $r_Address, $r_Area_Code, $r_Area, $r_PC, $r_Phone1, $r_Phone2, $r_Email, $length, $width, $height, $weight, $prod, $pieces, $multi_Prod, $cash_On_Delivery, $cheques_On_Delivery, $comments, $charge, $type, $relative1, $relative2, $delivery_Time_To, $sMS, $special_Treatment, $protocol, $morning_Delivery, $buy_Amount, $pick_Up, $service_Type, $relabel, $con_Call, $ins_Amount)
    {
        try {
            $this->setResult($this->getSoapClient()->newShipment($code, $cRM, $user, $pass, $r_Name, $r_Address, $r_Area_Code, $r_Area, $r_PC, $r_Phone1, $r_Phone2, $r_Email, $length, $width, $height, $weight, $prod, $pieces, $multi_Prod, $cash_On_Delivery, $cheques_On_Delivery, $comments, $charge, $type, $relative1, $relative2, $delivery_Time_To, $sMS, $special_Treatment, $protocol, $morning_Delivery, $buy_Amount, $pick_Up, $service_Type, $relabel, $con_Call, $ins_Amount));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\Data
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
