<?php

namespace Codesdirect\Neosurf\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Ticketcheckcredit ServiceType
 * @subpackage Services
 */
class Ticketcheckcredit extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ticket_check_credit
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $amount
     * @param string $hash
     * @param string $iDMerchant
     * @param string $iDTicket
     * @return array|bool
     */
    public function ticket_check_credit($amount, $hash, $iDMerchant, $iDTicket)
    {
        try {
            $this->setResult($this->getSoapClient()->ticket_check_credit($amount, $hash, $iDMerchant, $iDTicket));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
