<?php

namespace Codesdirect\Neosurf\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Getdtickets ServiceType
 * @subpackage Services
 */
class Getdtickets extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named get_dtickets
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $currency
     * @param string $hash
     * @param string $iDProduct
     * @param string $iDReseller
     * @param string $iDTransaction
     * @param string $iDUser
     * @param string $quantity
     * @return array|bool
     */
    public function get_dtickets($currency, $hash, $iDProduct, $iDReseller, $iDTransaction, $iDUser, $quantity)
    {
        try {
            $this->setResult($this->getSoapClient()->get_dtickets($currency, $hash, $iDProduct, $iDReseller, $iDTransaction, $iDUser, $quantity));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
