<?php

namespace Codesdirect\Neosurf\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Checktransactionstatus ServiceType
 * @subpackage Services
 */
class Checktransactionstatus extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named check_transaction_status
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $amount
     * @param string $currency
     * @param string $hash
     * @param string $iDMerchant
     * @param string $iDService
     * @param string $iDTransaction
     * @param string $neosurf_payment_ID
     * @param string $serial_nb
     * @param string $transaction_type
     * @return array|bool
     */
    public function check_transaction_status($amount, $currency, $hash, $iDMerchant, $iDService, $iDTransaction, $neosurf_payment_ID, $serial_nb, $transaction_type)
    {
        try {
            $this->setResult($this->getSoapClient()->check_transaction_status($amount, $currency, $hash, $iDMerchant, $iDService, $iDTransaction, $neosurf_payment_ID, $serial_nb, $transaction_type));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
