<?php

namespace Codesdirect\Neosurf\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Voucher ServiceType
 * @subpackage Services
 */
class Voucher extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named VoucherRefreshLogs
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return string|bool
     */
    public function VoucherRefreshLogs($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->VoucherRefreshLogs($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named voucherLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function voucherLogin($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->voucherLogin($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named voucherLogout
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return string|bool
     */
    public function voucherLogout($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->voucherLogout($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named voucherGetBalance
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function voucherGetBalance($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->voucherGetBalance($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named voucherGetHistory
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return string|bool
     */
    public function voucherGetHistory($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->voucherGetHistory($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named voucherHistorySerialNb
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return string|bool
     */
    public function voucherHistorySerialNb($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->voucherHistorySerialNb($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named voucherGetDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param struct $struct
     * @return array|bool
     */
    public function voucherGetDetails($struct)
    {
        try {
            $this->setResult($this->getSoapClient()->voucherGetDetails($struct));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array|string
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
