<?php

namespace Codesdirect\Neosurf\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Getdticketsvoid ServiceType
 * @subpackage Services
 */
class Getdticketsvoid extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named get_dtickets_void
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $auth_nb
     * @param string $hash
     * @param string $reason_comment
     * @param string $reason_label
     * @return array|bool
     */
    public function get_dtickets_void($auth_nb, $hash, $reason_comment, $reason_label)
    {
        try {
            $this->setResult($this->getSoapClient()->get_dtickets_void($auth_nb, $hash, $reason_comment, $reason_label));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named get_dtickets_void2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $iDReseller
     * @param string $iDTransaction
     * @param string $iDUser
     * @param string $hash
     * @param string $reason_comment
     * @param string $reason_label
     * @return array|bool
     */
    public function get_dtickets_void2($iDReseller, $iDTransaction, $iDUser, $hash, $reason_comment, $reason_label)
    {
        try {
            $this->setResult($this->getSoapClient()->get_dtickets_void2($iDReseller, $iDTransaction, $iDUser, $hash, $reason_comment, $reason_label));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
