<?php

namespace Codesdirect\Neosurf\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Cancelpayment ServiceType
 * @subpackage Services
 */
class Cancelpayment extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named cancel_payment
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $hash
     * @param string $iDMerchant
     * @param string $iDService
     * @param string $iDTransaction
     * @return array|bool
     */
    public function cancel_payment($hash, $iDMerchant, $iDService, $iDTransaction)
    {
        try {
            $this->setResult($this->getSoapClient()->cancel_payment($hash, $iDMerchant, $iDService, $iDTransaction));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
