<?php

namespace Codesdirect\Neosurf\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Creditsim ServiceType
 * @subpackage Services
 */
class Creditsim extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named credit_sim
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param string $amount
     * @param string $currency
     * @param string $hash
     * @param string $iDReseller
     * @param string $iDTransaction
     * @param string $iDUser
     * @param string $operator
     * @param string $tel_nb
     * @return array|bool
     */
    public function credit_sim($amount, $currency, $hash, $iDReseller, $iDTransaction, $iDUser, $operator, $tel_nb)
    {
        try {
            $this->setResult($this->getSoapClient()->credit_sim($amount, $currency, $hash, $iDReseller, $iDTransaction, $iDUser, $operator, $tel_nb));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return array
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
