<?php

namespace fk_\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KSube StructType
 * @subpackage Structs
 */
class KSube extends Entity
{
    /**
     * The Tipi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $Tipi;
    /**
     * The GunlukCalismaDurum
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $GunlukCalismaDurum;
    /**
     * The TipTur
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TipTur;
    /**
     * The AktarmayaUzaklik
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AktarmayaUzaklik;
    /**
     * The SP_IsyeriObjId
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $SP_IsyeriObjId;
    /**
     * The IsTahsilatKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTahsilatKapali;
    /**
     * The IsFaturaKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsFaturaKapali;
    /**
     * The IsTesellumKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTesellumKapali;
    /**
     * The IsTeslimatKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsTeslimatKapali;
    /**
     * The IsYuklemeKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsYuklemeKapali;
    /**
     * The IsMusteriSozlesmeKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMusteriSozlesmeKapali;
    /**
     * The IsAracSozlesmeKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsAracSozlesmeKapali;
    /**
     * The IsCariKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsCariKapali;
    /**
     * The Faaliyettemi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $Faaliyettemi;
    /**
     * The IsMerkezSITesellumKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsMerkezSITesellumKapali;
    /**
     * The IsBolgeSITesellumKapali
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsBolgeSITesellumKapali;
    /**
     * The GazeteBayiKDVOran
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $GazeteBayiKDVOran;
    /**
     * The IsKibris
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsKibris;
    /**
     * The IslemTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IslemTarihi;
    /**
     * The KapatilmaTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $KapatilmaTarihi;
    /**
     * The FaaliyetDurdurulmaTarihi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FaaliyetDurdurulmaTarihi;
    /**
     * The IsSaatKontrolAcik
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IsSaatKontrolAcik;
    /**
     * The Adi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Adi;
    /**
     * The Kodu
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Kodu;
    /**
     * The Aciklama
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Aciklama;
    /**
     * The BagliOlduguSube
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSubePointer
     */
    public $BagliOlduguSube;
    /**
     * The BagliOlduguAktarma
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KSubePointer
     */
    public $BagliOlduguAktarma;
    /**
     * The Carisi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KCariPointer
     */
    public $Carisi;
    /**
     * The Adresi
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\StructType\KAdresPointer
     */
    public $Adresi;
    /**
     * The IPTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IPTel;
    /**
     * The SabitTel
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SabitTel;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Fax;
    /**
     * The Gsm
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Gsm;
    /**
     * The GsmKisa
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GsmKisa;
    /**
     * The Enlem
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Enlem;
    /**
     * The Boylam
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Boylam;
    /**
     * The ReferansGrup
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ReferansGrup;
    /**
     * The NobetBitSaati
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NobetBitSaati;
    /**
     * The EvrakKesimBitSaati
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $EvrakKesimBitSaati;
    /**
     * The KSubeBiyografileri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \fk_\ArrayType\ArrayOfKSubeBiyografisi
     */
    public $KSubeBiyografileri;
    /**
     * The GrupNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GrupNo;
    /**
     * The SubeTipleri
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubeTipleri;
    /**
     * Constructor method for KSube
     * @uses KSube::setTipi()
     * @uses KSube::setGunlukCalismaDurum()
     * @uses KSube::setTipTur()
     * @uses KSube::setAktarmayaUzaklik()
     * @uses KSube::setSP_IsyeriObjId()
     * @uses KSube::setIsTahsilatKapali()
     * @uses KSube::setIsFaturaKapali()
     * @uses KSube::setIsTesellumKapali()
     * @uses KSube::setIsTeslimatKapali()
     * @uses KSube::setIsYuklemeKapali()
     * @uses KSube::setIsMusteriSozlesmeKapali()
     * @uses KSube::setIsAracSozlesmeKapali()
     * @uses KSube::setIsCariKapali()
     * @uses KSube::setFaaliyettemi()
     * @uses KSube::setIsMerkezSITesellumKapali()
     * @uses KSube::setIsBolgeSITesellumKapali()
     * @uses KSube::setGazeteBayiKDVOran()
     * @uses KSube::setIsKibris()
     * @uses KSube::setIslemTarihi()
     * @uses KSube::setKapatilmaTarihi()
     * @uses KSube::setFaaliyetDurdurulmaTarihi()
     * @uses KSube::setIsSaatKontrolAcik()
     * @uses KSube::setAdi()
     * @uses KSube::setKodu()
     * @uses KSube::setAciklama()
     * @uses KSube::setBagliOlduguSube()
     * @uses KSube::setBagliOlduguAktarma()
     * @uses KSube::setCarisi()
     * @uses KSube::setAdresi()
     * @uses KSube::setIPTel()
     * @uses KSube::setSabitTel()
     * @uses KSube::setFax()
     * @uses KSube::setGsm()
     * @uses KSube::setGsmKisa()
     * @uses KSube::setEnlem()
     * @uses KSube::setBoylam()
     * @uses KSube::setReferansGrup()
     * @uses KSube::setNobetBitSaati()
     * @uses KSube::setEvrakKesimBitSaati()
     * @uses KSube::setKSubeBiyografileri()
     * @uses KSube::setGrupNo()
     * @uses KSube::setSubeTipleri()
     * @param string $tipi
     * @param string $gunlukCalismaDurum
     * @param string $tipTur
     * @param float $aktarmayaUzaklik
     * @param int $sP_IsyeriObjId
     * @param bool $isTahsilatKapali
     * @param bool $isFaturaKapali
     * @param bool $isTesellumKapali
     * @param bool $isTeslimatKapali
     * @param bool $isYuklemeKapali
     * @param bool $isMusteriSozlesmeKapali
     * @param bool $isAracSozlesmeKapali
     * @param bool $isCariKapali
     * @param bool $faaliyettemi
     * @param bool $isMerkezSITesellumKapali
     * @param bool $isBolgeSITesellumKapali
     * @param float $gazeteBayiKDVOran
     * @param bool $isKibris
     * @param string $islemTarihi
     * @param string $kapatilmaTarihi
     * @param string $faaliyetDurdurulmaTarihi
     * @param bool $isSaatKontrolAcik
     * @param string $adi
     * @param string $kodu
     * @param string $aciklama
     * @param \fk_\StructType\KSubePointer $bagliOlduguSube
     * @param \fk_\StructType\KSubePointer $bagliOlduguAktarma
     * @param \fk_\StructType\KCariPointer $carisi
     * @param \fk_\StructType\KAdresPointer $adresi
     * @param string $iPTel
     * @param string $sabitTel
     * @param string $fax
     * @param string $gsm
     * @param string $gsmKisa
     * @param string $enlem
     * @param string $boylam
     * @param string $referansGrup
     * @param string $nobetBitSaati
     * @param string $evrakKesimBitSaati
     * @param \fk_\ArrayType\ArrayOfKSubeBiyografisi $kSubeBiyografileri
     * @param string $grupNo
     * @param string $subeTipleri
     */
    public function __construct($tipi = null, $gunlukCalismaDurum = null, $tipTur = null, $aktarmayaUzaklik = null, $sP_IsyeriObjId = null, $isTahsilatKapali = null, $isFaturaKapali = null, $isTesellumKapali = null, $isTeslimatKapali = null, $isYuklemeKapali = null, $isMusteriSozlesmeKapali = null, $isAracSozlesmeKapali = null, $isCariKapali = null, $faaliyettemi = null, $isMerkezSITesellumKapali = null, $isBolgeSITesellumKapali = null, $gazeteBayiKDVOran = null, $isKibris = null, $islemTarihi = null, $kapatilmaTarihi = null, $faaliyetDurdurulmaTarihi = null, $isSaatKontrolAcik = null, $adi = null, $kodu = null, $aciklama = null, \fk_\StructType\KSubePointer $bagliOlduguSube = null, \fk_\StructType\KSubePointer $bagliOlduguAktarma = null, \fk_\StructType\KCariPointer $carisi = null, \fk_\StructType\KAdresPointer $adresi = null, $iPTel = null, $sabitTel = null, $fax = null, $gsm = null, $gsmKisa = null, $enlem = null, $boylam = null, $referansGrup = null, $nobetBitSaati = null, $evrakKesimBitSaati = null, \fk_\ArrayType\ArrayOfKSubeBiyografisi $kSubeBiyografileri = null, $grupNo = null, $subeTipleri = null)
    {
        $this
            ->setTipi($tipi)
            ->setGunlukCalismaDurum($gunlukCalismaDurum)
            ->setTipTur($tipTur)
            ->setAktarmayaUzaklik($aktarmayaUzaklik)
            ->setSP_IsyeriObjId($sP_IsyeriObjId)
            ->setIsTahsilatKapali($isTahsilatKapali)
            ->setIsFaturaKapali($isFaturaKapali)
            ->setIsTesellumKapali($isTesellumKapali)
            ->setIsTeslimatKapali($isTeslimatKapali)
            ->setIsYuklemeKapali($isYuklemeKapali)
            ->setIsMusteriSozlesmeKapali($isMusteriSozlesmeKapali)
            ->setIsAracSozlesmeKapali($isAracSozlesmeKapali)
            ->setIsCariKapali($isCariKapali)
            ->setFaaliyettemi($faaliyettemi)
            ->setIsMerkezSITesellumKapali($isMerkezSITesellumKapali)
            ->setIsBolgeSITesellumKapali($isBolgeSITesellumKapali)
            ->setGazeteBayiKDVOran($gazeteBayiKDVOran)
            ->setIsKibris($isKibris)
            ->setIslemTarihi($islemTarihi)
            ->setKapatilmaTarihi($kapatilmaTarihi)
            ->setFaaliyetDurdurulmaTarihi($faaliyetDurdurulmaTarihi)
            ->setIsSaatKontrolAcik($isSaatKontrolAcik)
            ->setAdi($adi)
            ->setKodu($kodu)
            ->setAciklama($aciklama)
            ->setBagliOlduguSube($bagliOlduguSube)
            ->setBagliOlduguAktarma($bagliOlduguAktarma)
            ->setCarisi($carisi)
            ->setAdresi($adresi)
            ->setIPTel($iPTel)
            ->setSabitTel($sabitTel)
            ->setFax($fax)
            ->setGsm($gsm)
            ->setGsmKisa($gsmKisa)
            ->setEnlem($enlem)
            ->setBoylam($boylam)
            ->setReferansGrup($referansGrup)
            ->setNobetBitSaati($nobetBitSaati)
            ->setEvrakKesimBitSaati($evrakKesimBitSaati)
            ->setKSubeBiyografileri($kSubeBiyografileri)
            ->setGrupNo($grupNo)
            ->setSubeTipleri($subeTipleri);
    }
    /**
     * Get Tipi value
     * @return string
     */
    public function getTipi()
    {
        return $this->Tipi;
    }
    /**
     * Set Tipi value
     * @uses \fk_\EnumType\SubeTip::valueIsValid()
     * @uses \fk_\EnumType\SubeTip::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipi
     * @return \fk_\StructType\KSube
     */
    public function setTipi($tipi = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\SubeTip::valueIsValid($tipi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\SubeTip', is_array($tipi) ? implode(', ', $tipi) : var_export($tipi, true), implode(', ', \fk_\EnumType\SubeTip::getValidValues())), __LINE__);
        }
        $this->Tipi = $tipi;
        return $this;
    }
    /**
     * Get GunlukCalismaDurum value
     * @return string
     */
    public function getGunlukCalismaDurum()
    {
        return $this->GunlukCalismaDurum;
    }
    /**
     * Set GunlukCalismaDurum value
     * @uses \fk_\EnumType\GunlukCalismaDurum::valueIsValid()
     * @uses \fk_\EnumType\GunlukCalismaDurum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gunlukCalismaDurum
     * @return \fk_\StructType\KSube
     */
    public function setGunlukCalismaDurum($gunlukCalismaDurum = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\GunlukCalismaDurum::valueIsValid($gunlukCalismaDurum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\GunlukCalismaDurum', is_array($gunlukCalismaDurum) ? implode(', ', $gunlukCalismaDurum) : var_export($gunlukCalismaDurum, true), implode(', ', \fk_\EnumType\GunlukCalismaDurum::getValidValues())), __LINE__);
        }
        $this->GunlukCalismaDurum = $gunlukCalismaDurum;
        return $this;
    }
    /**
     * Get TipTur value
     * @return string
     */
    public function getTipTur()
    {
        return $this->TipTur;
    }
    /**
     * Set TipTur value
     * @uses \fk_\EnumType\SubeTipTur::valueIsValid()
     * @uses \fk_\EnumType\SubeTipTur::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipTur
     * @return \fk_\StructType\KSube
     */
    public function setTipTur($tipTur = null)
    {
        // validation for constraint: enumeration
        if (!\fk_\EnumType\SubeTipTur::valueIsValid($tipTur)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \fk_\EnumType\SubeTipTur', is_array($tipTur) ? implode(', ', $tipTur) : var_export($tipTur, true), implode(', ', \fk_\EnumType\SubeTipTur::getValidValues())), __LINE__);
        }
        $this->TipTur = $tipTur;
        return $this;
    }
    /**
     * Get AktarmayaUzaklik value
     * @return float
     */
    public function getAktarmayaUzaklik()
    {
        return $this->AktarmayaUzaklik;
    }
    /**
     * Set AktarmayaUzaklik value
     * @param float $aktarmayaUzaklik
     * @return \fk_\StructType\KSube
     */
    public function setAktarmayaUzaklik($aktarmayaUzaklik = null)
    {
        // validation for constraint: float
        if (!is_null($aktarmayaUzaklik) && !(is_float($aktarmayaUzaklik) || is_numeric($aktarmayaUzaklik))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($aktarmayaUzaklik, true), gettype($aktarmayaUzaklik)), __LINE__);
        }
        $this->AktarmayaUzaklik = $aktarmayaUzaklik;
        return $this;
    }
    /**
     * Get SP_IsyeriObjId value
     * @return int
     */
    public function getSP_IsyeriObjId()
    {
        return $this->SP_IsyeriObjId;
    }
    /**
     * Set SP_IsyeriObjId value
     * @param int $sP_IsyeriObjId
     * @return \fk_\StructType\KSube
     */
    public function setSP_IsyeriObjId($sP_IsyeriObjId = null)
    {
        // validation for constraint: int
        if (!is_null($sP_IsyeriObjId) && !(is_int($sP_IsyeriObjId) || ctype_digit($sP_IsyeriObjId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sP_IsyeriObjId, true), gettype($sP_IsyeriObjId)), __LINE__);
        }
        $this->SP_IsyeriObjId = $sP_IsyeriObjId;
        return $this;
    }
    /**
     * Get IsTahsilatKapali value
     * @return bool
     */
    public function getIsTahsilatKapali()
    {
        return $this->IsTahsilatKapali;
    }
    /**
     * Set IsTahsilatKapali value
     * @param bool $isTahsilatKapali
     * @return \fk_\StructType\KSube
     */
    public function setIsTahsilatKapali($isTahsilatKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTahsilatKapali) && !is_bool($isTahsilatKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTahsilatKapali, true), gettype($isTahsilatKapali)), __LINE__);
        }
        $this->IsTahsilatKapali = $isTahsilatKapali;
        return $this;
    }
    /**
     * Get IsFaturaKapali value
     * @return bool
     */
    public function getIsFaturaKapali()
    {
        return $this->IsFaturaKapali;
    }
    /**
     * Set IsFaturaKapali value
     * @param bool $isFaturaKapali
     * @return \fk_\StructType\KSube
     */
    public function setIsFaturaKapali($isFaturaKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFaturaKapali) && !is_bool($isFaturaKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFaturaKapali, true), gettype($isFaturaKapali)), __LINE__);
        }
        $this->IsFaturaKapali = $isFaturaKapali;
        return $this;
    }
    /**
     * Get IsTesellumKapali value
     * @return bool
     */
    public function getIsTesellumKapali()
    {
        return $this->IsTesellumKapali;
    }
    /**
     * Set IsTesellumKapali value
     * @param bool $isTesellumKapali
     * @return \fk_\StructType\KSube
     */
    public function setIsTesellumKapali($isTesellumKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTesellumKapali) && !is_bool($isTesellumKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTesellumKapali, true), gettype($isTesellumKapali)), __LINE__);
        }
        $this->IsTesellumKapali = $isTesellumKapali;
        return $this;
    }
    /**
     * Get IsTeslimatKapali value
     * @return bool
     */
    public function getIsTeslimatKapali()
    {
        return $this->IsTeslimatKapali;
    }
    /**
     * Set IsTeslimatKapali value
     * @param bool $isTeslimatKapali
     * @return \fk_\StructType\KSube
     */
    public function setIsTeslimatKapali($isTeslimatKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTeslimatKapali) && !is_bool($isTeslimatKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTeslimatKapali, true), gettype($isTeslimatKapali)), __LINE__);
        }
        $this->IsTeslimatKapali = $isTeslimatKapali;
        return $this;
    }
    /**
     * Get IsYuklemeKapali value
     * @return bool
     */
    public function getIsYuklemeKapali()
    {
        return $this->IsYuklemeKapali;
    }
    /**
     * Set IsYuklemeKapali value
     * @param bool $isYuklemeKapali
     * @return \fk_\StructType\KSube
     */
    public function setIsYuklemeKapali($isYuklemeKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isYuklemeKapali) && !is_bool($isYuklemeKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isYuklemeKapali, true), gettype($isYuklemeKapali)), __LINE__);
        }
        $this->IsYuklemeKapali = $isYuklemeKapali;
        return $this;
    }
    /**
     * Get IsMusteriSozlesmeKapali value
     * @return bool
     */
    public function getIsMusteriSozlesmeKapali()
    {
        return $this->IsMusteriSozlesmeKapali;
    }
    /**
     * Set IsMusteriSozlesmeKapali value
     * @param bool $isMusteriSozlesmeKapali
     * @return \fk_\StructType\KSube
     */
    public function setIsMusteriSozlesmeKapali($isMusteriSozlesmeKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMusteriSozlesmeKapali) && !is_bool($isMusteriSozlesmeKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMusteriSozlesmeKapali, true), gettype($isMusteriSozlesmeKapali)), __LINE__);
        }
        $this->IsMusteriSozlesmeKapali = $isMusteriSozlesmeKapali;
        return $this;
    }
    /**
     * Get IsAracSozlesmeKapali value
     * @return bool
     */
    public function getIsAracSozlesmeKapali()
    {
        return $this->IsAracSozlesmeKapali;
    }
    /**
     * Set IsAracSozlesmeKapali value
     * @param bool $isAracSozlesmeKapali
     * @return \fk_\StructType\KSube
     */
    public function setIsAracSozlesmeKapali($isAracSozlesmeKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAracSozlesmeKapali) && !is_bool($isAracSozlesmeKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAracSozlesmeKapali, true), gettype($isAracSozlesmeKapali)), __LINE__);
        }
        $this->IsAracSozlesmeKapali = $isAracSozlesmeKapali;
        return $this;
    }
    /**
     * Get IsCariKapali value
     * @return bool
     */
    public function getIsCariKapali()
    {
        return $this->IsCariKapali;
    }
    /**
     * Set IsCariKapali value
     * @param bool $isCariKapali
     * @return \fk_\StructType\KSube
     */
    public function setIsCariKapali($isCariKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCariKapali) && !is_bool($isCariKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCariKapali, true), gettype($isCariKapali)), __LINE__);
        }
        $this->IsCariKapali = $isCariKapali;
        return $this;
    }
    /**
     * Get Faaliyettemi value
     * @return bool
     */
    public function getFaaliyettemi()
    {
        return $this->Faaliyettemi;
    }
    /**
     * Set Faaliyettemi value
     * @param bool $faaliyettemi
     * @return \fk_\StructType\KSube
     */
    public function setFaaliyettemi($faaliyettemi = null)
    {
        // validation for constraint: boolean
        if (!is_null($faaliyettemi) && !is_bool($faaliyettemi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($faaliyettemi, true), gettype($faaliyettemi)), __LINE__);
        }
        $this->Faaliyettemi = $faaliyettemi;
        return $this;
    }
    /**
     * Get IsMerkezSITesellumKapali value
     * @return bool
     */
    public function getIsMerkezSITesellumKapali()
    {
        return $this->IsMerkezSITesellumKapali;
    }
    /**
     * Set IsMerkezSITesellumKapali value
     * @param bool $isMerkezSITesellumKapali
     * @return \fk_\StructType\KSube
     */
    public function setIsMerkezSITesellumKapali($isMerkezSITesellumKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMerkezSITesellumKapali) && !is_bool($isMerkezSITesellumKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMerkezSITesellumKapali, true), gettype($isMerkezSITesellumKapali)), __LINE__);
        }
        $this->IsMerkezSITesellumKapali = $isMerkezSITesellumKapali;
        return $this;
    }
    /**
     * Get IsBolgeSITesellumKapali value
     * @return bool
     */
    public function getIsBolgeSITesellumKapali()
    {
        return $this->IsBolgeSITesellumKapali;
    }
    /**
     * Set IsBolgeSITesellumKapali value
     * @param bool $isBolgeSITesellumKapali
     * @return \fk_\StructType\KSube
     */
    public function setIsBolgeSITesellumKapali($isBolgeSITesellumKapali = null)
    {
        // validation for constraint: boolean
        if (!is_null($isBolgeSITesellumKapali) && !is_bool($isBolgeSITesellumKapali)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isBolgeSITesellumKapali, true), gettype($isBolgeSITesellumKapali)), __LINE__);
        }
        $this->IsBolgeSITesellumKapali = $isBolgeSITesellumKapali;
        return $this;
    }
    /**
     * Get GazeteBayiKDVOran value
     * @return float
     */
    public function getGazeteBayiKDVOran()
    {
        return $this->GazeteBayiKDVOran;
    }
    /**
     * Set GazeteBayiKDVOran value
     * @param float $gazeteBayiKDVOran
     * @return \fk_\StructType\KSube
     */
    public function setGazeteBayiKDVOran($gazeteBayiKDVOran = null)
    {
        // validation for constraint: float
        if (!is_null($gazeteBayiKDVOran) && !(is_float($gazeteBayiKDVOran) || is_numeric($gazeteBayiKDVOran))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($gazeteBayiKDVOran, true), gettype($gazeteBayiKDVOran)), __LINE__);
        }
        $this->GazeteBayiKDVOran = $gazeteBayiKDVOran;
        return $this;
    }
    /**
     * Get IsKibris value
     * @return bool
     */
    public function getIsKibris()
    {
        return $this->IsKibris;
    }
    /**
     * Set IsKibris value
     * @param bool $isKibris
     * @return \fk_\StructType\KSube
     */
    public function setIsKibris($isKibris = null)
    {
        // validation for constraint: boolean
        if (!is_null($isKibris) && !is_bool($isKibris)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isKibris, true), gettype($isKibris)), __LINE__);
        }
        $this->IsKibris = $isKibris;
        return $this;
    }
    /**
     * Get IslemTarihi value
     * @return string
     */
    public function getIslemTarihi()
    {
        return $this->IslemTarihi;
    }
    /**
     * Set IslemTarihi value
     * @param string $islemTarihi
     * @return \fk_\StructType\KSube
     */
    public function setIslemTarihi($islemTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($islemTarihi) && !is_string($islemTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($islemTarihi, true), gettype($islemTarihi)), __LINE__);
        }
        $this->IslemTarihi = $islemTarihi;
        return $this;
    }
    /**
     * Get KapatilmaTarihi value
     * @return string
     */
    public function getKapatilmaTarihi()
    {
        return $this->KapatilmaTarihi;
    }
    /**
     * Set KapatilmaTarihi value
     * @param string $kapatilmaTarihi
     * @return \fk_\StructType\KSube
     */
    public function setKapatilmaTarihi($kapatilmaTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($kapatilmaTarihi) && !is_string($kapatilmaTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kapatilmaTarihi, true), gettype($kapatilmaTarihi)), __LINE__);
        }
        $this->KapatilmaTarihi = $kapatilmaTarihi;
        return $this;
    }
    /**
     * Get FaaliyetDurdurulmaTarihi value
     * @return string
     */
    public function getFaaliyetDurdurulmaTarihi()
    {
        return $this->FaaliyetDurdurulmaTarihi;
    }
    /**
     * Set FaaliyetDurdurulmaTarihi value
     * @param string $faaliyetDurdurulmaTarihi
     * @return \fk_\StructType\KSube
     */
    public function setFaaliyetDurdurulmaTarihi($faaliyetDurdurulmaTarihi = null)
    {
        // validation for constraint: string
        if (!is_null($faaliyetDurdurulmaTarihi) && !is_string($faaliyetDurdurulmaTarihi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($faaliyetDurdurulmaTarihi, true), gettype($faaliyetDurdurulmaTarihi)), __LINE__);
        }
        $this->FaaliyetDurdurulmaTarihi = $faaliyetDurdurulmaTarihi;
        return $this;
    }
    /**
     * Get IsSaatKontrolAcik value
     * @return bool
     */
    public function getIsSaatKontrolAcik()
    {
        return $this->IsSaatKontrolAcik;
    }
    /**
     * Set IsSaatKontrolAcik value
     * @param bool $isSaatKontrolAcik
     * @return \fk_\StructType\KSube
     */
    public function setIsSaatKontrolAcik($isSaatKontrolAcik = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSaatKontrolAcik) && !is_bool($isSaatKontrolAcik)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSaatKontrolAcik, true), gettype($isSaatKontrolAcik)), __LINE__);
        }
        $this->IsSaatKontrolAcik = $isSaatKontrolAcik;
        return $this;
    }
    /**
     * Get Adi value
     * @return string|null
     */
    public function getAdi()
    {
        return $this->Adi;
    }
    /**
     * Set Adi value
     * @param string $adi
     * @return \fk_\StructType\KSube
     */
    public function setAdi($adi = null)
    {
        // validation for constraint: string
        if (!is_null($adi) && !is_string($adi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adi, true), gettype($adi)), __LINE__);
        }
        $this->Adi = $adi;
        return $this;
    }
    /**
     * Get Kodu value
     * @return string|null
     */
    public function getKodu()
    {
        return $this->Kodu;
    }
    /**
     * Set Kodu value
     * @param string $kodu
     * @return \fk_\StructType\KSube
     */
    public function setKodu($kodu = null)
    {
        // validation for constraint: string
        if (!is_null($kodu) && !is_string($kodu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($kodu, true), gettype($kodu)), __LINE__);
        }
        $this->Kodu = $kodu;
        return $this;
    }
    /**
     * Get Aciklama value
     * @return string|null
     */
    public function getAciklama()
    {
        return $this->Aciklama;
    }
    /**
     * Set Aciklama value
     * @param string $aciklama
     * @return \fk_\StructType\KSube
     */
    public function setAciklama($aciklama = null)
    {
        // validation for constraint: string
        if (!is_null($aciklama) && !is_string($aciklama)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aciklama, true), gettype($aciklama)), __LINE__);
        }
        $this->Aciklama = $aciklama;
        return $this;
    }
    /**
     * Get BagliOlduguSube value
     * @return \fk_\StructType\KSubePointer|null
     */
    public function getBagliOlduguSube()
    {
        return $this->BagliOlduguSube;
    }
    /**
     * Set BagliOlduguSube value
     * @param \fk_\StructType\KSubePointer $bagliOlduguSube
     * @return \fk_\StructType\KSube
     */
    public function setBagliOlduguSube(\fk_\StructType\KSubePointer $bagliOlduguSube = null)
    {
        $this->BagliOlduguSube = $bagliOlduguSube;
        return $this;
    }
    /**
     * Get BagliOlduguAktarma value
     * @return \fk_\StructType\KSubePointer|null
     */
    public function getBagliOlduguAktarma()
    {
        return $this->BagliOlduguAktarma;
    }
    /**
     * Set BagliOlduguAktarma value
     * @param \fk_\StructType\KSubePointer $bagliOlduguAktarma
     * @return \fk_\StructType\KSube
     */
    public function setBagliOlduguAktarma(\fk_\StructType\KSubePointer $bagliOlduguAktarma = null)
    {
        $this->BagliOlduguAktarma = $bagliOlduguAktarma;
        return $this;
    }
    /**
     * Get Carisi value
     * @return \fk_\StructType\KCariPointer|null
     */
    public function getCarisi()
    {
        return $this->Carisi;
    }
    /**
     * Set Carisi value
     * @param \fk_\StructType\KCariPointer $carisi
     * @return \fk_\StructType\KSube
     */
    public function setCarisi(\fk_\StructType\KCariPointer $carisi = null)
    {
        $this->Carisi = $carisi;
        return $this;
    }
    /**
     * Get Adresi value
     * @return \fk_\StructType\KAdresPointer|null
     */
    public function getAdresi()
    {
        return $this->Adresi;
    }
    /**
     * Set Adresi value
     * @param \fk_\StructType\KAdresPointer $adresi
     * @return \fk_\StructType\KSube
     */
    public function setAdresi(\fk_\StructType\KAdresPointer $adresi = null)
    {
        $this->Adresi = $adresi;
        return $this;
    }
    /**
     * Get IPTel value
     * @return string|null
     */
    public function getIPTel()
    {
        return $this->IPTel;
    }
    /**
     * Set IPTel value
     * @param string $iPTel
     * @return \fk_\StructType\KSube
     */
    public function setIPTel($iPTel = null)
    {
        // validation for constraint: string
        if (!is_null($iPTel) && !is_string($iPTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iPTel, true), gettype($iPTel)), __LINE__);
        }
        $this->IPTel = $iPTel;
        return $this;
    }
    /**
     * Get SabitTel value
     * @return string|null
     */
    public function getSabitTel()
    {
        return $this->SabitTel;
    }
    /**
     * Set SabitTel value
     * @param string $sabitTel
     * @return \fk_\StructType\KSube
     */
    public function setSabitTel($sabitTel = null)
    {
        // validation for constraint: string
        if (!is_null($sabitTel) && !is_string($sabitTel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sabitTel, true), gettype($sabitTel)), __LINE__);
        }
        $this->SabitTel = $sabitTel;
        return $this;
    }
    /**
     * Get Fax value
     * @return string|null
     */
    public function getFax()
    {
        return $this->Fax;
    }
    /**
     * Set Fax value
     * @param string $fax
     * @return \fk_\StructType\KSube
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        $this->Fax = $fax;
        return $this;
    }
    /**
     * Get Gsm value
     * @return string|null
     */
    public function getGsm()
    {
        return $this->Gsm;
    }
    /**
     * Set Gsm value
     * @param string $gsm
     * @return \fk_\StructType\KSube
     */
    public function setGsm($gsm = null)
    {
        // validation for constraint: string
        if (!is_null($gsm) && !is_string($gsm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gsm, true), gettype($gsm)), __LINE__);
        }
        $this->Gsm = $gsm;
        return $this;
    }
    /**
     * Get GsmKisa value
     * @return string|null
     */
    public function getGsmKisa()
    {
        return $this->GsmKisa;
    }
    /**
     * Set GsmKisa value
     * @param string $gsmKisa
     * @return \fk_\StructType\KSube
     */
    public function setGsmKisa($gsmKisa = null)
    {
        // validation for constraint: string
        if (!is_null($gsmKisa) && !is_string($gsmKisa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gsmKisa, true), gettype($gsmKisa)), __LINE__);
        }
        $this->GsmKisa = $gsmKisa;
        return $this;
    }
    /**
     * Get Enlem value
     * @return string|null
     */
    public function getEnlem()
    {
        return $this->Enlem;
    }
    /**
     * Set Enlem value
     * @param string $enlem
     * @return \fk_\StructType\KSube
     */
    public function setEnlem($enlem = null)
    {
        // validation for constraint: string
        if (!is_null($enlem) && !is_string($enlem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enlem, true), gettype($enlem)), __LINE__);
        }
        $this->Enlem = $enlem;
        return $this;
    }
    /**
     * Get Boylam value
     * @return string|null
     */
    public function getBoylam()
    {
        return $this->Boylam;
    }
    /**
     * Set Boylam value
     * @param string $boylam
     * @return \fk_\StructType\KSube
     */
    public function setBoylam($boylam = null)
    {
        // validation for constraint: string
        if (!is_null($boylam) && !is_string($boylam)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($boylam, true), gettype($boylam)), __LINE__);
        }
        $this->Boylam = $boylam;
        return $this;
    }
    /**
     * Get ReferansGrup value
     * @return string|null
     */
    public function getReferansGrup()
    {
        return $this->ReferansGrup;
    }
    /**
     * Set ReferansGrup value
     * @param string $referansGrup
     * @return \fk_\StructType\KSube
     */
    public function setReferansGrup($referansGrup = null)
    {
        // validation for constraint: string
        if (!is_null($referansGrup) && !is_string($referansGrup)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referansGrup, true), gettype($referansGrup)), __LINE__);
        }
        $this->ReferansGrup = $referansGrup;
        return $this;
    }
    /**
     * Get NobetBitSaati value
     * @return string|null
     */
    public function getNobetBitSaati()
    {
        return $this->NobetBitSaati;
    }
    /**
     * Set NobetBitSaati value
     * @param string $nobetBitSaati
     * @return \fk_\StructType\KSube
     */
    public function setNobetBitSaati($nobetBitSaati = null)
    {
        // validation for constraint: string
        if (!is_null($nobetBitSaati) && !is_string($nobetBitSaati)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nobetBitSaati, true), gettype($nobetBitSaati)), __LINE__);
        }
        $this->NobetBitSaati = $nobetBitSaati;
        return $this;
    }
    /**
     * Get EvrakKesimBitSaati value
     * @return string|null
     */
    public function getEvrakKesimBitSaati()
    {
        return $this->EvrakKesimBitSaati;
    }
    /**
     * Set EvrakKesimBitSaati value
     * @param string $evrakKesimBitSaati
     * @return \fk_\StructType\KSube
     */
    public function setEvrakKesimBitSaati($evrakKesimBitSaati = null)
    {
        // validation for constraint: string
        if (!is_null($evrakKesimBitSaati) && !is_string($evrakKesimBitSaati)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($evrakKesimBitSaati, true), gettype($evrakKesimBitSaati)), __LINE__);
        }
        $this->EvrakKesimBitSaati = $evrakKesimBitSaati;
        return $this;
    }
    /**
     * Get KSubeBiyografileri value
     * @return \fk_\ArrayType\ArrayOfKSubeBiyografisi|null
     */
    public function getKSubeBiyografileri()
    {
        return $this->KSubeBiyografileri;
    }
    /**
     * Set KSubeBiyografileri value
     * @param \fk_\ArrayType\ArrayOfKSubeBiyografisi $kSubeBiyografileri
     * @return \fk_\StructType\KSube
     */
    public function setKSubeBiyografileri(\fk_\ArrayType\ArrayOfKSubeBiyografisi $kSubeBiyografileri = null)
    {
        $this->KSubeBiyografileri = $kSubeBiyografileri;
        return $this;
    }
    /**
     * Get GrupNo value
     * @return string|null
     */
    public function getGrupNo()
    {
        return $this->GrupNo;
    }
    /**
     * Set GrupNo value
     * @param string $grupNo
     * @return \fk_\StructType\KSube
     */
    public function setGrupNo($grupNo = null)
    {
        // validation for constraint: string
        if (!is_null($grupNo) && !is_string($grupNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grupNo, true), gettype($grupNo)), __LINE__);
        }
        $this->GrupNo = $grupNo;
        return $this;
    }
    /**
     * Get SubeTipleri value
     * @return string|null
     */
    public function getSubeTipleri()
    {
        return $this->SubeTipleri;
    }
    /**
     * Set SubeTipleri value
     * @param string $subeTipleri
     * @return \fk_\StructType\KSube
     */
    public function setSubeTipleri($subeTipleri = null)
    {
        // validation for constraint: string
        if (!is_null($subeTipleri) && !is_string($subeTipleri)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subeTipleri, true), gettype($subeTipleri)), __LINE__);
        }
        $this->SubeTipleri = $subeTipleri;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \fk_\StructType\KSube
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
