<?php

namespace fk_\EnumType;

/**
 * This class stands for OncekiAylaraKayitGirisSiniriValidasyonAsamalari EnumType
 * @subpackage Enumerations
 */
class OncekiAylaraKayitGirisSiniriValidasyonAsamalari
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'OnayEkraniAciliyor'
     * @return string 'OnayEkraniAciliyor'
     */
    const VALUE_ONAY_EKRANI_ACILIYOR = 'OnayEkraniAciliyor';
    /**
     * Constant for value 'OnayMailiGonderiliyor'
     * @return string 'OnayMailiGonderiliyor'
     */
    const VALUE_ONAY_MAILI_GONDERILIYOR = 'OnayMailiGonderiliyor';
    /**
     * Constant for value 'SifreDogru'
     * @return string 'SifreDogru'
     */
    const VALUE_SIFRE_DOGRU = 'SifreDogru';
    /**
     * Constant for value 'SifreEkraniTekrarAciliyor'
     * @return string 'SifreEkraniTekrarAciliyor'
     */
    const VALUE_SIFRE_EKRANI_TEKRAR_ACILIYOR = 'SifreEkraniTekrarAciliyor';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_ONAY_EKRANI_ACILIYOR
     * @uses self::VALUE_ONAY_MAILI_GONDERILIYOR
     * @uses self::VALUE_SIFRE_DOGRU
     * @uses self::VALUE_SIFRE_EKRANI_TEKRAR_ACILIYOR
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_ONAY_EKRANI_ACILIYOR,
            self::VALUE_ONAY_MAILI_GONDERILIYOR,
            self::VALUE_SIFRE_DOGRU,
            self::VALUE_SIFRE_EKRANI_TEKRAR_ACILIYOR,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
