<?php

namespace fk_\EnumType;

/**
 * This class stands for KWebKargoOdemeTipi EnumType
 * @subpackage Enumerations
 */
class KWebKargoOdemeTipi
{
    /**
     * Constant for value 'POCH'
     * @return string 'POCH'
     */
    const VALUE_POCH = 'POCH';
    /**
     * Constant for value 'UA'
     * @return string 'UA'
     */
    const VALUE_UA = 'UA';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_POCH
     * @uses self::VALUE_UA
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_POCH,
            self::VALUE_UA,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
