<?php

namespace fk_\EnumType;

/**
 * This class stands for KVergiLevhasi EnumType
 * @subpackage Enumerations
 */
class KVergiLevhasi
{
    /**
     * Constant for value 'Goruldu'
     * @return string 'Goruldu'
     */
    const VALUE_GORULDU = 'Goruldu';
    /**
     * Constant for value 'Gorulmedi'
     * @return string 'Gorulmedi'
     */
    const VALUE_GORULMEDI = 'Gorulmedi';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_GORULDU
     * @uses self::VALUE_GORULMEDI
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_GORULDU,
            self::VALUE_GORULMEDI,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
