<?php

namespace fk_\EnumType;

/**
 * This class stands for KTeslimatGirisTur EnumType
 * @subpackage Enumerations
 */
class KTeslimatGirisTur
{
    /**
     * Constant for value 'TopluTeslimattan'
     * @return string 'TopluTeslimattan'
     */
    const VALUE_TOPLU_TESLIMATTAN = 'TopluTeslimattan';
    /**
     * Constant for value 'MerkezTeslimati'
     * @return string 'MerkezTeslimati'
     */
    const VALUE_MERKEZ_TESLIMATI = 'MerkezTeslimati';
    /**
     * Constant for value 'CepTen'
     * @return string 'CepTen'
     */
    const VALUE_CEP_TEN = 'CepTen';
    /**
     * Constant for value 'ElTerminali'
     * @return string 'ElTerminali'
     */
    const VALUE_EL_TERMINALI = 'ElTerminali';
    /**
     * Constant for value 'SubeGunSonu'
     * @return string 'SubeGunSonu'
     */
    const VALUE_SUBE_GUN_SONU = 'SubeGunSonu';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TOPLU_TESLIMATTAN
     * @uses self::VALUE_MERKEZ_TESLIMATI
     * @uses self::VALUE_CEP_TEN
     * @uses self::VALUE_EL_TERMINALI
     * @uses self::VALUE_SUBE_GUN_SONU
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TOPLU_TESLIMATTAN,
            self::VALUE_MERKEZ_TESLIMATI,
            self::VALUE_CEP_TEN,
            self::VALUE_EL_TERMINALI,
            self::VALUE_SUBE_GUN_SONU,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
